/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.scope;

import com.atlassian.plugins.rest.common.interceptor.MethodInvocation;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;

public class RequestScope
implements Scope {
    final Logger logger = LoggerFactory.getLogger(RequestScope.class);
    private final ThreadLocal<Deque<Request>> currentRequests = new ThreadLocal();

    public Object get(String name, ObjectFactory objectFactory) {
        return this.currentRequest().getBean(name, objectFactory);
    }

    public Object remove(String name) {
        return this.currentRequest().removeBean(name);
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        this.currentRequest().registerDestructionCallback(name, callback);
    }

    public Object resolveContextualObject(String s) {
        return null;
    }

    public String getConversationId() {
        Request request = this.currentRequest();
        return request != null ? request.toString() : null;
    }

    static Deque<Request> getRequests(ThreadLocal<Deque<Request>> local) {
        Deque<Request> requests = local.get();
        if (requests == null) {
            requests = new ArrayDeque<Request>();
            local.set(requests);
        }
        return requests;
    }

    Request beginRequest(MethodInvocation invocation) {
        Deque<Request> requests = RequestScope.getRequests(this.currentRequests);
        Request request = new Request(invocation);
        requests.addFirst(request);
        return request;
    }

    Request currentRequest() {
        Deque<Request> requests = RequestScope.getRequests(this.currentRequests);
        if (requests.isEmpty()) {
            return null;
        }
        return requests.getFirst();
    }

    MethodInvocation currentInvocation() {
        Request request = this.currentRequest();
        return request != null ? request.invocation : null;
    }

    class Request {
        final MethodInvocation invocation;
        private final Map<String, Object> beans = Maps.newHashMap();
        private final Multimap<String, Runnable> destructionCallbacks = HashMultimap.create();

        Request(MethodInvocation invocation) {
            this.invocation = invocation;
        }

        void registerDestructionCallback(String name, Runnable callback) {
            this.destructionCallbacks.put((Object)name, (Object)callback);
        }

        public Object getBean(String name, ObjectFactory objectFactory) {
            Object bean = this.beans.get(name);
            if (bean == null) {
                bean = objectFactory.getObject();
                this.beans.put(name, bean);
            }
            return bean;
        }

        public Object removeBean(String beanName) {
            return this.beans.remove(beanName);
        }

        void destroy() {
            Deque<Request> requests = RequestScope.getRequests(RequestScope.this.currentRequests);
            requests.removeFirst();
            RequestScope.this.logger.trace("Calling destruction callbacks...");
            for (Map.Entry callbackWithBeanName : this.destructionCallbacks.entries()) {
                String beanName = (String)callbackWithBeanName.getKey();
                Runnable callback = (Runnable)callbackWithBeanName.getValue();
                try {
                    callback.run();
                    RequestScope.this.logger.trace("Finished callback for bean '{}': {}", (Object)beanName, (Object)callback);
                }
                catch (RuntimeException e) {
                    RequestScope.this.logger.error(String.format("Error calling destruction callback for bean '%s': ", beanName));
                }
            }
        }
    }
}

