/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.attachment.format;

import com.atlassian.core.util.FileSize;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.Path;
import com.atlassian.jira.plugin.attachment.AttachmentArchive;
import com.atlassian.jira.plugin.attachment.AttachmentArchiveEntry;
import com.atlassian.jira.rest.v2.issue.attachment.format.ArchiveFormatter;
import com.atlassian.jira.rest.v2.issue.attachment.format.HumanReadableArchive;
import com.atlassian.jira.rest.v2.issue.attachment.format.HumanReadableArchiveEntry;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

final class ArchiveHumanFormatter
implements ArchiveFormatter<HumanReadableArchive> {
    private static final int MAX_ENTRY_LABEL_LENGTH = 40;

    ArchiveHumanFormatter() {
    }

    @Override
    public HumanReadableArchive format(AttachmentArchive archive, Attachment attachment) {
        Long id = attachment.getId();
        List entries = archive.getEntries();
        Collection<HumanReadableArchiveEntry> convertedEntries = this.convertEntries(entries);
        String name = attachment.getFilename();
        int totalEntryCount = archive.getTotalEntryCount();
        String mediaType = attachment.getMimetype();
        return new HumanReadableArchive(id, name, convertedEntries, totalEntryCount, mediaType);
    }

    private Collection<HumanReadableArchiveEntry> convertEntries(Iterable<AttachmentArchiveEntry> entries) {
        ImmutableList.Builder convertedEntries = ImmutableList.builder();
        for (AttachmentArchiveEntry entry : entries) {
            HumanReadableArchiveEntry convertedEntry = this.convertEntry(entry);
            convertedEntries.add((Object)convertedEntry);
        }
        return convertedEntries.build();
    }

    private HumanReadableArchiveEntry convertEntry(AttachmentArchiveEntry archiveEntry) {
        Path path = new Path((CharSequence)archiveEntry.getName());
        long index = archiveEntry.getEntryIndex();
        String size = FileSize.format((long)archiveEntry.getSize());
        String mediaType = archiveEntry.getMediaType();
        String label = path.abbreviate(40).toString();
        return new HumanReadableArchiveEntry(path.toString(), index, size, mediaType, label);
    }
}

