/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.attachment.authorization;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.v2.issue.attachment.authorization.AttachmentAuthorizer;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import javax.annotation.Nullable;

final class AttachmentViewAuthorizer
implements AttachmentAuthorizer {
    private final PermissionManager permissionManager;

    AttachmentViewAuthorizer(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Override
    public boolean authorize(Attachment attachment, @Nullable ApplicationUser user) {
        Issue issue = attachment.getIssue();
        return this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, issue, user);
    }

    @Override
    public String getNoPermissionMessage(I18nHelper i18n, Object attachmentId) {
        return i18n.getText("attachment.service.error.view.no.permission", attachmentId);
    }
}

