/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.project.version.DeleteVersionWithReplacementsParameterBuilder;
import com.atlassian.jira.bc.project.version.RemoveVersionAction;
import com.atlassian.jira.bc.project.version.SwapVersionAction;
import com.atlassian.jira.bc.project.version.VersionBuilder;
import com.atlassian.jira.bc.project.version.VersionService;
import com.atlassian.jira.event.project.VersionCreatedViaRestEvent;
import com.atlassian.jira.project.version.DeleteVersionWithCustomFieldParameters;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.BadRequestWebException;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.v2.entity.RemoteEntityLinkJsonBean;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.version.DeleteAndReplaceVersionBean;
import com.atlassian.jira.rest.v2.issue.version.RemoteVersionLinkResource;
import com.atlassian.jira.rest.v2.issue.version.VersionBean;
import com.atlassian.jira.rest.v2.issue.version.VersionBeanFactory;
import com.atlassian.jira.rest.v2.issue.version.VersionIssueCountsBean;
import com.atlassian.jira.rest.v2.issue.version.VersionIssueCountsBeanFactory;
import com.atlassian.jira.rest.v2.issue.version.VersionMoveBean;
import com.atlassian.jira.rest.v2.issue.version.VersionUnresolvedIssueCountsBean;
import com.atlassian.jira.rest.v2.issue.version.VersionUnresolvedIssueCountsBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.DateFieldFormat;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

@Path(value="version")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class VersionResource {
    private VersionService versionService;
    private ProjectService projectService;
    private JiraAuthenticationContext authContext;
    private I18nHelper i18n;
    private RemoteVersionLinkResource remoteVersionLinkResource;
    private VersionBeanFactory versionBeanFactory;
    private VersionIssueCountsBeanFactory versionIssueCountsBeanFactory;
    private VersionUnresolvedIssueCountsBeanFactory versionUnresolvedIssueCountsBeanFactory;
    private DateFieldFormat dateFieldFormat;
    private EventPublisher eventPublisher;

    private VersionResource() {
    }

    public VersionResource(VersionService versionService, ProjectService projectService, JiraAuthenticationContext authContext, I18nHelper i18n, RemoteVersionLinkResource remoteVersionLinkResource, VersionBeanFactory versionBeanFactory, VersionIssueCountsBeanFactory versionIssueCountsBeanFactory, VersionUnresolvedIssueCountsBeanFactory versionUnresolvedIssueCountsBeanFactory, DateFieldFormat dateFieldFormat, EventPublisher eventPublisher) {
        this.projectService = projectService;
        this.authContext = authContext;
        this.versionService = versionService;
        this.i18n = i18n;
        this.remoteVersionLinkResource = remoteVersionLinkResource;
        this.versionBeanFactory = versionBeanFactory;
        this.versionIssueCountsBeanFactory = versionIssueCountsBeanFactory;
        this.versionUnresolvedIssueCountsBeanFactory = versionUnresolvedIssueCountsBeanFactory;
        this.dateFieldFormat = dateFieldFormat;
        this.eventPublisher = eventPublisher;
    }

    @GET
    @ResponseType(value=VersionBean.class)
    @Path(value="{id}")
    public Response getVersion(@PathParam(value="id") String id, @QueryParam(value="expand") String expand) {
        Version version = this.getVersionBy(id);
        boolean expandOps = expand != null && expand.contains("operations");
        boolean expandRemoteLinks = expand != null && expand.contains("remotelinks");
        return Response.ok((Object)this.versionBeanFactory.createVersionBean(version, expandOps, expandRemoteLinks)).cacheControl(CacheControl.never()).build();
    }

    @PUT
    @ResponseType(value=VersionBean.class)
    @RequestType(value=VersionBean.class)
    @Path(value="{id}")
    public Response updateVersion(@PathParam(value="id") String id, VersionBean bean) {
        if (bean.isStartDateSet() && bean.getUserStartDate() != null) {
            return this.createErrorResponse(Response.Status.BAD_REQUEST, "rest.version.edit.two.start.dates");
        }
        if (bean.isReleaseDateSet() && bean.getUserReleaseDate() != null) {
            return this.createErrorResponse(Response.Status.BAD_REQUEST, "rest.version.edit.two.release.dates");
        }
        Version version = this.getVersionBy(id);
        ServiceOutcome<Date> startDateOutcome = this.parseDateEdit("startDate", bean.isStartDateSet(), bean.getStartDate(), bean.getUserStartDate(), version.getStartDate());
        Date startDate = startDateOutcome.isValid() ? (Date)startDateOutcome.getReturnedValue() : null;
        ServiceOutcome<Date> releaseDateOutcome = this.parseDateEdit("releaseDate", bean.isReleaseDateSet(), bean.getReleaseDate(), bean.getUserReleaseDate(), version.getReleaseDate());
        Date releaseDate = releaseDateOutcome.isValid() ? (Date)releaseDateOutcome.getReturnedValue() : null;
        VersionBuilder builder = this.versionService.newVersionBuilder(version);
        if (bean.getName() != null) {
            builder.name(bean.getName());
        }
        if (bean.getDescription() != null) {
            builder.description(bean.getDescription());
        }
        builder.startDate(startDate).releaseDate(releaseDate);
        VersionService.VersionBuilderValidationResult validationResult = this.versionService.validateUpdate(this.getUser(), builder);
        validationResult.getErrorCollection().addErrorCollection(this.validateArchiveReleaseUpdate(bean, version));
        validationResult.getErrorCollection().addErrorCollection(startDateOutcome.getErrorCollection());
        validationResult.getErrorCollection().addErrorCollection(releaseDateOutcome.getErrorCollection());
        if (!validationResult.isValid()) {
            throw new BadRequestWebException(ErrorCollection.of(validationResult.getErrorCollection()));
        }
        this.performUpdate(bean, validationResult);
        return this.getVersion(id, bean.getExpand());
    }

    private com.atlassian.jira.util.ErrorCollection validateArchiveReleaseUpdate(VersionBean bean, Version currentVersion) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (bean.isArchived() != null) {
            errors.addErrorCollection(this.validateArchived(bean, currentVersion));
        }
        if (bean.isReleased() != null) {
            errors.addErrorCollection(this.validateReleased(bean, currentVersion));
        }
        return errors;
    }

    private com.atlassian.jira.util.ErrorCollection validateArchived(VersionBean bean, Version currentVersion) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (bean.isArchived().booleanValue() && !currentVersion.isArchived()) {
            VersionService.ArchiveVersionValidationResult validationResult = this.versionService.validateArchiveVersion(this.getUser(), currentVersion);
            errors.addErrorCollection(validationResult.getErrorCollection());
        } else if (!bean.isArchived().booleanValue() && currentVersion.isArchived()) {
            VersionService.ArchiveVersionValidationResult validationResult = this.versionService.validateUnarchiveVersion(this.getUser(), currentVersion);
            errors.addErrorCollection(validationResult.getErrorCollection());
        }
        return errors;
    }

    private com.atlassian.jira.util.ErrorCollection validateReleased(VersionBean bean, Version currentVersion) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (bean.isReleased().booleanValue() && !currentVersion.isReleased()) {
            VersionService.ReleaseVersionValidationResult result = bean.isReleaseDateSet() ? this.versionService.validateReleaseVersion(this.getUser(), currentVersion, bean.getReleaseDate()) : (bean.getUserReleaseDate() != null ? this.versionService.validateReleaseVersion(this.getUser(), currentVersion, bean.getUserReleaseDate()) : this.versionService.validateReleaseVersion(this.getUser(), currentVersion, currentVersion.getReleaseDate()));
            errors.addErrorCollection(result.getErrorCollection());
        } else if (!bean.isReleased().booleanValue() && currentVersion.isReleased()) {
            VersionService.ReleaseVersionValidationResult result = bean.isReleaseDateSet() ? this.versionService.validateUnreleaseVersion(this.getUser(), currentVersion, bean.getReleaseDate()) : (bean.getUserReleaseDate() != null ? this.versionService.validateUnreleaseVersion(this.getUser(), currentVersion, bean.getUserReleaseDate()) : this.versionService.validateUnreleaseVersion(this.getUser(), currentVersion, currentVersion.getReleaseDate()));
            errors.addErrorCollection(result.getErrorCollection());
        }
        return errors;
    }

    private void performUpdate(VersionBean bean, VersionService.VersionBuilderValidationResult validationResult) {
        ServiceOutcome updateOutcome = this.versionService.update(this.getUser(), validationResult);
        if (!updateOutcome.isValid()) {
            this.throwWebException(updateOutcome.getErrorCollection());
        }
        Version nextVersion = (Version)updateOutcome.getReturnedValue();
        if (bean.isArchived() != null) {
            this.updateArchived(bean, nextVersion);
        }
        if (bean.isReleased() != null) {
            this.updateReleased(bean, nextVersion);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateArchived(VersionBean bean, Version currentVersion) {
        if (bean.isArchived().booleanValue() && !currentVersion.isArchived()) {
            VersionService.ArchiveVersionValidationResult validationResult = this.versionService.validateArchiveVersion(this.getUser(), currentVersion);
            if (!validationResult.isValid()) throw new RESTException(Response.Status.FORBIDDEN, ErrorCollection.of(validationResult.getErrorCollection()));
            this.versionService.archiveVersion(validationResult);
            return;
        } else {
            if (bean.isArchived().booleanValue() || !currentVersion.isArchived()) return;
            VersionService.ArchiveVersionValidationResult validationResult = this.versionService.validateUnarchiveVersion(this.getUser(), currentVersion);
            if (!validationResult.isValid()) throw new RESTException(Response.Status.FORBIDDEN, ErrorCollection.of(validationResult.getErrorCollection()));
            this.versionService.unarchiveVersion(validationResult);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateReleased(VersionBean bean, Version currentVersion) {
        if (bean.isReleased().booleanValue() && !currentVersion.isReleased()) {
            VersionService.ReleaseVersionValidationResult validationResult = bean.isReleaseDateSet() ? this.versionService.validateReleaseVersion(this.getUser(), currentVersion, bean.getReleaseDate()) : (bean.getUserReleaseDate() != null ? this.versionService.validateReleaseVersion(this.getUser(), currentVersion, bean.getUserReleaseDate()) : this.versionService.validateReleaseVersion(this.getUser(), currentVersion, currentVersion.getReleaseDate()));
            if (!validationResult.isValid()) throw new RESTException(Response.Status.FORBIDDEN, ErrorCollection.of(validationResult.getErrorCollection()));
            if (bean.getMoveUnfixedIssuesTo() != null) {
                long moveToId = this.getVersionIdFromSelfLink(bean.getMoveUnfixedIssuesTo().getPath());
                VersionService.VersionResult result = this.versionService.getVersionById(this.authContext.getUser(), Long.valueOf(moveToId));
                if (!result.isValid()) {
                    throw new NotFoundWebException(ErrorCollection.of(result.getErrorCollection()));
                }
                this.versionService.moveUnreleasedToNewVersion(this.getUser(), currentVersion, result.getVersion());
            }
            this.versionService.releaseVersion(validationResult);
            return;
        } else {
            if (bean.isReleased().booleanValue() || !currentVersion.isReleased()) return;
            VersionService.ReleaseVersionValidationResult validationResult = bean.isReleaseDateSet() ? this.versionService.validateUnreleaseVersion(this.getUser(), currentVersion, bean.getReleaseDate()) : (bean.getUserReleaseDate() != null ? this.versionService.validateUnreleaseVersion(this.getUser(), currentVersion, bean.getUserReleaseDate()) : this.versionService.validateUnreleaseVersion(this.getUser(), currentVersion, currentVersion.getReleaseDate()));
            if (!validationResult.isValid()) throw new RESTException(Response.Status.FORBIDDEN, ErrorCollection.of(validationResult.getErrorCollection()));
            this.versionService.unreleaseVersion(validationResult);
        }
    }

    @POST
    @ResponseType(value=VersionBean.class)
    @RequestType(value=VersionBean.class)
    public Response createVersion(VersionBean bean) {
        ProjectService.GetProjectResult getResult;
        if (StringUtils.isBlank((String)bean.getProject()) && bean.getProjectId() == null) {
            return this.createErrorResponse(Response.Status.BAD_REQUEST, "rest.version.create.no.project");
        }
        if (bean.isStartDateSet() && bean.getUserStartDate() != null) {
            return this.createErrorResponse(Response.Status.BAD_REQUEST, "rest.version.create.two.start.dates");
        }
        if (bean.isReleaseDateSet() && bean.getUserReleaseDate() != null) {
            return this.createErrorResponse(Response.Status.BAD_REQUEST, "rest.version.create.two.release.dates");
        }
        ApplicationUser user = this.getUser();
        ProjectService.GetProjectResult getProjectResult = getResult = bean.getProjectId() != null ? this.projectService.getProjectByIdForAction(user, bean.getProjectId(), ProjectAction.EDIT_PROJECT_CONFIG) : this.projectService.getProjectByKeyForAction(user, bean.getProject(), ProjectAction.EDIT_PROJECT_CONFIG);
        if (!getResult.isValid()) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.version.no.create.permission", bean.getProject())));
        }
        ServiceOutcome<Date> startDateOutcome = this.parseDate("startDate", bean.isStartDateSet(), bean.getStartDate(), bean.getUserStartDate());
        Date startDate = startDateOutcome.isValid() ? (Date)startDateOutcome.getReturnedValue() : null;
        ServiceOutcome<Date> releaseDateOutcome = this.parseDate("releaseDate", bean.isReleaseDateSet(), bean.getReleaseDate(), bean.getUserReleaseDate());
        Date releaseDate = releaseDateOutcome.isValid() ? (Date)releaseDateOutcome.getReturnedValue() : null;
        boolean released = BooleanUtils.toBoolean((Boolean)bean.isReleased());
        VersionBuilder builder = this.versionService.newVersionBuilder().projectId(getResult.getProject().getId()).name(bean.getName()).description(bean.getDescription()).startDate(startDate).releaseDate(releaseDate).released(released);
        VersionService.VersionBuilderValidationResult validateCreateResult = this.versionService.validateCreate(user, builder);
        validateCreateResult.getErrorCollection().addErrorCollection(startDateOutcome.getErrorCollection());
        validateCreateResult.getErrorCollection().addErrorCollection(releaseDateOutcome.getErrorCollection());
        if (!validateCreateResult.isValid()) {
            if (validateCreateResult.getSpecificReasons().contains(VersionService.CreateVersionValidationResult.Reason.FORBIDDEN)) {
                return this.createErrorResponse(Response.Status.NOT_FOUND, ErrorCollection.of(this.i18n.getText("rest.version.no.create.permission", bean.getProject())));
            }
            return this.createErrorResponse(Response.Status.BAD_REQUEST, (ServiceResult)validateCreateResult);
        }
        ServiceOutcome versionOutcome = this.versionService.create(user, validateCreateResult);
        if (!versionOutcome.isValid()) {
            return this.createErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, (ServiceResult)versionOutcome);
        }
        this.eventPublisher.publish((Object)new VersionCreatedViaRestEvent((Version)versionOutcome.getReturnedValue()));
        boolean expandOps = bean.getExpand() != null && bean.getExpand().contains("operations");
        boolean expandRemoteLinks = bean.getExpand() != null && bean.getExpand().contains("remotelinks");
        VersionBean versionBean = this.versionBeanFactory.createVersionBean((Version)versionOutcome.getReturnedValue(), expandOps, expandRemoteLinks);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)versionBean).location(versionBean.getSelf()).cacheControl(CacheControl.never()).build();
    }

    private Response createErrorResponse(Response.Status status, String key) {
        return this.createErrorResponse(status, ErrorCollection.of(this.i18n.getText(key)));
    }

    private Response createErrorResponse(Response.Status status, ServiceResult outcome) {
        return this.createErrorResponse(status, ErrorCollection.of(outcome.getErrorCollection()));
    }

    private Response createErrorResponse(Response.Status status, ErrorCollection errorCollection) {
        return Response.status((Response.Status)status).entity((Object)errorCollection).cacheControl(CacheControl.never()).build();
    }

    private ServiceOutcome<Date> parseDate(String fieldName, boolean set, Date date, String dateStr) {
        if (set) {
            return ServiceOutcomeImpl.ok((Object)date);
        }
        if (StringUtils.isEmpty((String)dateStr)) {
            return ServiceOutcomeImpl.ok(null);
        }
        try {
            return ServiceOutcomeImpl.ok((Object)this.dateFieldFormat.parseDatePicker(dateStr));
        }
        catch (IllegalArgumentException exc) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            errorCollection.addError(fieldName, this.i18n.getText("admin.errors.incorrect.date.format", this.dateFieldFormat.getFormatHint()));
            return ServiceOutcomeImpl.from((com.atlassian.jira.util.ErrorCollection)errorCollection, null);
        }
    }

    private ServiceOutcome<Date> parseDateEdit(String fieldName, boolean set, Date date, String dateStr, Date originalDate) {
        if (set) {
            if (date == null || !date.equals(originalDate)) {
                return ServiceOutcomeImpl.ok((Object)date);
            }
            return ServiceOutcomeImpl.ok((Object)originalDate);
        }
        if (dateStr == null) {
            return ServiceOutcomeImpl.ok((Object)originalDate);
        }
        if (dateStr.length() == 0) {
            return ServiceOutcomeImpl.ok(null);
        }
        try {
            return ServiceOutcomeImpl.ok((Object)this.dateFieldFormat.parseDatePicker(dateStr));
        }
        catch (IllegalArgumentException exc) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            errorCollection.addError(fieldName, this.i18n.getText("admin.errors.incorrect.date.format", this.dateFieldFormat.getFormatHint()));
            return ServiceOutcomeImpl.from((com.atlassian.jira.util.ErrorCollection)errorCollection, null);
        }
    }

    @DELETE
    @Path(value="{id}")
    public Response delete(@PathParam(value="id") String id, @QueryParam(value="moveFixIssuesTo") String moveFixIssuesTo, @QueryParam(value="moveAffectedIssuesTo") String moveAffectedIssuesTo) {
        Version version = this.getVersionBy(id);
        Object fixAction = moveFixIssuesTo != null ? new SwapVersionAction(Long.valueOf(this.getVersionIdFromSelfLink(moveFixIssuesTo))) : new RemoveVersionAction();
        Object affectedAction = moveAffectedIssuesTo != null ? new SwapVersionAction(Long.valueOf(this.getVersionIdFromSelfLink(moveAffectedIssuesTo))) : new RemoveVersionAction();
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(this.authContext.getUser());
        VersionService.ValidationResult deleteValidationResult = this.versionService.validateDelete((JiraServiceContext)serviceContext, version.getId(), (VersionService.VersionAction)affectedAction, (VersionService.VersionAction)fixAction);
        this.checkDeleteResult(deleteValidationResult);
        this.versionService.delete((JiraServiceContext)serviceContext, deleteValidationResult);
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{id}/removeAndSwap")
    @Consumes(value={"application/json"})
    @ResponseType(value=Void.class)
    public Response delete(@PathParam(value="id") String id, DeleteAndReplaceVersionBean parameters) {
        Version versionToDelete = this.getVersionBy(id);
        DeleteVersionWithReplacementsParameterBuilder versionDeleteAndReplaceParameters = this.versionService.createVersionDeletaAndReplaceParameters(versionToDelete);
        Optional.ofNullable(parameters.getMoveAffectedIssuesTo()).map(this::getVersionBy).ifPresent(arg_0 -> ((DeleteVersionWithReplacementsParameterBuilder)versionDeleteAndReplaceParameters).moveAffectedIssuesTo(arg_0));
        Optional.ofNullable(parameters.getMoveFixIssuesTo()).map(this::getVersionBy).ifPresent(arg_0 -> ((DeleteVersionWithReplacementsParameterBuilder)versionDeleteAndReplaceParameters).moveFixIssuesTo(arg_0));
        Optional.ofNullable(parameters.getCustomFieldReplacementList()).ifPresent(replacementsList -> replacementsList.stream().filter(replacement -> null != replacement.getCustomFieldId() && null != replacement.getMoveTo()).forEach(replacement -> versionDeleteAndReplaceParameters.moveCustomFieldTo(replacement.getCustomFieldId().longValue(), this.getVersionBy(replacement.getMoveTo()))));
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(this.authContext.getUser());
        DeleteVersionWithCustomFieldParameters replaceParams = versionDeleteAndReplaceParameters.build();
        ServiceResult serviceResult = this.versionService.deleteVersionAndSwap((JiraServiceContext)serviceContext, replaceParams);
        if (!serviceResult.isValid()) {
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(serviceResult.getErrorCollection()));
        }
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    @PUT
    @Path(value="{id}/mergeto/{moveIssuesTo}")
    @ResponseType(value=Void.class)
    public Response merge(@PathParam(value="id") String id, @PathParam(value="moveIssuesTo") String moveIssuesTo) {
        Version version = this.getVersionBy(id);
        Version destinationVersion = this.getVersionBy(moveIssuesTo);
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(this.authContext.getUser());
        VersionService.ValidationResult deleteValidationResult = this.versionService.validateMerge((JiraServiceContext)serviceContext, version.getId(), destinationVersion.getId());
        this.checkDeleteResult(deleteValidationResult);
        this.versionService.merge((JiraServiceContext)serviceContext, deleteValidationResult);
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    private void checkDeleteResult(VersionService.ValidationResult validationResult) {
        if (!validationResult.isValid()) {
            if (validationResult.getReasons().contains(VersionService.ValidationResult.Reason.FORBIDDEN)) {
                throw new NotAuthorisedWebException(ErrorCollection.of(validationResult.getErrorCollection()));
            }
            if (validationResult.getReasons().contains(VersionService.MoveVersionValidationResult.Reason.NOT_FOUND)) {
                throw new NotFoundWebException(ErrorCollection.of(validationResult.getErrorCollection()));
            }
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(validationResult.getErrorCollection()));
        }
    }

    @GET
    @ResponseType(value=VersionIssueCountsBean.class)
    @Path(value="{id}/relatedIssueCounts")
    public Response getVersionRelatedIssues(@PathParam(value="id") String id) {
        Version version = this.getVersionBy(id);
        long fixIssueCount = this.versionService.getFixIssuesCount(version);
        long affectsIssueCount = this.versionService.getAffectsIssuesCount(version);
        Collection customFieldsUseForVersion = this.versionService.getCustomFieldsUsing(version);
        long issuesWithCustomFieldsCount = this.versionService.getCustomFieldIssuesCount(version);
        return Response.ok((Object)this.versionIssueCountsBeanFactory.createVersionBean(version, fixIssueCount, affectsIssueCount, issuesWithCustomFieldsCount, customFieldsUseForVersion)).cacheControl(CacheControl.never()).build();
    }

    @GET
    @ResponseType(value=VersionUnresolvedIssueCountsBean.class)
    @Path(value="{id}/unresolvedIssueCount")
    public Response getVersionUnresolvedIssues(@PathParam(value="id") String id) {
        ApplicationUser loggedInUser = this.getUser();
        Version version = this.getVersionBy(id);
        long unresolvedIssueCount = this.versionService.getUnresolvedIssuesCount(loggedInUser, version);
        return Response.ok((Object)this.versionUnresolvedIssueCountsBeanFactory.createVersionBean(version, unresolvedIssueCount)).cacheControl(CacheControl.never()).build();
    }

    @POST
    @RequestType(value=VersionMoveBean.class)
    @ResponseType(value=VersionBean.class)
    @Path(value="/{id}/move")
    public Response moveVersion(@PathParam(value="id") String id, VersionMoveBean bean) {
        block8: {
            ApplicationUser user;
            long versionId;
            block7: {
                String expand = "operations";
                versionId = this.parseVersionId(id);
                user = this.getUser();
                if (bean.position == null) break block7;
                switch (bean.position) {
                    case Earlier: {
                        VersionService.MoveVersionValidationResult moveValidationResult = this.versionService.validateIncreaseVersionSequence(user, versionId);
                        this.checkMoveResult(moveValidationResult);
                        this.versionService.increaseVersionSequence(moveValidationResult);
                        break block8;
                    }
                    case Later: {
                        VersionService.MoveVersionValidationResult moveValidationResult = this.versionService.validateDecreaseVersionSequence(user, versionId);
                        this.checkMoveResult(moveValidationResult);
                        this.versionService.decreaseVersionSequence(moveValidationResult);
                        break block8;
                    }
                    case First: {
                        VersionService.MoveVersionValidationResult moveValidationResult = this.versionService.validateMoveToStartVersionSequence(user, versionId);
                        this.checkMoveResult(moveValidationResult);
                        this.versionService.moveToStartVersionSequence(moveValidationResult);
                        break block8;
                    }
                    case Last: {
                        VersionService.MoveVersionValidationResult moveValidationResult = this.versionService.validateMoveToEndVersionSequence(user, versionId);
                        this.checkMoveResult(moveValidationResult);
                        this.versionService.moveToEndVersionSequence(moveValidationResult);
                        break block8;
                    }
                    default: {
                        throw new RESTException(Response.Status.BAD_REQUEST, this.i18n.getText("admin.errors.version.move.target.invalid"));
                    }
                }
            }
            if (bean.after != null) {
                long afterVersionId = this.getVersionIdFromSelfLink(bean.after.getPath());
                VersionService.MoveVersionValidationResult moveValidationResult = this.versionService.validateMoveVersionAfter(user, versionId, Long.valueOf(afterVersionId));
                this.checkMoveResult(moveValidationResult);
                this.versionService.moveVersionAfter(moveValidationResult);
            }
        }
        return this.getVersion(id, "operations");
    }

    @GET
    @ResponseType(value=List.class, genericTypes={RemoteEntityLinkJsonBean.class})
    @Path(value="remotelink")
    public Response getRemoteVersionLinks(@QueryParam(value="globalId") String globalId) {
        return this.remoteVersionLinkResource.getRemoteVersionLinksByGlobalId(globalId);
    }

    @GET
    @ResponseType(value=RemoteEntityLinkJsonBean.class)
    @Path(value="{versionId}/remotelink")
    public Response getRemoteVersionLinksByVersionId(@PathParam(value="versionId") String versionId) {
        return this.remoteVersionLinkResource.getRemoteVersionLinksByVersionId(this.parseVersionId(versionId));
    }

    @GET
    @ResponseType(value=RemoteEntityLinkJsonBean.class)
    @Path(value="{versionId}/remotelink/{globalId}")
    public Response getRemoteVersionLink(@PathParam(value="versionId") String versionId, @PathParam(value="globalId") String globalId) {
        if (StringUtils.isBlank((String)globalId)) {
            return this.remoteVersionLinkResource.getRemoteVersionLinksByVersionId(this.parseVersionId(versionId));
        }
        return this.remoteVersionLinkResource.getRemoteVersionLink(this.parseVersionId(versionId), globalId);
    }

    @POST
    @Path(value="{versionId}/remotelink")
    @ResponseType(value=Void.class)
    public Response createOrUpdateRemoteVersionLink(@PathParam(value="versionId") String versionId, String json) {
        return this.remoteVersionLinkResource.putRemoteVersionLink(this.parseVersionId(versionId), null, json);
    }

    @POST
    @Path(value="{versionId}/remotelink/{globalId}")
    @ResponseType(value=Void.class)
    public Response createOrUpdateRemoteVersionLink(@PathParam(value="versionId") String versionId, @PathParam(value="globalId") String globalId, String json) {
        return this.remoteVersionLinkResource.putRemoteVersionLink(this.parseVersionId(versionId), globalId, json);
    }

    @DELETE
    @Path(value="{versionId}/remotelink")
    public Response deleteRemoteVersionLinksByVersionId(@PathParam(value="versionId") String versionId) {
        return this.remoteVersionLinkResource.deleteRemoteVersionLinksByVersionId(this.parseVersionId(versionId));
    }

    @DELETE
    @Path(value="{versionId}/remotelink/{globalId}")
    public Response deleteRemoteVersionLink(@PathParam(value="versionId") String versionId, @PathParam(value="globalId") String globalId) {
        return this.remoteVersionLinkResource.deleteRemoteVersionLink(this.parseVersionId(versionId), globalId);
    }

    private long getVersionIdFromSelfLink(String path) {
        return this.parseVersionId(path.substring(path.lastIndexOf(47) + 1));
    }

    private void checkMoveResult(VersionService.MoveVersionValidationResult moveValidationResult) {
        if (moveValidationResult.getErrorCollection().hasAnyErrors()) {
            if (moveValidationResult.getReasons().contains(VersionService.MoveVersionValidationResult.Reason.FORBIDDEN)) {
                throw new NotAuthorisedWebException(ErrorCollection.of(moveValidationResult.getErrorCollection()));
            }
            if (moveValidationResult.getReasons().contains(VersionService.MoveVersionValidationResult.Reason.NOT_FOUND) || moveValidationResult.getReasons().contains(VersionService.MoveVersionValidationResult.Reason.SCHEDULE_AFTER_VERSION_NOT_FOUND)) {
                throw new NotFoundWebException(ErrorCollection.of(moveValidationResult.getErrorCollection()));
            }
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(moveValidationResult.getErrorCollection()));
        }
    }

    private void throwWebException(com.atlassian.jira.util.ErrorCollection errorCollection) {
        throw new RESTException(ErrorCollection.of(errorCollection));
    }

    private long parseVersionId(String id) {
        try {
            return Long.parseLong(id);
        }
        catch (NumberFormatException exc) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("admin.errors.version.not.exist.with.id", id)));
        }
    }

    private Version getVersionBy(String id) {
        return this.getVersionBy(this.parseVersionId(id));
    }

    private Version getVersionBy(Long versionId) {
        VersionService.VersionResult versionResult = this.versionService.getVersionById(this.authContext.getUser(), versionId);
        if (!versionResult.isValid()) {
            throw new NotFoundWebException(ErrorCollection.of(versionResult.getErrorCollection()));
        }
        return versionResult.getVersion();
    }

    private ApplicationUser getUser() {
        return this.authContext.getUser();
    }
}

