/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.customfield.CustomFieldService;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenId;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenLayoutItemId;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenOperationContext;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenService;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenTabId;
import com.atlassian.jira.bc.issue.fields.screen.MoveFieldInfo;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.v2.issue.AddFieldBean;
import com.atlassian.jira.rest.v2.issue.MoveFieldBean;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.ScreenableFieldBean;
import com.atlassian.jira.rest.v2.issue.ScreenableTabBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="screens")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ScreensResource {
    private final FieldScreenManager fieldScreenManager;
    private final FieldManager fieldManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;
    private final CustomFieldService customFieldService;
    private final ProjectManager projectManager;
    private final FieldScreenService fieldScreenService;

    public ScreensResource(FieldScreenManager fieldScreenManager, FieldManager fieldManager, JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager, CustomFieldService customFieldService, ProjectManager projectManager, @ComponentImport FieldScreenService fieldScreenService) {
        this.fieldScreenManager = fieldScreenManager;
        this.fieldManager = fieldManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.customFieldService = customFieldService;
        this.projectManager = projectManager;
        this.fieldScreenService = fieldScreenService;
    }

    @GET
    @ResponseType(value=List.class, genericTypes={ScreenableTabBean.class})
    @Path(value="{screenId}/tabs")
    public Response getAllTabs(@PathParam(value="screenId") Long screenId, @QueryParam(value="projectKey") String projectKey) {
        FieldScreenOperationContext context = FieldScreenOperationContext.ofUserAndProject((ApplicationUser)this.jiraAuthenticationContext.getLoggedInUser(), (Project)this.getProjectByKey(projectKey));
        ServiceOutcome tabsResult = this.fieldScreenService.getAllTabs(FieldScreenId.byId((long)screenId), context);
        List tabs = (List)ScreensResource.throwWebExceptionOrGetResult(tabsResult);
        ArrayList<ScreenableTabBean> tabBeans = new ArrayList<ScreenableTabBean>(tabs.size());
        for (FieldScreenTab tab : tabs) {
            tabBeans.add(new ScreenableTabBean(tab));
        }
        return Response.ok(tabBeans).cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{screenId}/tabs")
    @RequestType(value=ScreenableTabBean.class)
    @ResponseType(value=ScreenableTabBean.class)
    public Response addTab(@PathParam(value="screenId") Long screenId, ScreenableTabBean tab) {
        ServiceOutcome serviceOutcome = this.fieldScreenService.addTab(FieldScreenId.byId((long)screenId), tab.name, this.userContext());
        FieldScreenTab fieldScreenTab = (FieldScreenTab)ScreensResource.throwWebExceptionOrGetResult(serviceOutcome);
        return Response.ok((Object)new ScreenableTabBean(fieldScreenTab)).cacheControl(CacheControl.never()).build();
    }

    @PUT
    @Path(value="{screenId}/tabs/{tabId}")
    @RequestType(value=ScreenableTabBean.class)
    @ResponseType(value=ScreenableTabBean.class)
    public Response renameTab(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId, ScreenableTabBean tab) {
        ServiceOutcome serviceOutcome = this.fieldScreenService.renameTab(FieldScreenTabId.byId((long)tabId), tab.name, this.userContext());
        FieldScreenTab tabResult = (FieldScreenTab)ScreensResource.throwWebExceptionOrGetResult(serviceOutcome);
        return Response.ok((Object)new ScreenableTabBean(tabResult)).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="{screenId}/tabs/{tabId}")
    public Response deleteTab(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId) {
        ServiceResult serviceResult = this.fieldScreenService.removeTab(FieldScreenTabId.byId((long)tabId), this.userContext());
        ScreensResource.throwWebExeptionFromResult(serviceResult);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{screenId}/tabs/{tabId}/move/{pos}")
    @ResponseType(value=Void.class)
    public Response moveTab(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId, @PathParam(value="pos") Integer pos) {
        ServiceOutcome serviceOutcome = this.fieldScreenService.moveTab(FieldScreenTabId.byId((long)tabId), pos, this.userContext());
        ScreensResource.throwWebExeptionFromResult((ServiceResult)serviceOutcome);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{screenId}/tabs/{tabId}/fields")
    @ResponseType(value=List.class, genericTypes={ScreenableTabBean.class})
    public Response getAllFields(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId, @QueryParam(value="projectKey") String projectKey) {
        Project project = this.getProjectByKey(projectKey);
        ServiceOutcome fieldsOnTab = this.fieldScreenService.getFieldsOnTab(FieldScreenTabId.byId((long)tabId), FieldScreenOperationContext.ofUserAndProject((ApplicationUser)this.jiraAuthenticationContext.getLoggedInUser(), (Project)project));
        List fields = (List)ScreensResource.throwWebExceptionOrGetResult(fieldsOnTab);
        List fieldBeans = fields.stream().map(field -> new ScreenableFieldBean(field.getId(), field.getName(), this.getFieldType((Field)field))).collect(Collectors.toList());
        return Response.ok(fieldBeans).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{screenId}/availableFields")
    @ResponseType(value=List.class, genericTypes={ScreenableTabBean.class})
    public Response getFieldsToAdd(@PathParam(value="screenId") Long screenId) {
        ServiceOutcome serviceOutcome = this.fieldScreenService.getAvailableFieldsForScreen(FieldScreenId.byId((long)screenId), this.userContext());
        List addableFields = (List)ScreensResource.throwWebExceptionOrGetResult(serviceOutcome);
        ArrayList<ScreenableFieldBean> fieldBeans = new ArrayList<ScreenableFieldBean>();
        for (OrderableField addableField : addableFields) {
            fieldBeans.add(new ScreenableFieldBean(addableField.getId(), addableField.getName(), this.getFieldType((Field)addableField)));
        }
        return Response.ok(fieldBeans).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="{screenId}/tabs/{tabId}/fields/{id}")
    public Response removeField(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId, @PathParam(value="id") String id) {
        ServiceResult serviceResult = this.fieldScreenService.removeField(FieldScreenLayoutItemId.byIds((FieldScreenTabId)FieldScreenTabId.byId((long)tabId), (String)id), this.userContext());
        ScreensResource.throwWebExeptionFromResult(serviceResult);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{screenId}/tabs/{tabId}/fields/{id}/move")
    @RequestType(value=MoveFieldBean.class)
    @ResponseType(value=Void.class)
    public Response moveField(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId, @PathParam(value="id") String id, MoveFieldBean moveField) {
        MoveFieldInfo moveInfo;
        if (moveField.after != null) {
            String[] split = moveField.after.getPath().split("/");
            String afterField = split[split.length - 1];
            moveInfo = MoveFieldInfo.after((String)afterField);
        } else if (moveField.position == MoveFieldBean.Position.Last) {
            moveInfo = MoveFieldInfo.ofPosition((MoveFieldInfo.MoveFieldPosition)MoveFieldInfo.MoveFieldPosition.Last);
        } else if (moveField.position == MoveFieldBean.Position.First) {
            moveInfo = MoveFieldInfo.ofPosition((MoveFieldInfo.MoveFieldPosition)MoveFieldInfo.MoveFieldPosition.First);
        } else {
            this.throwWebException("Unimplemented behaviour of moving field: " + (Object)((Object)moveField.position));
            return null;
        }
        ServiceResult serviceResult = this.fieldScreenService.moveField(FieldScreenLayoutItemId.byIds((FieldScreenTabId)FieldScreenTabId.byId((long)tabId), (String)id), moveInfo, this.userContext());
        ScreensResource.throwWebExeptionFromResult(serviceResult);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="{screenId}/tabs/{tabId}/fields")
    @RequestType(value=AddFieldBean.class)
    @ResponseType(value=ScreenableFieldBean.class)
    public Response addField(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId, AddFieldBean field) {
        ServiceOutcome fieldServiceOutcome = this.fieldScreenService.addFieldToScreen(FieldScreenTabId.byId((long)tabId), field.getFieldId(), this.userContext());
        Field resultField = (Field)ScreensResource.throwWebExceptionOrGetResult(fieldServiceOutcome);
        return Response.ok((Object)new ScreenableFieldBean(resultField.getId(), resultField.getName(), this.getFieldType(resultField))).cacheControl(CacheControl.never()).build();
    }

    @POST
    @WebSudoRequired
    @Path(value="addToDefault/{fieldId}")
    @ResponseType(value=Void.class)
    public Response addFieldToDefaultScreen(@PathParam(value="fieldId") String fieldId) {
        FieldScreen fieldScreen = this.fieldScreenManager.getFieldScreen(FieldScreen.DEFAULT_SCREEN_ID);
        List<FieldScreenTab> sortedTabs = this.sortFieldScreenTabs(fieldScreen.getTabs());
        FieldScreenTab defaultTabOfDefaultScreen = sortedTabs.iterator().next();
        Field field = this.fieldManager.getField(fieldId);
        if (field instanceof CustomField) {
            this.administerPermissionCheck();
            this.addCustomField(fieldId, defaultTabOfDefaultScreen);
        } else {
            ServiceOutcome fieldServiceOutcome = this.fieldScreenService.addFieldToScreen(FieldScreenTabId.byId((long)defaultTabOfDefaultScreen.getId()), fieldId, this.userContext());
            ScreensResource.throwWebExeptionFromResult((ServiceResult)fieldServiceOutcome);
        }
        return Response.ok((Object)Response.Status.CREATED).cacheControl(CacheControl.never()).build();
    }

    private List<FieldScreenTab> sortFieldScreenTabs(List<FieldScreenTab> tabs) {
        ArrayList sortedTabs = Lists.newArrayList(tabs);
        if (sortedTabs.size() > 1) {
            Collections.sort(sortedTabs, new Comparator<FieldScreenTab>(){

                @Override
                public int compare(FieldScreenTab fieldScreenTab1, FieldScreenTab fieldScreenTab2) {
                    return fieldScreenTab1.getId().compareTo(fieldScreenTab2.getId());
                }
            });
        }
        return sortedTabs;
    }

    private void addCustomField(String fieldId, FieldScreenTab defaultTabOfDefaultScreen) {
        ServiceOutcome outcome = this.customFieldService.addToScreenTabs(this.jiraAuthenticationContext.getUser(), CustomFieldUtils.getCustomFieldId((String)fieldId), (List)Lists.newArrayList((Object[])new Long[]{defaultTabOfDefaultScreen.getId()}));
        if (outcome.getErrorCollection().hasAnyErrors()) {
            ScreensResource.throwWebException(outcome.getErrorCollection());
        }
    }

    private String getFieldType(Field field) {
        if (this.fieldManager.isCustomField(field)) {
            return ((CustomField)field).getCustomFieldType().getName();
        }
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.screens.system.field");
    }

    private void throwWebException(String message) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorMessage(message);
        ScreensResource.throwWebException((com.atlassian.jira.util.ErrorCollection)errorCollection);
    }

    private static void throwWebException(com.atlassian.jira.util.ErrorCollection errorCollection) {
        throw new RESTException(ErrorCollection.of(errorCollection));
    }

    private static <T> T throwWebExceptionOrGetResult(ServiceOutcome<T> outcome) {
        if (outcome.isValid()) {
            return (T)outcome.get();
        }
        ScreensResource.throwWebExeptionFromResult(outcome);
        return null;
    }

    private static void throwWebExeptionFromResult(ServiceResult result) {
        if (result.isValid()) {
            return;
        }
        com.atlassian.jira.util.ErrorCollection ec = result.getErrorCollection();
        if (ec.getReasons().contains(ErrorCollection.Reason.FORBIDDEN) || ec.getReasons().contains(ErrorCollection.Reason.NOT_LOGGED_IN)) {
            throw new NotAuthorisedWebException();
        }
        ScreensResource.throwWebException(ec);
    }

    private void administerPermissionCheck() {
        if (!this.permissionManager.hasPermission(0, this.jiraAuthenticationContext.getLoggedInUser())) {
            throw new NotAuthorisedWebException();
        }
    }

    private Project getProjectByKey(String projectKey) {
        if (StringUtils.isBlank((String)projectKey)) {
            return null;
        }
        return this.projectManager.getProjectObjByKey(projectKey);
    }

    private FieldScreenOperationContext userContext() {
        return FieldScreenOperationContext.ofUser((ApplicationUser)this.jiraAuthenticationContext.getLoggedInUser());
    }
}

