/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.ResolutionJsonBean;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.v2.issue.ResolutionBean;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.rest.annotation.ResponseType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="resolution")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ResolutionResource {
    private ConstantsManager constantsManager;
    private I18nHelper i18n;
    private JiraBaseUrls baseUrls;

    private ResolutionResource() {
    }

    public ResolutionResource(ConstantsManager constantsManager, I18nHelper i18n, JiraBaseUrls baseUrls) {
        this.constantsManager = constantsManager;
        this.i18n = i18n;
        this.baseUrls = baseUrls;
    }

    @GET
    @ResponseType(value=List.class, genericTypes={ResolutionBean.class})
    public Response getResolutions(@Context UriInfo uriInfo) {
        Collection resolutions = this.constantsManager.getResolutionObjects();
        ArrayList<ResolutionJsonBean> beans = new ArrayList<ResolutionJsonBean>(resolutions.size());
        for (Resolution resolution : resolutions) {
            beans.add(ResolutionJsonBean.shortBean((Resolution)resolution, (JiraBaseUrls)this.baseUrls));
        }
        return Response.ok(beans).cacheControl(CacheControl.never()).build();
    }

    @GET
    @ResponseType(value=ResolutionBean.class)
    @Path(value="{id}")
    public Response getResolution(@PathParam(value="id") String id, @Context UriInfo uriInfo) {
        Resolution resolution = this.constantsManager.getResolutionObject(id);
        if (resolution == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.resolution.error.not.found", id)));
        }
        return Response.ok((Object)ResolutionJsonBean.shortBean((Resolution)resolution, (JiraBaseUrls)this.baseUrls)).cacheControl(CacheControl.never()).build();
    }
}

