/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarPickerHelper;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectCreationData;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.project.component.ProjectComponentService;
import com.atlassian.jira.bc.project.version.VersionService;
import com.atlassian.jira.blueprint.core.api.CoreProjectConfigurator;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.StatusJsonBean;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.template.ProjectTemplateKey;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.rest.api.issue.IssueTypeWithStatusJsonBean;
import com.atlassian.jira.rest.api.pagination.PageBean;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.BadRequestWebException;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.rest.util.AttachmentHelper;
import com.atlassian.jira.rest.util.ProjectFinder;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.util.StatusHelper;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.rest.v2.issue.AvatarBean;
import com.atlassian.jira.rest.v2.issue.AvatarCroppingBean;
import com.atlassian.jira.rest.v2.issue.AvatarResourceHelper;
import com.atlassian.jira.rest.v2.issue.IssueTypeResource;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.ResourceUriBuilder;
import com.atlassian.jira.rest.v2.issue.StatusResource;
import com.atlassian.jira.rest.v2.issue.component.ComponentBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBeanFactory;
import com.atlassian.jira.rest.v2.issue.project.ProjectIdentity;
import com.atlassian.jira.rest.v2.issue.project.ProjectInputBean;
import com.atlassian.jira.rest.v2.issue.version.VersionBean;
import com.atlassian.jira.rest.v2.issue.version.VersionBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.NamedWithId;
import com.atlassian.jira.util.OrderByRequest;
import com.atlassian.jira.util.OrderByRequestParser;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.plugins.rest.common.multipart.FilePart;
import com.atlassian.plugins.rest.common.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.XsrfCheckFailedException;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;

@Path(value="project")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ProjectResource {
    public static final int MAX_RECENT_PROJECTS = 20;
    private final ProjectService projectService;
    private final UserManager userManager;
    private final JiraAuthenticationContext authContext;
    private final UriInfo uriInfo;
    private final ProjectManager projectManager;
    private final AvatarResourceHelper avatarResourceHelper;
    private final VersionService versionService;
    private final ProjectComponentService projectComponentService;
    private final ProjectBeanFactory projectBeanFactory;
    private final VersionBeanFactory versionBeanFactory;
    private final PermissionManager permissionManager;
    private final AvatarService avatarService;
    private final JiraBaseUrls jiraBaseUrls;
    private final WorkflowManager workflowManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final NotificationSchemeManager notificationSchemeManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final ResourceUriBuilder uriBuilder;
    private final StatusHelper statusHelper;
    private final ProjectFinder projectFinder;
    private final XsrfInvocationChecker xsrfChecker;
    private final ResponseFactory responses;
    private final UserProjectHistoryManager projectHistoryManager;
    private final I18nHelper i18nHelper;
    private final CoreProjectConfigurator coreProjectConfigurator;
    private final OrderByRequestParser orderByRequestParser;

    public ProjectResource(ProjectService projectService, JiraAuthenticationContext authContext, UriInfo uriInfo, VersionService versionService, ProjectComponentService projectComponentService, AvatarService avatarService, UserManager userManager, ProjectBeanFactory projectBeanFactory, VersionBeanFactory versionBeanFactory, PermissionManager permissionManager, ProjectManager projectManager, AvatarManager avatarManager, AvatarPickerHelper avatarPickerHelper, AttachmentHelper attachmentHelper, JiraBaseUrls jiraBaseUrls, WorkflowManager workflowManager, IssueTypeSchemeManager issueTypeSchemeManager, PermissionSchemeManager permissionSchemeManager, NotificationSchemeManager notificationSchemeManager, IssueSecuritySchemeManager issueSecuritySchemeManager, ResourceUriBuilder uriBuilder, StatusHelper statusHelper, ProjectFinder projectFinder, XsrfInvocationChecker xsrfChecker, UserProjectHistoryManager projectHistoryManager, ResponseFactory responses, I18nHelper i18nHelper, CoreProjectConfigurator coreProjectConfigurator, OrderByRequestParser orderByRequestParser) {
        this.workflowManager = workflowManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.notificationSchemeManager = notificationSchemeManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.uriBuilder = uriBuilder;
        this.statusHelper = statusHelper;
        this.projectFinder = projectFinder;
        this.responses = responses;
        this.projectHistoryManager = projectHistoryManager;
        this.i18nHelper = i18nHelper;
        this.orderByRequestParser = orderByRequestParser;
        this.avatarResourceHelper = new AvatarResourceHelper(authContext, avatarManager, avatarService, avatarPickerHelper, attachmentHelper, userManager);
        this.permissionManager = permissionManager;
        this.avatarService = avatarService;
        this.projectService = projectService;
        this.authContext = authContext;
        this.versionService = versionService;
        this.projectComponentService = projectComponentService;
        this.userManager = userManager;
        this.projectBeanFactory = projectBeanFactory;
        this.versionBeanFactory = versionBeanFactory;
        this.uriInfo = uriInfo;
        this.projectManager = projectManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.xsrfChecker = xsrfChecker;
        this.coreProjectConfigurator = coreProjectConfigurator;
    }

    @GET
    @ResponseType(value=ProjectBean.class)
    @Path(value="{projectIdOrKey}")
    public Response getProject(@PathParam(value="projectIdOrKey") String projectIdOrKey, final @QueryParam(value="expand") String expand) {
        return (Response)this.getProjectForView(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                return Response.ok((Object)ProjectResource.this.projectBeanFactory.fullProject(project, StringUtils.defaultString((String)expand))).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
            }
        });
    }

    @POST
    @ResponseType(value=ProjectIdentity.class)
    public Response createProject(ProjectInputBean project) {
        if (this.authContext.isLoggedInUser()) {
            final ProjectCreationData projectCreationData = (ProjectCreationData)this.toProjectCreationData().apply((Object)project);
            final ProjectService.CreateProjectValidationResult validationResult = this.projectService.validateCreateProject(this.authContext.getUser(), projectCreationData);
            if (validationResult.isValid()) {
                final ProjectService.UpdateProjectSchemesValidationResult schemesValidationResult = this.projectService.validateUpdateProjectSchemes(this.authContext.getUser(), project.getPermissionScheme(), project.getNotificationScheme(), project.getIssueSecurityScheme());
                if (schemesValidationResult.isValid()) {
                    return (Response)this.loadProjectCategory(project.getCategoryId()).left().on((Function)new Function<Option<ProjectCategory>, Response>(){

                        public Response apply(@Nullable Option<ProjectCategory> maybeCategory) {
                            Project createdProject = ProjectResource.this.projectService.createProject(validationResult);
                            ProjectResource.this.projectService.updateProjectSchemes(schemesValidationResult, createdProject);
                            if (ProjectResource.this.shouldApplyCoreProjectConfiguration(projectCreationData)) {
                                ProjectResource.this.coreProjectConfigurator.configure(createdProject);
                            }
                            ProjectIdentity responseEntity = ProjectResource.this.projectBeanFactory.projectIdentity(createdProject);
                            if (maybeCategory.isDefined()) {
                                ProjectResource.this.projectManager.setProjectCategory(createdProject, (ProjectCategory)maybeCategory.get());
                            }
                            return Response.status((Response.Status)Response.Status.CREATED).location(responseEntity.getSelf()).entity((Object)responseEntity).build();
                        }
                    });
                }
                return this.responses.errorResponse(schemesValidationResult.getErrorCollection());
            }
            return this.responses.errorResponse(validationResult.getErrorCollection());
        }
        return this.responses.notLoggedInResponse();
    }

    private boolean shouldApplyCoreProjectConfiguration(ProjectCreationData projectCreationData) {
        ProjectTemplateKey projectTemplateKey = projectCreationData.getProjectTemplateKey();
        return projectTemplateKey == null || StringUtils.isEmpty((String)projectTemplateKey.getKey());
    }

    private Function<ProjectInputBean, ProjectCreationData> toProjectCreationData() {
        return new Function<ProjectInputBean, ProjectCreationData>(){

            public ProjectCreationData apply(ProjectInputBean projectInputBean) {
                ProjectCreationData.Builder builder = new ProjectCreationData.Builder().withName(projectInputBean.getName()).withKey(projectInputBean.getKey()).withDescription(projectInputBean.getDescription()).withLead(ProjectResource.this.userManager.getUserByName(projectInputBean.getLead())).withUrl(projectInputBean.getUrl()).withAssigneeType(Long.valueOf(projectInputBean.getAssigneeType().getId())).withAvatarId(projectInputBean.getAvatarId()).withProjectTemplateKey(projectInputBean.getProjectTemplateKey()).withType(projectInputBean.getProjectTypeKey());
                return builder.build();
            }
        };
    }

    private Either<Response, Option<ProjectCategory>> loadProjectCategory(Long categoryId) {
        if (categoryId != null) {
            ProjectCategory category = this.projectManager.getProjectCategoryObject(categoryId);
            if (category != null) {
                return Either.right((Object)Option.some((Object)category));
            }
            return Either.left((Object)this.responses.errorResponse(ErrorCollections.validationError((String)"projectCategory", (String)this.i18nHelper.getText("admin.errors.project.category.does.not.exist"))));
        }
        return Either.right((Object)Option.none());
    }

    @PUT
    @Path(value="{projectIdOrKey}")
    @ResponseType(value=ProjectBean.class)
    public Response updateProject(@PathParam(value="projectIdOrKey") String projectIdOrKey, @QueryParam(value="expand") String expand, ProjectInputBean updateData) {
        if (!this.authContext.isLoggedInUser()) {
            return this.responses.notLoggedInResponse();
        }
        return (Response)this.getProjectForEdit(projectIdOrKey).left().on(projectToEdit -> {
            ProjectService.UpdateProjectValidationResult basicValidationResult = this.projectService.validateUpdateProject(this.authContext.getLoggedInUser(), ProjectResource.requestProjectUpdate(projectToEdit, updateData));
            if (!basicValidationResult.isValid()) {
                return this.responses.errorResponse(basicValidationResult.getErrorCollection());
            }
            ProjectService.UpdateProjectSchemesValidationResult schemesValidationResult = this.projectService.validateUpdateProjectSchemes(this.authContext.getUser(), ProjectResource.firstNotNullId(updateData.getPermissionScheme(), (NamedWithId)this.permissionSchemeManager.getSchemeFor(projectToEdit)), ProjectResource.firstNotNullId(updateData.getNotificationScheme(), (NamedWithId)this.notificationSchemeManager.getSchemeFor(projectToEdit)), ProjectResource.firstNotNullId(updateData.getIssueSecurityScheme(), (NamedWithId)this.issueSecuritySchemeManager.getSchemeFor(projectToEdit)));
            if (!schemesValidationResult.isValid()) {
                return this.responses.errorResponse(schemesValidationResult.getErrorCollection());
            }
            return (Response)this.loadProjectCategory(updateData.getCategoryId()).left().on(maybeProjectCategory -> {
                Project project = this.projectService.updateProject(basicValidationResult);
                if (maybeProjectCategory.isDefined()) {
                    this.projectManager.setProjectCategory(project, (ProjectCategory)maybeProjectCategory.get());
                }
                this.projectService.updateProjectSchemes(schemesValidationResult, project);
                return this.responses.okNoCache(this.projectBeanFactory.fullProject((Project)this.getProjectForView(projectIdOrKey).right().get(), Strings.nullToEmpty((String)expand)));
            });
        });
    }

    private static ProjectService.UpdateProjectRequest requestProjectUpdate(Project original, ProjectInputBean updateData) {
        ProjectService.UpdateProjectRequest request = new ProjectService.UpdateProjectRequest(original);
        request.name(updateData.getName());
        request.key(updateData.getKey());
        request.description(updateData.getDescription());
        request.url(updateData.getUrl());
        request.assigneeType(updateData.getAssigneeTypeOrNull());
        request.avatarId(updateData.getAvatarId());
        request.leadUsername(updateData.getLead());
        return request;
    }

    private static Long firstNotNullId(Long first, NamedWithId second) {
        return first != null ? first : (second != null ? second.getId() : null);
    }

    @PUT
    @Path(value="{projectIdOrKey}/type/{newProjectTypeKey}")
    @ResponseType(value=ProjectBean.class)
    public Response updateProjectType(@PathParam(value="projectIdOrKey") String projectIdOrKey, final @PathParam(value="newProjectTypeKey") String newProjectTypeKey) {
        if (!this.authContext.isLoggedInUser()) {
            return this.responses.notLoggedInResponse();
        }
        return (Response)this.getProjectForEdit(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(@Nullable Project project) {
                Either updateResult = ProjectResource.this.projectService.updateProjectType(ProjectResource.this.authContext.getLoggedInUser(), project, new ProjectTypeKey(newProjectTypeKey));
                if (updateResult.isLeft()) {
                    return ProjectResource.this.responses.okNoCache(ProjectResource.this.projectBeanFactory.fullProject((Project)updateResult.left().get(), ""));
                }
                return ProjectResource.this.responses.errorResponse((com.atlassian.jira.util.ErrorCollection)updateResult.right().get());
            }
        });
    }

    @DELETE
    @Path(value="{projectIdOrKey}")
    public Response deleteProject(@PathParam(value="projectIdOrKey") String projectIdOrKey) {
        if (!this.authContext.isLoggedInUser()) {
            return this.responses.notLoggedInResponse();
        }
        return (Response)this.getProjectForEdit(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                ProjectService.DeleteProjectValidationResult validationResult = ProjectResource.this.projectService.validateDeleteProject(ProjectResource.this.authContext.getUser(), project.getKey());
                if (validationResult.isValid()) {
                    ProjectService.DeleteProjectResult result = ProjectResource.this.projectService.deleteProject(ProjectResource.this.authContext.getUser(), validationResult);
                    return result.isValid() ? ProjectResource.this.responses.noContent() : ProjectResource.this.responses.errorResponse(result.getErrorCollection());
                }
                return ProjectResource.this.responses.errorResponse(validationResult.getErrorCollection());
            }
        });
    }

    @GET
    @ResponseType(value=List.class, genericTypes={VersionBean.class})
    @Path(value="{projectIdOrKey}/versions")
    public Response getProjectVersions(@PathParam(value="projectIdOrKey") String projectIdOrKey, final @QueryParam(value="expand") String expand) {
        return (Response)this.getProjectForView(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                VersionService.VersionsResult versionResult = ProjectResource.this.versionService.getVersionsByProject(ProjectResource.this.authContext.getUser(), project);
                if (!versionResult.isValid()) {
                    throw new NotFoundWebException(ErrorCollection.of(versionResult.getErrorCollection()));
                }
                boolean expandOps = expand != null && expand.contains("operations");
                return ProjectResource.this.responses.okNoCache(ProjectResource.this.versionBeanFactory.createVersionBeans(versionResult.getVersions(), expandOps));
            }
        });
    }

    @GET
    @Path(value="{projectIdOrKey}/version")
    @ResponseType(value=PageBean.class, genericTypes={VersionBean.class})
    public Response getProjectVersionsPaginated(@PathParam(value="projectIdOrKey") String projectIdOrKey, final @QueryParam(value="startAt") Long startAt, final @QueryParam(value="maxResults") Integer maxResults, final @QueryParam(value="orderBy") String orderBy, final @QueryParam(value="expand") String expand) {
        return (Response)this.getProjectForView(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                ServiceOutcome pagedVersions;
                PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)((Integer)MoreObjects.firstNonNull((Object)maxResults, (Object)50)));
                OrderByRequest orderByRequest = null;
                if (orderBy != null) {
                    Either parsedOrderBy = ProjectResource.this.orderByRequestParser.parse(orderBy, VersionService.VersionExtractableField.class);
                    if (parsedOrderBy.isLeft()) {
                        throw new BadRequestWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)parsedOrderBy.left().get()));
                    }
                    orderByRequest = (OrderByRequest)parsedOrderBy.right().get();
                }
                if (!(pagedVersions = ProjectResource.this.versionService.getVersionsByProject(ProjectResource.this.authContext.getUser(), project, pageRequest, orderByRequest)).isValid()) {
                    throw new RESTException(ErrorCollection.of(pagedVersions.getErrorCollection()));
                }
                final boolean expandOps = expand != null && expand.contains("operations");
                final boolean expandRemoteLinks = expand != null && expand.contains("remotelinks");
                return Response.ok(PageBean.from(pageRequest, (Page)pagedVersions.get()).setLinks(ProjectResource.this.baseSelfForPagedVersions(project.getKey(), orderBy), pageRequest.getLimit()).build(new java.util.function.Function<Version, VersionBean>(){

                    @Override
                    public VersionBean apply(Version input) {
                        return ProjectResource.this.versionBeanFactory.createVersionBean(input, expandOps, expandRemoteLinks);
                    }
                })).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
            }
        });
    }

    private String baseSelfForPagedVersions(String projectKey, String orderByQuery) {
        UriBuilder withoutOrderBy = UriBuilder.fromPath((String)this.jiraBaseUrls.restApi2BaseUrl()).path(ProjectResource.class).path(projectKey).path("version");
        if (orderByQuery != null) {
            return withoutOrderBy.queryParam("orderBy", new Object[]{orderByQuery}).build(new Object[0]).toString();
        }
        return withoutOrderBy.build(new Object[0]).toString();
    }

    @GET
    @ResponseType(value=List.class, genericTypes={ComponentBean.class})
    @Path(value="{projectIdOrKey}/components")
    public Response getProjectComponents(@PathParam(value="projectIdOrKey") String projectIdOrKey) {
        return (Response)this.getProjectForView(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                Collection projectComponents = ProjectResource.this.projectComponentService.findAllForProject((com.atlassian.jira.util.ErrorCollection)errorCollection, project.getId());
                if (errorCollection.hasAnyErrors()) {
                    throw new NotFoundWebException(ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection));
                }
                return ProjectResource.this.responses.okNoCache(ComponentBean.asFullBeans(project, projectComponents, ProjectResource.this.jiraBaseUrls, ProjectResource.this.userManager, ProjectResource.this.avatarService, ProjectResource.this.permissionManager, ProjectResource.this.projectManager));
            }
        });
    }

    @GET
    @ResponseType(value=List.class, genericTypes={ProjectBean.class})
    public Response getAllProjects(@QueryParam(value="expand") String expand, @QueryParam(value="recent") Integer recent) {
        return (Response)(recent != null ? this.getMostRecentProjects(recent) : this.getAllProjects()).left().on(this.projectListAsResponse(expand));
    }

    private Either<Response, List<Project>> getAllProjects() {
        return this.responses.validateOutcome(this.projectService.getAllProjectsForAction(this.authContext.getUser(), ProjectAction.VIEW_PROJECT));
    }

    private Either<Response, Iterable<Project>> getMostRecentProjects(Integer count) {
        if (count < 0) {
            return Either.left((Object)this.responses.errorResponse(ErrorCollections.validationError((String)"recent", (String)this.i18nHelper.getText("rest.validation.error.negative.number"))));
        }
        List recentProjects = this.projectHistoryManager.getProjectHistoryWithPermissionChecks(ProjectAction.VIEW_PROJECT, this.authContext.getUser());
        return Either.right((Object)Iterables.limit((Iterable)recentProjects, (int)Math.min(count, 20)));
    }

    private Function<Iterable<Project>, Response> projectListAsResponse(final String expand) {
        return new Function<Iterable<Project>, Response>(){

            public Response apply(@Nullable Iterable<Project> projects) {
                return ProjectResource.this.responses.okNoCache(ImmutableList.copyOf((Iterable)Iterables.transform(projects, ProjectResource.this.projectBeanFactory.summaryProject(expand))));
            }
        };
    }

    @GET
    @Path(value="{projectIdOrKey}/avatars")
    @ResponseType(value=Map.class, genericTypes={String.class, AvatarBean[].class})
    public Response getAllAvatars(@PathParam(value="projectIdOrKey") String projectIdOrKey) {
        return (Response)this.getProjectForView(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                Avatar selectedAvatar = project.getAvatar();
                Long selectedAvatarId = selectedAvatar.getId();
                return ProjectResource.this.responses.okNoCache(ProjectResource.this.avatarResourceHelper.getAllAvatars(IconType.PROJECT_ICON_TYPE, project.getId().toString(), selectedAvatarId));
            }
        });
    }

    @POST
    @Path(value="{projectIdOrKey}/avatar")
    @RequestType(value=AvatarCroppingBean.class)
    @ResponseType(value=AvatarBean.class)
    public Response createAvatarFromTemporary(@PathParam(value="projectIdOrKey") String projectIdOrKey, final AvatarCroppingBean croppingInstructions) {
        return (Response)this.getProjectForEdit(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                return ProjectResource.this.avatarResourceHelper.createAvatarFromTemporary(IconType.PROJECT_ICON_TYPE, project.getId().toString(), croppingInstructions);
            }
        });
    }

    @PUT
    @Path(value="{projectIdOrKey}/avatar")
    @ResponseType(value=Void.class)
    public Response updateProjectAvatar(@PathParam(value="projectIdOrKey") String projectIdOrKey, final AvatarBean avatarBean) {
        return (Response)this.getProjectForEdit(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                Long avatarId;
                String id = avatarBean.getId();
                try {
                    avatarId = id == null ? null : Long.valueOf(id);
                }
                catch (NumberFormatException e) {
                    avatarId = null;
                }
                ProjectService.UpdateProjectValidationResult updateProjectValidationResult = ProjectResource.this.projectService.validateUpdateProject(ProjectResource.this.authContext.getUser(), project.getName(), project.getKey(), project.getDescription(), project.getLeadUserName(), project.getUrl(), project.getAssigneeType(), avatarId);
                if (!updateProjectValidationResult.isValid()) {
                    ProjectResource.this.throwWebException(updateProjectValidationResult.getErrorCollection());
                }
                ProjectResource.this.projectService.updateProject(updateProjectValidationResult);
                return ProjectResource.this.responses.noContent();
            }
        });
    }

    @POST
    @Consumes(value={"*/*"})
    @ResponseType(value=AvatarCroppingBean.class)
    @Path(value="{projectIdOrKey}/avatar/temporary")
    public Response storeTemporaryAvatar(@PathParam(value="projectIdOrKey") String projectIdOrKey, final @QueryParam(value="filename") String filename, final @QueryParam(value="size") Long size, final @Context HttpServletRequest request) {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(ExecutingHttpRequest.get());
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            throw new XsrfCheckFailedException();
        }
        return (Response)this.getProjectForEdit(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                return ProjectResource.this.avatarResourceHelper.storeTemporaryAvatar(IconType.PROJECT_ICON_TYPE, project.getId().toString(), filename, size, request);
            }
        });
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="{projectIdOrKey}/avatar/temporary")
    @Produces(value={"text/html"})
    @ResponseType(value=AvatarCroppingBean.class)
    public Response storeTemporaryAvatarUsingMultiPart(@PathParam(value="projectIdOrKey") String projectIdOrKey, final @MultipartFormParam(value="avatar") FilePart filePart, final @Context HttpServletRequest request) {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(ExecutingHttpRequest.get());
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            throw new XsrfCheckFailedException();
        }
        return (Response)this.getProjectForEdit(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                return ProjectResource.this.avatarResourceHelper.storeTemporaryAvatarUsingMultiPart(IconType.PROJECT_ICON_TYPE, project.getId().toString(), filePart, request);
            }
        });
    }

    @DELETE
    @Path(value="{projectIdOrKey}/avatar/{id}")
    public Response deleteAvatar(@PathParam(value="projectIdOrKey") String projectIdOrKey, final @PathParam(value="id") Long id) {
        return (Response)this.getProjectForEdit(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                return ProjectResource.this.avatarResourceHelper.deleteAvatar(id);
            }
        });
    }

    @GET
    @ResponseType(value=List.class, genericTypes={IssueTypeWithStatusJsonBean.class})
    @Path(value="{projectIdOrKey}/statuses")
    public Response getAllStatuses(@PathParam(value="projectIdOrKey") String projectIdOrKey) {
        return (Response)this.getProjectForView(projectIdOrKey).left().on((Function)new Function<Project, Response>(){

            public Response apply(Project project) {
                Collection issueTypesForProject = ProjectResource.this.issueTypeSchemeManager.getIssueTypesForProject(project);
                ArrayList issueTypesWithStatuses = Lists.newArrayList();
                for (IssueType issueType : issueTypesForProject) {
                    JiraWorkflow workflow = ProjectResource.this.workflowManager.getWorkflow(project.getId(), issueType.getId());
                    ImmutableList statusJsonBeans = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)workflow.getLinkedStatusObjects(), (Function)new Function<Status, StatusJsonBean>(){

                        public StatusJsonBean apply(Status status) {
                            return ProjectResource.this.statusHelper.createStatusBean(status, ProjectResource.this.uriInfo, StatusResource.class);
                        }
                    }));
                    issueTypesWithStatuses.add(ProjectResource.this.createIssueTypeWithStatuses(issueType, (ImmutableList<StatusJsonBean>)statusJsonBeans));
                }
                return Response.ok((Object)issueTypesWithStatuses).cacheControl(CacheControl.NO_CACHE).build();
            }
        });
    }

    private void throwWebException(com.atlassian.jira.util.ErrorCollection errorCollection) {
        throw new RESTException(ErrorCollection.of(errorCollection));
    }

    private IssueTypeWithStatusJsonBean createIssueTypeWithStatuses(IssueType issueType, ImmutableList<StatusJsonBean> statusJsonBeans) {
        return new IssueTypeWithStatusJsonBean(this.uriBuilder.build(this.uriInfo, IssueTypeResource.class, issueType.getId()).toString(), issueType.getId(), issueType.getName(), issueType.isSubTask(), (Collection<StatusJsonBean>)statusJsonBeans);
    }

    private Either<Response, Project> getProjectForView(String projectIdOrKey) {
        return this.getEitherProjectOrErrors(projectIdOrKey, ProjectAction.VIEW_PROJECT);
    }

    private Either<Response, Project> getProjectForEdit(String projectIdOrKey) {
        return this.getEitherProjectOrErrors(projectIdOrKey, ProjectAction.EDIT_PROJECT_CONFIG);
    }

    private Either<Response, Project> getEitherProjectOrErrors(String projectIdOrKey, ProjectAction action) {
        ProjectService.GetProjectResult projectResult = this.projectFinder.getGetProjectForActionByIdOrKey(this.authContext.getUser(), projectIdOrKey, action);
        if (!projectResult.isValid()) {
            return Either.left((Object)this.responses.errorResponse(projectResult.getErrorCollection()));
        }
        return Either.right((Object)projectResult.getProject());
    }
}

