/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.ProjectCategoryJsonBean;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectCategoryImpl;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.v2.issue.project.ProjectCategoryBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;

@Path(value="projectCategory")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ProjectCategoryResource {
    private final ProjectManager projectManager;
    private final JiraBaseUrls jiraBaseUrls;
    private final JiraAuthenticationContext authContext;
    private final PermissionManager permissionManager;
    private final I18nHelper i18n;

    public ProjectCategoryResource(ProjectManager projectManager, JiraBaseUrls jiraBaseUrls, JiraAuthenticationContext authContext, PermissionManager permissionManager, I18nHelper i18n) {
        this.projectManager = projectManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.authContext = authContext;
        this.permissionManager = permissionManager;
        this.i18n = i18n;
    }

    @GET
    @ResponseType(value=ProjectCategoryBean.class)
    @Path(value="{id}")
    public Response getProjectCategoryById(@PathParam(value="id") Long id) {
        if (id == null) {
            return this.fieldValueMustBeProvidedResponse("id");
        }
        ProjectCategory projectCategory = this.projectManager.getProjectCategoryObject(id);
        if (projectCategory == null) {
            return this.projectCategoryNotFoundResponse(id);
        }
        return Response.ok((Object)ProjectCategoryJsonBean.bean((ProjectCategory)projectCategory, (JiraBaseUrls)this.jiraBaseUrls)).cacheControl(CacheControl.never()).build();
    }

    @GET
    @AnonymousAllowed
    @ResponseType(value=List.class, genericTypes={ProjectCategoryBean.class})
    public Response getAllProjectCategories() {
        Collection allProjectCategories = this.projectManager.getAllProjectCategories();
        Iterable beans = Iterables.transform((Iterable)allProjectCategories, (Function)new Function<ProjectCategory, ProjectCategoryJsonBean>(){

            public ProjectCategoryJsonBean apply(ProjectCategory projectCategory) {
                return ProjectCategoryJsonBean.bean((ProjectCategory)projectCategory, (JiraBaseUrls)ProjectCategoryResource.this.jiraBaseUrls);
            }
        });
        return Response.ok((Object)beans).cacheControl(CacheControl.never()).build();
    }

    @POST
    @RequestType(value=ProjectCategoryBean.class)
    @ResponseType(value=ProjectCategoryBean.class)
    public Response createProjectCategory(ProjectCategoryBean bean) {
        ApplicationUser user = this.authContext.getUser();
        if (user == null) {
            return this.userMustBeAuthenticatedResponse();
        }
        if (!this.permissionManager.hasPermission(0, user)) {
            return this.userMustBeAdminResponse();
        }
        if (StringUtils.isBlank((CharSequence)bean.getName())) {
            return this.fieldValueMustBeProvidedResponse("name");
        }
        if (StringUtils.isBlank((CharSequence)bean.getDescription())) {
            return this.fieldValueMustBeProvidedResponse("description");
        }
        if (!this.projectManager.isProjectCategoryUnique(bean.getName())) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)this.i18n.getText("rest.project.category.with.name.exists", bean.getName())).build();
        }
        ProjectCategory projectCategory = this.projectManager.createProjectCategory(bean.getName(), bean.getDescription());
        ProjectCategoryJsonBean projectCategoryBean = ProjectCategoryJsonBean.bean((ProjectCategory)projectCategory, (JiraBaseUrls)this.jiraBaseUrls);
        URI selfPath = UriBuilder.fromPath((String)projectCategoryBean.getSelf()).build(new Object[0]);
        return Response.status((Response.Status)Response.Status.CREATED).location(selfPath).entity((Object)projectCategoryBean).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="{id}")
    public Response removeProjectCategory(@PathParam(value="id") Long id) throws AtlassianCoreException {
        ApplicationUser user = this.authContext.getUser();
        if (user == null) {
            return this.userMustBeAuthenticatedResponse();
        }
        if (!this.permissionManager.hasPermission(0, user)) {
            return this.userMustBeAdminResponse();
        }
        if (id == null) {
            return this.fieldValueMustBeProvidedResponse("id");
        }
        ProjectCategory projectCategory = this.projectManager.getProjectCategoryObject(id);
        if (projectCategory == null) {
            return this.projectCategoryNotFoundResponse(id);
        }
        this.projectManager.removeProjectCategory(id);
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    @PUT
    @Path(value="{id}")
    @ResponseType(value=ProjectCategoryJsonBean.class)
    public Response updateProjectCategory(@PathParam(value="id") Long id, ProjectCategoryBean bean) {
        ApplicationUser user = this.authContext.getUser();
        if (user == null) {
            return this.userMustBeAuthenticatedResponse();
        }
        if (!this.permissionManager.hasPermission(0, user)) {
            return this.userMustBeAdminResponse();
        }
        if (id == null) {
            return this.fieldValueMustBeProvidedResponse("id");
        }
        ProjectCategory projectCategory = this.projectManager.getProjectCategoryObject(id);
        if (projectCategory == null) {
            return this.projectCategoryNotFoundResponse(id);
        }
        String name = bean.getName() != null ? bean.getName() : projectCategory.getName();
        String description = bean.getDescription() != null ? bean.getDescription() : projectCategory.getDescription();
        this.projectManager.updateProjectCategory((ProjectCategory)new ProjectCategoryImpl(projectCategory.getId(), name, description));
        ProjectCategory updatedProjectCategory = this.projectManager.getProjectCategoryObject(id);
        return Response.ok((Object)ProjectCategoryJsonBean.bean((ProjectCategory)updatedProjectCategory, (JiraBaseUrls)this.jiraBaseUrls)).cacheControl(CacheControl.never()).build();
    }

    private Response fieldValueMustBeProvidedResponse(String fieldName) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.i18n.getText("rest.missing.parameter", fieldName)).build();
    }

    private Response projectCategoryNotFoundResponse(Long id) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.i18n.getText("rest.project.category.not.found", id.toString())).build();
    }

    private Response userMustBeAuthenticatedResponse() {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.i18n.getText("rest.authentication.no.user.logged.in")).build();
    }

    private Response userMustBeAdminResponse() {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.i18n.getText("rest.authorization.admin.required")).build();
    }
}

