/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PrioritySchemeUpdateBean {
    private static final PrioritySchemeUpdateBean DOC_EXAMPLE_CREATE = new Builder().name("New priority scheme").description("Priority scheme for very important projects").optionIds((List<String>)ImmutableList.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5")).defaultOptionId("3").build();
    private static final PrioritySchemeUpdateBean DOC_EXAMPLE_UPDATE = new Builder().name("Updated priority scheme").description("Updated description").optionIds((List<String>)ImmutableList.of((Object)"5", (Object)"6", (Object)"7", (Object)"8", (Object)"9")).defaultOptionId("8").build();
    @JsonProperty
    private Long id;
    @JsonProperty
    private String name;
    @JsonProperty
    private String description;
    @JsonProperty
    private String defaultOptionId;
    @JsonProperty
    private List<String> optionIds;

    public PrioritySchemeUpdateBean() {
    }

    public PrioritySchemeUpdateBean(Long id, String name, String description, String defaultOptionId, List<String> optionIds) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.defaultOptionId = defaultOptionId;
        this.optionIds = optionIds;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultOptionId() {
        return this.defaultOptionId;
    }

    public List<String> getOptionIds() {
        return this.optionIds;
    }

    public static class Builder {
        private Long id;
        private String name;
        private String description;
        private String defaultOptionId;
        private List<String> optionIds;

        public Builder() {
        }

        public Builder(PrioritySchemeUpdateBean other) {
            this.id = other.getId();
            this.name = other.getName();
            this.description = other.getDescription();
            this.optionIds = other.getOptionIds();
            this.defaultOptionId = other.getDefaultOptionId();
        }

        public Builder id(Long id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder defaultOptionId(String defaultOptionId) {
            this.defaultOptionId = defaultOptionId;
            return this;
        }

        public Builder optionIds(List<String> optionIds) {
            this.optionIds = optionIds;
            return this;
        }

        public PrioritySchemeUpdateBean build() {
            return new PrioritySchemeUpdateBean(this.id, this.name, this.description, this.defaultOptionId, this.optionIds);
        }
    }
}

