/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.PrioritySchemeService;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.issue.PrioritySchemeBean;
import com.atlassian.jira.rest.v2.issue.PrioritySchemeListBean;
import com.atlassian.jira.rest.v2.issue.PrioritySchemeUpdateBean;
import com.atlassian.jira.rest.v2.priority.PrioritySchemeBeansFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.Page;
import com.atlassian.jira.util.PageRequest;
import com.atlassian.jira.util.PageRequests;
import com.atlassian.jira.util.Pages;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="priorityschemes")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class PrioritySchemeResource {
    private static final int DEFAULT_RESULTS = 100;
    private static final int MAX_RESULTS = 1000;
    private final PrioritySchemeService prioritySchemeService;
    private final JiraAuthenticationContext authContext;
    private final ResponseFactory responseFactory;
    private final PrioritySchemeBeansFactory prioritySchemeBeansFactory;

    public PrioritySchemeResource(@ComponentImport PrioritySchemeService prioritySchemeService, JiraAuthenticationContext authContext, ResponseFactory responseFactory, PrioritySchemeBeansFactory prioritySchemeBeansFactory) {
        this.prioritySchemeService = prioritySchemeService;
        this.authContext = authContext;
        this.responseFactory = responseFactory;
        this.prioritySchemeBeansFactory = prioritySchemeBeansFactory;
    }

    @POST
    @RequestType(value=PrioritySchemeBean.class)
    @ResponseType(value=PrioritySchemeBean.class)
    @ExperimentalApi
    public Response createPriorityScheme(@Context UriInfo uriInfo, PrioritySchemeUpdateBean data) {
        ServiceOutcome response = this.prioritySchemeService.createScheme(this.authContext.getLoggedInUser(), this.getServiceDataFromJsonData(data));
        if (!response.isValid()) {
            return this.responseFactory.errorResponse(response.getErrorCollection());
        }
        PrioritySchemeBean bean = this.prioritySchemeBeansFactory.buildResponseBean(this.authContext.getLoggedInUser(), uriInfo, (FieldConfigScheme)response.getReturnedValue());
        return Response.status((Response.Status)Response.Status.CREATED).location(bean.getSelf()).entity((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @Path(value="{schemeId}")
    @ExperimentalApi
    public Response deletePriorityScheme(@PathParam(value="schemeId") Long schemeId) {
        ServiceResult result = this.prioritySchemeService.deleteScheme(this.authContext.getLoggedInUser(), schemeId);
        if (!result.isValid()) {
            return this.responseFactory.errorResponse(result.getErrorCollection());
        }
        return this.responseFactory.noContent();
    }

    @PUT
    @Path(value="{schemeId}")
    @RequestType(value=PrioritySchemeUpdateBean.class)
    @ResponseType(value=PrioritySchemeBean.class)
    @ExperimentalApi
    public Response updatePriorityScheme(@Context UriInfo uriInfo, @PathParam(value="schemeId") Long schemeId, PrioritySchemeUpdateBean data) {
        PrioritySchemeUpdateBean updateData = new PrioritySchemeUpdateBean.Builder(data).id(schemeId).build();
        ServiceOutcome outcome = this.prioritySchemeService.editScheme(this.authContext.getLoggedInUser(), this.getServiceDataFromJsonData(updateData), true);
        if (!outcome.isValid()) {
            return this.responseFactory.errorResponse(outcome.getErrorCollection());
        }
        PrioritySchemeBean bean = this.prioritySchemeBeansFactory.buildResponseBean(this.authContext.getLoggedInUser(), uriInfo, (FieldConfigScheme)outcome.get());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{schemeId}")
    @ResponseType(value=PrioritySchemeBean.class)
    @ExperimentalApi
    public Response getPriorityScheme(@Context UriInfo uriInfo, @PathParam(value="schemeId") Long schemeId) {
        ServiceOutcome outcome = this.prioritySchemeService.getScheme(this.authContext.getLoggedInUser(), schemeId);
        if (!outcome.isValid()) {
            return this.responseFactory.errorResponse(outcome.getErrorCollection());
        }
        PrioritySchemeBean bean = this.prioritySchemeBeansFactory.buildResponseBean(this.authContext.getLoggedInUser(), uriInfo, (FieldConfigScheme)outcome.get());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)bean).cacheControl(CacheControl.never()).build();
    }

    @GET
    @ResponseType(value=PrioritySchemeListBean.class)
    @ExperimentalApi
    public Response getPrioritySchemes(@Context UriInfo uriInfo, @QueryParam(value="startAt") Long startAt, @QueryParam(value="maxResults") Integer maxResults) {
        ServiceOutcome schemesResponse = this.prioritySchemeService.getSchemes(this.authContext.getLoggedInUser());
        if (!schemesResponse.isValid()) {
            return this.responseFactory.errorResponse(schemesResponse.getErrorCollection());
        }
        int limit = maxResults != null && maxResults >= 0 ? Math.min(1000, maxResults) : 100;
        PageRequest pageRequest = PageRequests.request((Long)startAt, (Integer)limit);
        Collection sortedSchemes = (Collection)schemesResponse.get();
        Page schemesPage = Pages.toPage((Iterable)sortedSchemes, (PageRequest)pageRequest);
        List beans = (List)schemesPage.getValues().stream().map(scheme -> this.prioritySchemeBeansFactory.buildResponseBean(this.authContext.getLoggedInUser(), uriInfo, (FieldConfigScheme)scheme)).collect(CollectorsUtil.toImmutableList());
        return Response.ok((Object)new PrioritySchemeListBean(beans, pageRequest.getStart(), pageRequest.getLimit(), sortedSchemes.size())).cacheControl(CacheControl.never()).build();
    }

    private PrioritySchemeService.PrioritySchemeData getServiceDataFromJsonData(PrioritySchemeUpdateBean data) {
        return PrioritySchemeService.PrioritySchemeData.builder().id(data.getId()).name(data.getName()).description(data.getDescription()).priorityIds(data.getOptionIds()).defaultPriorityId(data.getDefaultOptionId()).build();
    }
}

