/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBeanBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.notification.CustomFieldValueNotification;
import com.atlassian.jira.notification.EmailNotification;
import com.atlassian.jira.notification.EventNotifications;
import com.atlassian.jira.notification.GroupNotification;
import com.atlassian.jira.notification.Notification;
import com.atlassian.jira.notification.NotificationScheme;
import com.atlassian.jira.notification.NotificationVisitor;
import com.atlassian.jira.notification.ProjectRoleNotification;
import com.atlassian.jira.notification.RoleNotification;
import com.atlassian.jira.notification.UserNotification;
import com.atlassian.jira.rest.api.field.FieldBean;
import com.atlassian.jira.rest.api.notification.AbstractNotificationBean;
import com.atlassian.jira.rest.api.notification.CustomFieldValueNotificationBean;
import com.atlassian.jira.rest.api.notification.EmailNotificationBean;
import com.atlassian.jira.rest.api.notification.GroupNotificationBean;
import com.atlassian.jira.rest.api.notification.NotificationEventBean;
import com.atlassian.jira.rest.api.notification.NotificationSchemeBean;
import com.atlassian.jira.rest.api.notification.NotificationSchemeBeanFactory;
import com.atlassian.jira.rest.api.notification.NotificationSchemeEventBean;
import com.atlassian.jira.rest.api.notification.NotificationSchemeExpandParam;
import com.atlassian.jira.rest.api.notification.ProjectRoleNotificationBean;
import com.atlassian.jira.rest.api.notification.RoleNotificationBean;
import com.atlassian.jira.rest.api.notification.UserNotificationBean;
import com.atlassian.jira.rest.api.project.ProjectRoleBean;
import com.atlassian.jira.rest.api.util.ExpandParameterParser;
import com.atlassian.jira.rest.v2.issue.project.ProjectRoleBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class NotificationSchemeBeanFactoryImpl
extends ExpandParameterParser<NotificationSchemeExpandParam>
implements NotificationSchemeBeanFactory {
    private final GroupJsonBeanBuilder groupJsonBeanBuilder;
    private final JiraBaseUrls jiraBaseUrls;
    private final ProjectRoleBeanFactory projectRoleBeanFactory;
    private final SearchHandlerManager searchHandlerManager;
    private final FieldManager fieldManager;
    private final EventTypeManager eventTypeManager;
    private final UserBeanFactory userBeanFactory;
    private final JiraAuthenticationContext authenticationContext;

    @Autowired
    public NotificationSchemeBeanFactoryImpl(I18nHelper i18nHelper, JiraBaseUrls jiraBaseUrls, ProjectRoleBeanFactory projectRoleBeanFactory, SearchHandlerManager searchHandlerManager, FieldManager fieldManager, EventTypeManager eventTypeManager, UserBeanFactory userBeanFactory, JiraAuthenticationContext authenticationContext) {
        super(i18nHelper, NotificationSchemeExpandParam.class);
        this.jiraBaseUrls = jiraBaseUrls;
        this.projectRoleBeanFactory = projectRoleBeanFactory;
        this.searchHandlerManager = searchHandlerManager;
        this.fieldManager = fieldManager;
        this.eventTypeManager = eventTypeManager;
        this.userBeanFactory = userBeanFactory;
        this.authenticationContext = authenticationContext;
        this.groupJsonBeanBuilder = new GroupJsonBeanBuilder(jiraBaseUrls);
    }

    @Override
    public NotificationSchemeBean createNotificationSchemeBean(NotificationScheme notificationScheme, List<NotificationSchemeExpandParam> expand) {
        return new NotificationSchemeBean(notificationScheme.getId(), this.getNotificationSchemeSelf(notificationScheme), notificationScheme.getName(), notificationScheme.getDescription(), expand.size() > 0 ? this.transformNotificationEvents(notificationScheme, expand) : null);
    }

    private Iterable<NotificationSchemeEventBean> transformNotificationEvents(NotificationScheme notificationScheme, final List<NotificationSchemeExpandParam> expand) {
        List eventNotifications = notificationScheme.getEventNotifications();
        return Iterables.transform((Iterable)eventNotifications, (Function)new Function<EventNotifications, NotificationSchemeEventBean>(){

            public NotificationSchemeEventBean apply(EventNotifications eventNotifications) {
                return new NotificationSchemeEventBean(NotificationSchemeBeanFactoryImpl.this.event(eventNotifications.getEventType()), NotificationSchemeBeanFactoryImpl.this.createNotificationBeans(eventNotifications.getNotifications(), expand));
            }
        });
    }

    private Iterable<AbstractNotificationBean> createNotificationBeans(Iterable<Notification> notifications, final List<NotificationSchemeExpandParam> expand) {
        return Iterables.transform(notifications, (Function)new Function<Notification, AbstractNotificationBean>(){

            public AbstractNotificationBean apply(Notification notification) {
                return (AbstractNotificationBean)notification.accept((NotificationVisitor)new NotificationVisitor<AbstractNotificationBean>(){

                    public AbstractNotificationBean visit(UserNotification userNotification) {
                        UserJsonBean userBean = NotificationSchemeBeanFactoryImpl.this.expand(expand, NotificationSchemeExpandParam.user) ? NotificationSchemeBeanFactoryImpl.this.userBeanFactory.createBean(userNotification.getApplicationUser(), NotificationSchemeBeanFactoryImpl.this.authenticationContext.getUser()) : null;
                        return new UserNotificationBean(userNotification.getId(), userNotification.getNotificationType(), userNotification.getParameter(), userBean);
                    }

                    public AbstractNotificationBean visit(GroupNotification groupNotification) {
                        GroupJsonBean groupBean = NotificationSchemeBeanFactoryImpl.this.expand(expand, NotificationSchemeExpandParam.group) ? NotificationSchemeBeanFactoryImpl.this.groupJsonBeanBuilder.group(groupNotification.getGroup()).build() : null;
                        return new GroupNotificationBean(groupNotification.getId(), groupNotification.getNotificationType(), groupNotification.getParameter(), groupBean);
                    }

                    public AbstractNotificationBean visit(ProjectRoleNotification projectRoleNotification) {
                        ProjectRoleBean projectRoleBean = NotificationSchemeBeanFactoryImpl.this.expand(expand, NotificationSchemeExpandParam.projectRole) ? NotificationSchemeBeanFactoryImpl.this.projectRoleBeanFactory.shortRoleBean(projectRoleNotification.getProjectRole()) : null;
                        return new ProjectRoleNotificationBean(projectRoleNotification.getId(), projectRoleNotification.getNotificationType(), projectRoleNotification.getParameter(), projectRoleBean);
                    }

                    public AbstractNotificationBean visit(EmailNotification emailNotification) {
                        return new EmailNotificationBean(emailNotification.getId(), emailNotification.getNotificationType(), emailNotification.getEmail());
                    }

                    public AbstractNotificationBean visit(CustomFieldValueNotification customFieldValueNotification) {
                        FieldBean fieldBean = NotificationSchemeBeanFactoryImpl.this.expand(expand, NotificationSchemeExpandParam.field) ? FieldBean.shortBean((Field)customFieldValueNotification.getCustomField(), NotificationSchemeBeanFactoryImpl.this.fieldManager, NotificationSchemeBeanFactoryImpl.this.searchHandlerManager) : null;
                        return new CustomFieldValueNotificationBean(customFieldValueNotification.getId(), customFieldValueNotification.getNotificationType(), customFieldValueNotification.getParameter(), fieldBean);
                    }

                    public AbstractNotificationBean visit(RoleNotification roleNotification) {
                        return new RoleNotificationBean(roleNotification.getId(), roleNotification.getNotificationType());
                    }
                });
            }
        });
    }

    private boolean expand(List<NotificationSchemeExpandParam> expandQueryParameter, NotificationSchemeExpandParam expectedExpandParameter) {
        return expandQueryParameter.contains((Object)expectedExpandParameter) || expandQueryParameter.contains((Object)NotificationSchemeExpandParam.all);
    }

    private NotificationEventBean event(EventType eventType) {
        if (!eventType.isSystemEventType()) {
            EventType templateEventType = this.eventTypeManager.getEventType(eventType.getTemplateId());
            NotificationEventBean templateEventBean = new NotificationEventBean(templateEventType.getId(), templateEventType.getName(), templateEventType.getDescription(), null);
            return new NotificationEventBean(eventType.getId(), eventType.getName(), eventType.getDescription(), templateEventBean);
        }
        return new NotificationEventBean(eventType.getId(), eventType.getName(), eventType.getDescription(), null);
    }

    private String getNotificationSchemeSelf(NotificationScheme notificationScheme) {
        return this.jiraBaseUrls.restApi2BaseUrl() + "notificationscheme/" + notificationScheme.getId();
    }
}

