/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueRefJsonBean;
import com.atlassian.jira.rest.api.issue.JsonTypeBean;
import com.atlassian.jira.rest.api.property.PropertiesBean;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.v2.issue.ChangelogBean;
import com.atlassian.jira.rest.v2.issue.EditMetaBean;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.rest.v2.issue.OpsbarBean;
import com.atlassian.jira.rest.v2.issue.TransitionBean;
import com.atlassian.plugins.rest.common.expand.Expandable;
import com.atlassian.plugins.rest.common.expand.SelfExpanding;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="issue")
public class IssueBean {
    @XmlAttribute
    private String expand;
    @XmlElement
    private String id;
    @XmlElement
    private URI self;
    @XmlElement
    private String key;
    @XmlElement
    private Map<String, Object> fields;
    @XmlElement
    private Map<String, Object> renderedFields;
    @XmlElement
    private PropertiesBean properties;
    @XmlTransient
    private final Map<String, Object> renderedFields_ = Maps.newHashMap();
    @XmlTransient
    @Expandable(value="renderedFields")
    private SelfExpanding renderedFieldExpander = new SelfExpanding(){

        public void expand() {
            IssueBean.this.renderedFields = IssueBean.this.renderedFields_;
        }
    };
    @XmlElement
    private Map<String, String> names;
    @XmlTransient
    private final Map<String, String> names_ = Maps.newHashMap();
    @XmlTransient
    @Expandable(value="names")
    private SelfExpanding namesExpander = new SelfExpanding(){

        public void expand() {
            IssueBean.this.names = IssueBean.this.names_;
        }
    };
    @XmlElement
    private Map<String, JsonTypeBean> schema;
    @XmlTransient
    private final Map<String, JsonTypeBean> schema_ = Maps.newHashMap();
    @XmlTransient
    @Expandable(value="schema")
    private SelfExpanding schemaExpander = new SelfExpanding(){

        public void expand() {
            IssueBean.this.schema = IssueBean.this.schema_;
        }
    };
    @XmlElement
    @Expandable(value="transitions")
    private List<TransitionBean> transitions;
    @XmlElement
    private OpsbarBean operations;
    @XmlTransient
    private OpsbarBean operations_;
    @XmlTransient
    @Expandable(value="operations")
    private SelfExpanding operationsExpander = new SelfExpanding(){

        public void expand() {
            IssueBean.this.operations = IssueBean.this.operations_;
        }
    };
    @XmlTransient
    @Expandable(value="editmeta")
    private SelfExpanding editmetaExpander = new SelfExpanding(){

        public void expand() {
            IssueBean.this.editmeta = IssueBean.this.editmeta_;
        }
    };
    @XmlElement
    private EditMetaBean editmeta;
    @XmlTransient
    private EditMetaBean editmeta_;
    @XmlTransient
    @Expandable(value="changelog")
    private SelfExpanding changelogExpander = new SelfExpanding(){

        public void expand() {
            IssueBean.this.changelog = IssueBean.this.changelog_;
        }
    };
    @XmlElement
    private ChangelogBean changelog;
    @XmlTransient
    private ChangelogBean changelog_;
    @XmlTransient
    @Expandable(value="versionedRepresentations")
    private SelfExpanding versionedRepresentationsExpander = new SelfExpanding(){

        public void expand() {
            IssueBean.this.versionedRepresentations = IssueBean.this.versionedRepresentations_;
        }
    };
    @XmlElement
    private Map<String, Map<Integer, Object>> versionedRepresentations;
    @XmlTransient
    private final Map<String, Map<Integer, Object>> versionedRepresentations_ = Maps.newHashMap();
    private IncludedFields fieldsToInclude;

    public IssueBean() {
    }

    public IssueBean(Long id, String key, URI selfUri) {
        this(id == null ? null : id.toString(), key, selfUri);
    }

    public IssueBean(String id, String key, URI selfUri) {
        this.id = id;
        this.self = selfUri;
        this.key = key;
    }

    public IssueBean fieldsToInclude(IncludedFields fieldsToInclude) {
        this.fieldsToInclude = fieldsToInclude;
        return this;
    }

    public IssueBean fields(Map<String, Object> fields) {
        this.fields = Maps.newHashMap(fields);
        return this;
    }

    public void addField(Field field, FieldJsonRepresentation data, boolean includeRenderedVersion) {
        this.addField(field.getName(), field, data, includeRenderedVersion);
    }

    public void addField(String displayName, Field field, FieldJsonRepresentation data, boolean includeRenderedVersion) {
        if ((this.fieldsToInclude == null || this.fieldsToInclude.included(field)) && data.getStandardData() != null) {
            JsonType schema = field instanceof RestAwareField ? ((RestAwareField)field).getJsonSchema() : null;
            String fieldId = field.getId();
            this.addRawField(fieldId, displayName, schema, data.getStandardData().getData());
            if (includeRenderedVersion && data.getRenderedData() != null) {
                this.renderedFields_.put(fieldId, data.getRenderedData().getData());
            }
        }
    }

    public void addParentField(IssueRefJsonBean value, String displayName) {
        String fieldId = "parent";
        if (this.fieldsToInclude == null || this.fieldsToInclude.included("parent", true)) {
            JsonType schema = JsonTypeBuilder.systemArray((String)"issuelinks", (String)"parent");
            this.addRawField("parent", displayName, schema, value);
        }
    }

    void addRawField(String fieldId, String displayName, JsonType schema, Object value) {
        if (this.fields == null) {
            this.fields = Maps.newHashMap();
        }
        this.names_.put(fieldId, displayName);
        if (schema != null) {
            this.schema_.put(fieldId, new JsonTypeBean(schema));
        }
        this.fields.put(fieldId, value);
    }

    public boolean hasField(String fieldId) {
        return this.fields != null && this.fields.containsKey(fieldId);
    }

    public String getKey() {
        return this.key;
    }

    public String getId() {
        return this.id;
    }

    public URI getSelf() {
        return this.self;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public Map<String, Object> getRenderedFields() {
        return this.renderedFields_;
    }

    public PropertiesBean getProperties() {
        return this.properties;
    }

    public void setProperties(PropertiesBean properties) {
        this.properties = properties;
    }

    public Map<String, String> getNames() {
        return this.names_;
    }

    public Map<String, JsonTypeBean> getSchema() {
        return this.schema_;
    }

    public List<TransitionBean> getTransitions() {
        return this.transitions;
    }

    public OpsbarBean getOperations() {
        return this.operations_;
    }

    public EditMetaBean getEditMeta() {
        return this.editmeta_;
    }

    public ChangelogBean getChangelog() {
        return this.changelog_;
    }

    public Map<String, Map<Integer, Object>> getVersionedRepresentations() {
        return this.versionedRepresentations_;
    }

    public void setFieldsToInclude(IncludedFields fieldsToInclude) {
        this.fieldsToInclude = fieldsToInclude;
    }

    public void addFields(Map<String, Object> fields) {
        if (fields.isEmpty()) {
            return;
        }
        if (this.fields == null) {
            this.fields = new HashMap<String, Object>();
        }
        this.fields.putAll(fields);
    }

    public void addNames(Map<String, String> names) {
        this.names_.putAll(names);
    }

    public void addRenderedFields(Map<String, Object> renderedFields) {
        this.renderedFields_.putAll(renderedFields);
    }

    public void addSchema(Map<String, JsonTypeBean> schema) {
        this.schema_.putAll(schema);
    }

    public void addTransitionBeans(List<TransitionBean> transitionBeans) {
        this.addAll(transitionBeans);
    }

    public void setEditMeta(EditMetaBean editMeta) {
        this.editmeta_ = editMeta;
    }

    public void setOperations(OpsbarBean opsbarBean) {
        this.operations_ = opsbarBean;
    }

    public void setChangelog(ChangelogBean changelog) {
        this.changelog_ = changelog;
    }

    public void addVersionedRepresentations(Map<String, Map<Integer, Object>> versionedRepresentations) {
        this.versionedRepresentations_.putAll(versionedRepresentations);
    }

    public List<String> expand() {
        return StringList.fromQueryParam(this.expand).asList();
    }

    public IssueBean expand(Iterable<String> expand) {
        this.expand = expand != null ? StringList.fromList(expand).toQueryParam() : null;
        return this;
    }

    public Map<String, String> names() {
        return this.names;
    }

    public IssueBean names(@Nullable Map<String, String> names) {
        this.names = names;
        return this;
    }

    public Map<String, JsonTypeBean> schema() {
        return this.schema;
    }

    public IssueBean schema(@Nullable Map<String, JsonTypeBean> schema) {
        this.schema = schema;
        return this;
    }

    public IssueBean editmeta(EditMetaBean editmeta) {
        this.editmeta_ = editmeta;
        return this;
    }

    public void setTransitionBeans(List<TransitionBean> transitionBeans) {
        this.addAll(transitionBeans);
    }

    public IssueBean changelog(ChangelogBean changelog) {
        this.changelog_ = changelog;
        return this;
    }

    private void addAll(List<TransitionBean> transitionBeans) {
        if (this.transitions == null) {
            this.transitions = Lists.newArrayList();
        }
        this.transitions.addAll(transitionBeans);
    }
}

