/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.v2.issue.AbstractMetaFieldBeanBuilder;
import com.atlassian.jira.rest.v2.issue.EditIssueOperationContext;
import com.atlassian.jira.rest.v2.issue.FieldMetaBean;
import com.atlassian.jira.rest.v2.issue.context.ContextUriInfo;
import com.atlassian.jira.rest.v2.issue.version.VersionBeanFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class EditMetaFieldBeanBuilder
extends AbstractMetaFieldBeanBuilder {
    private final OperationContext operationContext = new EditIssueOperationContext();
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final FieldManager fieldManager;
    private final IssueManager issueManager;

    public EditMetaFieldBeanBuilder(FieldLayoutManager fieldLayoutManager, Project project, Issue issue, IssueType issueType, ApplicationUser user, VersionBeanFactory versionBeanFactory, VelocityRequestContextFactory velocityRequestContextFactory, ContextUriInfo contextUriInfo, JiraBaseUrls baseUrls, FieldScreenRendererFactory fieldScreenRendererFactory, FieldManager fieldManager, IssueManager issueManager) {
        super(fieldLayoutManager, project, issue, issueType, user, versionBeanFactory, velocityRequestContextFactory, contextUriInfo, baseUrls, null);
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.fieldManager = fieldManager;
        this.issueManager = issueManager;
    }

    @Override
    protected void addAdditionalFields(Map<String, FieldMetaBean> fields) {
        this.getCommentFieldOption().forEach(commentField -> {
            FieldMetaBean fieldMetaBean = this.getFieldMetaBean(false, (OrderableField)commentField);
            fields.put(commentField.getId(), fieldMetaBean);
        });
    }

    @Override
    protected Stream<String> getAdditionalKeys() {
        return StreamSupport.stream(this.getCommentFieldOption().map(Field::getId).spliterator(), false);
    }

    private Option<OrderableField> getCommentFieldOption() {
        OrderableField field = (OrderableField)this.fieldManager.getField(SystemSearchConstants.forComments().getFieldId());
        if (field.isShown(this.issue) && (this.includeFields == null || this.includeFields.included((Field)field))) {
            return Option.some((Object)field);
        }
        return Option.none();
    }

    @Override
    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    @Override
    public boolean hasPermissionToPerformOperation() {
        return this.issueManager.isEditable(this.issue, this.user);
    }

    @Override
    Stream<FieldScreenRenderTab> getFieldScreenRenderTabsStream(Issue issue) {
        return this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)IssueOperations.EDIT_ISSUE_OPERATION).getFieldScreenRenderTabs().stream();
    }
}

