/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarPickerHelperImpl;
import com.atlassian.jira.avatar.AvatarUrls;
import com.atlassian.jira.rest.v2.issue.AvatarBean;
import com.atlassian.jira.rest.v2.issue.AvatarCroppingBean;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AvatarBeanFactory {
    private final AvatarManager avatarManager;

    public AvatarBeanFactory(AvatarManager avatarManager) {
        this.avatarManager = avatarManager;
    }

    public List<AvatarBean> createAvatarBeans(List<Avatar> avatars, ApplicationUser avatarUser) {
        ArrayList beans = Lists.newArrayListWithCapacity((int)avatars.size());
        for (Avatar avatar : avatars) {
            Long id = avatar.getId();
            Map avatarURLs = AvatarUrls.getAvatarURLs((ApplicationUser)avatarUser, (Avatar)avatar);
            beans.add(new AvatarBean(id.toString(), avatar.getOwner(), avatar.isSystemAvatar(), this.avatarManager.userCanDelete(avatarUser, avatar), avatarURLs));
        }
        return beans;
    }

    public static AvatarBean createAvatarBean(Avatar avatar, ApplicationUser remoteUser, boolean userCanDelete) {
        return new AvatarBean(avatar.getId().toString(), avatar.getOwner(), avatar.isSystemAvatar(), userCanDelete);
    }

    public static AvatarCroppingBean createTemporaryAvatarCroppingInstructions(AvatarPickerHelperImpl.TemporaryAvatarBean temporaryAvatarBean) {
        return new AvatarCroppingBean(temporaryAvatarBean.getUrl(), temporaryAvatarBean.getCropperWidth(), temporaryAvatarBean.getCropperOffsetY(), temporaryAvatarBean.getCropperOffsetX(), temporaryAvatarBean.isCroppingNeeded());
    }
}

