/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.fugue.Pair;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.AbstractVersionsSystemField;
import com.atlassian.jira.issue.fields.ComponentsSystemField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.IssueTypeSystemField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.PrioritySystemField;
import com.atlassian.jira.issue.fields.ResolutionSystemField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContextImpl;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.beans.ComponentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.PriorityJsonBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.v2.issue.DefaultFieldMetaBeanHelper;
import com.atlassian.jira.rest.v2.issue.FieldMetaBean;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.rest.v2.issue.ResolutionBean;
import com.atlassian.jira.rest.v2.issue.context.ContextUriInfo;
import com.atlassian.jira.rest.v2.issue.version.VersionBeanFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractMetaFieldBeanBuilder {
    protected final FieldLayoutManager fieldLayoutManager;
    protected Project project;
    protected IssueType issueType;
    protected ApplicationUser user;
    protected Issue issue;
    private final VersionBeanFactory versionBeanFactory;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ContextUriInfo contextUriInfo;
    protected JiraBaseUrls baseUrls;
    protected IncludedFields includeFields;
    protected DefaultFieldMetaBeanHelper defaultFieldHelper;

    public AbstractMetaFieldBeanBuilder(FieldLayoutManager fieldLayoutManager, Project project, Issue issue, IssueType issueType, ApplicationUser user, VersionBeanFactory versionBeanFactory, VelocityRequestContextFactory velocityRequestContextFactory, ContextUriInfo contextUriInfo, JiraBaseUrls baseUrls, DefaultFieldMetaBeanHelper defaultFieldHelper) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.project = project;
        this.issue = issue;
        this.issueType = issueType;
        this.user = user;
        this.versionBeanFactory = versionBeanFactory;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.contextUriInfo = contextUriInfo;
        this.baseUrls = baseUrls;
        this.defaultFieldHelper = defaultFieldHelper;
    }

    public void fieldsToInclude(IncludedFields includeFields) {
        this.includeFields = includeFields;
    }

    public Map<String, FieldMetaBean> build() {
        if (this.hasPermissionToPerformOperation()) {
            Map<String, FieldMetaBean> fields = this.getFieldScreenRenderLayoutItems().map(FieldScreenRenderLayoutItem::getFieldLayoutItem).filter(layout -> layout.getOrderableField().isShown(this.issue)).filter(layout -> this.includeFields == null || this.includeFields.included((Field)layout.getOrderableField())).map(layout -> Pair.pair((Object)layout.getOrderableField().getId(), (Object)this.getFieldMetaBean(layout.isRequired(), layout.getOrderableField()))).collect(Collectors.toMap(Pair::left, Pair::right));
            this.addAdditionalFields(fields);
            return fields;
        }
        return Collections.emptyMap();
    }

    public Set<String> buildKeys() {
        if (this.hasPermissionToPerformOperation()) {
            return Stream.concat(this.getFieldScreenRenderLayoutItems().map(FieldScreenRenderLayoutItem::getFieldLayoutItem).map(FieldLayoutItem::getOrderableField).map(Field::getId), this.getAdditionalKeys()).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    protected abstract Stream<String> getAdditionalKeys();

    protected void addAdditionalFields(Map<String, FieldMetaBean> fields) {
    }

    protected FieldMetaBean getFieldMetaBean(boolean required, OrderableField field) {
        Collection<?> allowedValues;
        JsonType jsonType;
        FieldTypeInfo fieldTypeInfo;
        Collection<Object> operations = field instanceof RestFieldOperations ? ((RestFieldOperations)field).getRestFieldOperation().getSupportedOperations() : Collections.emptyList();
        if (field instanceof RestAwareField) {
            FieldTypeInfoContextImpl fieldTypeInfoContext = new FieldTypeInfoContextImpl(field, this.issue, (IssueContext)new IssueContextImpl(this.project.getId(), this.issueType.getId()), this.getOperationContext());
            fieldTypeInfo = ((RestAwareField)field).getFieldTypeInfo((FieldTypeInfoContext)fieldTypeInfoContext);
            jsonType = this.getJsonType((RestAwareField)field);
            allowedValues = this.getAllowedValueBeans(field, fieldTypeInfo.getAllowedValues());
        } else {
            fieldTypeInfo = new FieldTypeInfo(null, null);
            jsonType = null;
            allowedValues = null;
        }
        Boolean hasDefaultValue = this.defaultFieldHelper == null ? null : Boolean.valueOf(this.defaultFieldHelper.hasDefaultValue(field));
        return new FieldMetaBean(required, hasDefaultValue, jsonType, field.getName(), fieldTypeInfo.getAutoCompleteUrl(), operations, allowedValues);
    }

    protected JsonType getJsonType(RestAwareField field) {
        return field.getJsonSchema();
    }

    protected Collection<?> getAllowedValueBeans(OrderableField field, Collection<?> allowedValues) {
        if (allowedValues == null) {
            return null;
        }
        if (field instanceof IssueTypeSystemField) {
            return IssueTypeJsonBean.shortBeans(allowedValues, (JiraBaseUrls)this.baseUrls);
        }
        if (field instanceof PrioritySystemField) {
            return PriorityJsonBean.shortBeans(allowedValues, (JiraBaseUrls)this.baseUrls);
        }
        if (field instanceof AbstractVersionsSystemField) {
            return this.versionBeanFactory.createVersionBeans(allowedValues, false);
        }
        if (field instanceof ComponentsSystemField) {
            return ComponentJsonBean.shortBeans(allowedValues, (JiraBaseUrls)this.baseUrls);
        }
        if (field instanceof ResolutionSystemField) {
            return ResolutionBean.asBeans(allowedValues, this.contextUriInfo, this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl());
        }
        return allowedValues;
    }

    protected Stream<FieldScreenRenderLayoutItem> getFieldScreenRenderLayoutItems() {
        return this.getFieldScreenRenderTabsStream(this.issue).map(FieldScreenRenderTab::getFieldScreenRenderLayoutItemsForProcessing).flatMap(Collection::stream);
    }

    public abstract OperationContext getOperationContext();

    public abstract boolean hasPermissionToPerformOperation();

    abstract Stream<FieldScreenRenderTab> getFieldScreenRenderTabsStream(Issue var1);
}

