/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.entity.property;

import com.atlassian.fugue.Function2;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.entity.WithKey;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.entity.property.EntityWithKeyPropertyService;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.v2.entity.property.BasePropertyResource;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;

public class BasePropertyWithKeyResource<E extends WithId & WithKey>
extends BasePropertyResource<E> {
    private final EntityWithKeyPropertyService<E> entityPropertyService;
    private final Predicate<String> isValidKeyPredicate;

    public BasePropertyWithKeyResource(EntityWithKeyPropertyService<E> entityPropertyService, JiraAuthenticationContext authContext, JiraBaseUrls jiraBaseUrls, I18nHelper i18n, Predicate<String> validKeyPredicate, Function2<Long, String, String> entityIdAndPropertyKeyToSelfFunction, EntityPropertyType entityPropertyType) {
        super(entityPropertyService, authContext, jiraBaseUrls, i18n, entityIdAndPropertyKeyToSelfFunction, entityPropertyType);
        this.entityPropertyService = entityPropertyService;
        this.isValidKeyPredicate = (Predicate)Preconditions.checkNotNull(validKeyPredicate);
    }

    @Override
    protected EntityPropertyService.PropertyKeys<E> getPropertiesKeys(final ApplicationUser user, String idOrKey) {
        return (EntityPropertyService.PropertyKeys)this.withKeyValidation(idOrKey, new Function<String, EntityPropertyService.PropertyKeys<E>>(){

            public EntityPropertyService.PropertyKeys<E> apply(String entityKey) {
                return BasePropertyWithKeyResource.this.entityPropertyService.getPropertiesKeys(user, entityKey);
            }
        }, new Function<Long, EntityPropertyService.PropertyKeys<E>>(){

            public EntityPropertyService.PropertyKeys<E> apply(Long entityId) {
                return BasePropertyWithKeyResource.this.entityPropertyService.getPropertiesKeys(user, entityId);
            }
        });
    }

    @Override
    protected EntityPropertyService.SetPropertyValidationResult validateSetProperty(final ApplicationUser user, final EntityPropertyService.PropertyInput propertyInput, String idOrKey) {
        return this.withKeyValidation(idOrKey, new Function<String, EntityPropertyService.SetPropertyValidationResult>(){

            public EntityPropertyService.SetPropertyValidationResult apply(String key) {
                return BasePropertyWithKeyResource.this.entityPropertyService.validateSetProperty(user, key, propertyInput);
            }
        }, new Function<Long, EntityPropertyService.SetPropertyValidationResult>(){

            public EntityPropertyService.SetPropertyValidationResult apply(Long id) {
                return BasePropertyWithKeyResource.this.entityPropertyService.validateSetProperty(user, id, propertyInput);
            }
        });
    }

    @Override
    protected EntityPropertyService.PropertyResult getProperty(final ApplicationUser user, final String propertyKey, String idOrKey) {
        return this.withKeyValidation(idOrKey, new Function<String, EntityPropertyService.PropertyResult>(){

            public EntityPropertyService.PropertyResult apply(String key) {
                return BasePropertyWithKeyResource.this.entityPropertyService.getProperty(user, key, propertyKey);
            }
        }, new Function<Long, EntityPropertyService.PropertyResult>(){

            public EntityPropertyService.PropertyResult apply(Long id) {
                return BasePropertyWithKeyResource.this.entityPropertyService.getProperty(user, id, propertyKey);
            }
        });
    }

    @Override
    protected EntityPropertyService.DeletePropertyValidationResult validateDeleteProperty(final ApplicationUser user, final String propertyKey, String id) {
        return this.withKeyValidation(id, new Function<String, EntityPropertyService.DeletePropertyValidationResult>(){

            public EntityPropertyService.DeletePropertyValidationResult apply(String entityKey) {
                return BasePropertyWithKeyResource.this.entityPropertyService.validateDeleteProperty(user, entityKey, propertyKey);
            }
        }, new Function<Long, EntityPropertyService.DeletePropertyValidationResult>(){

            public EntityPropertyService.DeletePropertyValidationResult apply(Long entityId) {
                return BasePropertyWithKeyResource.this.entityPropertyService.validateDeleteProperty(user, entityId, propertyKey);
            }
        });
    }

    private <T> T withKeyValidation(String idOrKey, Function<String, T> keyFunction, Function<Long, T> idFunction) {
        if (this.isValidKeyPredicate.apply((Object)idOrKey)) {
            return (T)keyFunction.apply((Object)idOrKey);
        }
        return this.withIdValidation(idOrKey, idFunction);
    }
}

