/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.avatar;

import com.atlassian.core.util.thumbnail.Thumber;
import com.atlassian.core.util.thumbnail.ThumbnailDimension;
import com.atlassian.jira.avatar.AvatarFormat;
import com.atlassian.jira.rest.v2.avatar.UploadedAvatar;
import com.google.common.base.Predicates;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.springframework.stereotype.Component;

@Component
class ImageFileOperations {
    private static final String AVATAR_IMAGE_FORMAT = "png";
    public static final AvatarFormat AVATAR_IMAGE_FORMAT_FULL = new AvatarFormat("png", "image/png");
    private final Thumber thumber = new Thumber();

    public Image getImageFromFile(File sourceFile) throws IOException {
        BufferedImage sourceImage = this.thumber.getImage(sourceFile, Predicates.alwaysTrue());
        if (sourceImage == null) {
            throw new IOException("invalid image format: " + sourceFile.getName());
        }
        return sourceImage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UploadedAvatar scaleImageToTempFile(File sourceFile, ThumbnailDimension sourceDimension, File targetFile, int edgeSize) throws IOException {
        ThumbnailDimension targetDimension = this.thumber.determineScaleSize(edgeSize, edgeSize, sourceDimension.getWidth(), sourceDimension.getHeight());
        try (FileInputStream sourceIn = new FileInputStream(sourceFile);){
            BufferedImage scaledImage = this.thumber.scaleImage(targetDimension.getWidth(), targetDimension.getHeight(), (InputStream)sourceIn);
            ImageIO.write((RenderedImage)scaledImage, AVATAR_IMAGE_FORMAT, targetFile);
            UploadedAvatar uploadedAvatar = new UploadedAvatar(targetFile, AVATAR_IMAGE_FORMAT_FULL.getContentType(), targetDimension.getWidth(), targetDimension.getHeight());
            return uploadedAvatar;
        }
    }
}

