/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.avatar;

import com.atlassian.jira.util.LimitedOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Component;

@Component
public class FileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createTempFileFromBoundedStream(InputStream stream, long size, String filenamePrefix) throws LimitedOutputStream.TooBigIOException, StreamSizeMismatchException, IOException {
        File file;
        File tempFile = this.createTemporaryFile(filenamePrefix, null);
        BufferedOutputStream fileOutput = new BufferedOutputStream(new FileOutputStream(tempFile));
        try {
            LimitedOutputStream limitedOutput = new LimitedOutputStream((OutputStream)new BufferedOutputStream(fileOutput), size);
            IOUtils.copy((InputStream)stream, (OutputStream)limitedOutput);
            limitedOutput.flush();
            if (limitedOutput.getCurrentLength() != size) {
                throw new StreamSizeMismatchException(size, limitedOutput.getCurrentLength());
            }
            file = tempFile;
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((OutputStream)fileOutput);
                throw throwable;
            }
            catch (IOException x) {
                tempFile.delete();
                throw x;
            }
            catch (RuntimeException x) {
                tempFile.delete();
                throw x;
            }
        }
        IOUtils.closeQuietly((OutputStream)fileOutput);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createTempFile(InputStream stream, String filenamePrefix) throws IOException {
        File file;
        File tempFile = this.createTemporaryFile(filenamePrefix, null);
        FileOutputStream fileOutput = new FileOutputStream(tempFile);
        try {
            IOUtils.copy((InputStream)stream, (OutputStream)fileOutput);
            file = tempFile;
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((OutputStream)fileOutput);
                throw throwable;
            }
            catch (IOException x) {
                tempFile.delete();
                throw x;
            }
            catch (RuntimeException x) {
                tempFile.delete();
                throw x;
            }
        }
        IOUtils.closeQuietly((OutputStream)fileOutput);
        return file;
    }

    public File createTemporaryFile(String prefix, String suffix) throws IOException {
        File tempFile = File.createTempFile(prefix, suffix);
        tempFile.deleteOnExit();
        return tempFile;
    }

    public static class StreamSizeMismatchException
    extends IOException {
        private final long expectedSize;
        private final long actualSize;

        public StreamSizeMismatchException(long expectedSize, long actualSize) {
            this.expectedSize = expectedSize;
            this.actualSize = actualSize;
        }

        public long getExpectedSize() {
            return this.expectedSize;
        }

        public long getActualSize() {
            return this.actualSize;
        }
    }
}

