/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.workflowscheme;

import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.rest.v2.admin.workflowscheme.DefaultBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.IssueTypeMappingBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.WorkflowMappingBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.WorkflowSchemeBean;
import com.atlassian.jira.rest.v2.admin.workflowscheme.WorkflowSchemeResource;
import com.atlassian.jira.rest.v2.issue.IssueTypeBeanBuilder;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.rest.v2.issue.context.ContextUriInfo;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowSchemeBeanFactory {
    private final ContextUriInfo info;
    private final IssueTypeManager issueTypeManager;
    private final JiraBaseUrls jiraBaseUrls;
    private final DateTimeFormatter formatter;

    @Autowired
    public WorkflowSchemeBeanFactory(ContextUriInfo info, DateTimeFormatter formatter, IssueTypeManager issueTypeManager, JiraBaseUrls jiraBaseUrls) {
        this.info = info;
        this.issueTypeManager = issueTypeManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.formatter = formatter.withStyle(DateTimeStyle.RELATIVE);
    }

    WorkflowSchemeBean asBean(AssignableWorkflowScheme parent, DraftWorkflowScheme child) {
        WorkflowSchemeBean bean = new WorkflowSchemeBean();
        bean.setName(parent.getName());
        bean.setDescription(parent.getDescription());
        DraftWorkflowScheme scheme = child != null ? child : parent;
        bean.setDefaultWorkflow(scheme.getConfiguredDefaultWorkflow());
        bean.setIssueTypeMappings(WorkflowSchemeBeanFactory.asIssueTypeMap((WorkflowScheme)scheme));
        bean.setId(scheme.getId());
        bean.setDraft(scheme.isDraft());
        bean.setDefaultWorkflow(scheme.getActualDefaultWorkflow());
        final IssueTypeBeanBuilder builder = new IssueTypeBeanBuilder().context(this.info).jiraBaseUrls(this.jiraBaseUrls);
        bean.setIssueTypes((Map<String, IssueTypeJsonBean>)Maps.uniqueIndex((Iterable)Iterables.transform((Iterable)this.issueTypeManager.getIssueTypes(), (Function)new Function<IssueType, IssueTypeJsonBean>(){

            public IssueTypeJsonBean apply(IssueType issueType) {
                return builder.issueType(issueType).build();
            }
        }), (Function)new Function<IssueTypeJsonBean, String>(){

            public String apply(IssueTypeJsonBean issueType) {
                return issueType.getId();
            }
        }));
        if (child != null) {
            bean.setLastModifiedUser(this.beanForUser(child.getLastModifiedUser()));
            bean.setLastModified(this.formatter.forLoggedInUser().format(child.getLastModifiedDate()));
            bean.setOriginalIssueTypeMappings(WorkflowSchemeBeanFactory.asIssueTypeMap((WorkflowScheme)parent));
            bean.setSelf(this.getUrlForParent(parent).path("draft").build(new Object[0]));
            bean.setOriginalDefaultWorkflow(child.getParentScheme().getActualDefaultWorkflow());
        } else {
            bean.setSelf(this.getUrlForParent(parent).build(new Object[0]));
        }
        return bean;
    }

    private static Map<String, String> asIssueTypeMap(WorkflowScheme scheme) {
        HashMap mappings = Maps.newHashMap((Map)scheme.getMappings());
        mappings.remove(null);
        return mappings;
    }

    static Map<String, WorkflowMappingBean> asMappingBeans(WorkflowScheme scheme) {
        if (scheme.getMappings().isEmpty()) {
            return ImmutableMap.of();
        }
        HashMap mappings = Maps.newHashMap();
        for (Map.Entry mapping : scheme.getMappings().entrySet()) {
            String issueType = (String)mapping.getKey();
            String workflowName = (String)mapping.getValue();
            WorkflowMappingBean mappingBean = (WorkflowMappingBean)mappings.get(workflowName);
            if (mappingBean == null) {
                mappingBean = new WorkflowMappingBean(workflowName, Lists.newArrayList());
                mappingBean.setDefaultMapping(false);
                mappings.put(workflowName, mappingBean);
            }
            if (issueType != null) {
                mappingBean.addIssueType(issueType);
                continue;
            }
            mappingBean.setDefaultMapping(true);
        }
        if (scheme.getConfiguredDefaultWorkflow() == null) {
            WorkflowMappingBean bean = (WorkflowMappingBean)mappings.get("jira");
            if (bean == null) {
                bean = new WorkflowMappingBean("jira", Lists.newArrayList());
                bean.setIssueTypes(Collections.emptyList());
                mappings.put("jira", bean);
            }
            bean.setDefaultMapping(true);
        }
        return mappings;
    }

    static WorkflowMappingBean asMappingBean(WorkflowScheme scheme, String workflow) {
        WorkflowMappingBean workflowMappingBean = new WorkflowMappingBean(workflow, Lists.newArrayList());
        workflowMappingBean.setDefaultMapping(false);
        for (Map.Entry mapping : scheme.getMappings().entrySet()) {
            String issueType = (String)mapping.getKey();
            String workflowName = (String)mapping.getValue();
            if (!workflow.equals(workflowName) || issueType == null) continue;
            workflowMappingBean.addIssueType(issueType);
        }
        workflowMappingBean.setDefaultMapping(scheme.getActualDefaultWorkflow().equals(workflow));
        return workflowMappingBean;
    }

    static IssueTypeMappingBean asIssueTypeBean(WorkflowScheme scheme, String issueType) {
        IssueTypeMappingBean workflowTypeMappingBean = new IssueTypeMappingBean();
        workflowTypeMappingBean.setIssueType(issueType);
        String configuredWorkflow = scheme.getConfiguredWorkflow(issueType);
        workflowTypeMappingBean.setWorkflow(configuredWorkflow);
        return workflowTypeMappingBean;
    }

    private UriBuilder getUrlForParent(AssignableWorkflowScheme scheme) {
        return this.info.getBaseUriBuilder().path(WorkflowSchemeResource.class).path(String.valueOf(scheme.getId()));
    }

    private UserBean beanForUser(ApplicationUser user) {
        return new UserBeanBuilder(this.jiraBaseUrls).user(user).buildShort();
    }

    public static DefaultBean asDefaultBean(WorkflowScheme scheme) {
        return new DefaultBean(scheme.getActualDefaultWorkflow());
    }
}

