/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.auditing;

import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class AssociatedItemBean {
    private String id;
    private String name;
    private String typeName;
    private String parentId;
    private String parentName;

    public AssociatedItemBean() {
    }

    public AssociatedItemBean(AssociatedItem item) {
        this.id = item.getObjectId();
        this.name = item.getObjectName();
        this.typeName = item.getObjectType().name();
        this.parentId = item.getParentId();
        this.parentName = item.getParentName();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getParentName() {
        return this.parentName;
    }

    public AssociatedItem toAssociatedItem() {
        Assertions.notBlank((String)"name", (String)this.name);
        Assertions.notBlank((String)"typeName", (String)this.typeName);
        final AssociatedItem.Type type = AssociatedItem.Type.valueOf((String)this.typeName);
        return new AssociatedItem(){

            @Nonnull
            public String getObjectName() {
                return (String)StringUtils.defaultIfEmpty((CharSequence)AssociatedItemBean.this.name, null);
            }

            @Nullable
            public String getObjectId() {
                return (String)StringUtils.defaultIfEmpty((CharSequence)AssociatedItemBean.this.id, null);
            }

            @Nullable
            public String getParentName() {
                return (String)StringUtils.defaultIfEmpty((CharSequence)AssociatedItemBean.this.parentName, null);
            }

            @Nullable
            public String getParentId() {
                return (String)StringUtils.defaultIfEmpty((CharSequence)AssociatedItemBean.this.parentId, null);
            }

            @Nonnull
            public AssociatedItem.Type getObjectType() {
                return type;
            }
        };
    }

    public static Function<AssociatedItemBean, AssociatedItem> mapToAssociatedItem() {
        return new Function<AssociatedItemBean, AssociatedItem>(){

            public AssociatedItem apply(@Nullable AssociatedItemBean input) {
                return input != null ? input.toAssociatedItem() : null;
            }
        };
    }
}

