/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.applicationrole;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.fugue.Either;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleAdminService;
import com.atlassian.jira.application.ApplicationRoleComparator;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.admin.applicationrole.ApplicationRoleBean;
import com.atlassian.jira.rest.v2.admin.applicationrole.ApplicationRoleBeanConverter;
import com.atlassian.jira.rest.v2.admin.applicationrole.ApplicationRoleHasher;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@WebSudoRequired
@Path(value="applicationrole")
public class ApplicationRoleResource {
    private static final String ETAG = "ETag";
    private final ApplicationRoleAdminService service;
    private final I18nHelper helper;
    private final GroupManager groupManager;
    private final Function<ApplicationRole, ApplicationRoleBean> toBean;
    private final ApplicationRoleHasher appRoleHasher;

    @VisibleForTesting
    ApplicationRoleResource(ApplicationRoleAdminService service, I18nHelper helper, GroupManager groupManager, Function<ApplicationRole, ApplicationRoleBean> toBean, ApplicationRoleHasher appRoleHasher) {
        this.helper = (I18nHelper)Assertions.notNull((String)"helper", (Object)helper);
        this.groupManager = (GroupManager)Assertions.notNull((String)"groupManager", (Object)groupManager);
        this.service = (ApplicationRoleAdminService)Assertions.notNull((String)"service", (Object)service);
        this.toBean = (Function)Assertions.notNull((String)"toBean", toBean);
        this.appRoleHasher = (ApplicationRoleHasher)Assertions.notNull((String)"appRoleHasher", (Object)appRoleHasher);
    }

    @Autowired
    public ApplicationRoleResource(ApplicationRoleAdminService service, I18nHelper helper, GroupManager groupManager, ApplicationRoleBeanConverter roleBeanConverter, @Nonnull FeatureManager featureManager, ApplicationRoleHasher appRoleHasher) {
        this(service, helper, groupManager, roleBeanConverter, appRoleHasher);
    }

    @GET
    @ResponseType(value=List.class, genericTypes={ApplicationRoleBean.class})
    public Response getAll() {
        ServiceOutcome roles = this.service.getRoles();
        if (!roles.isValid()) {
            return ApplicationRoleResource.build(ApplicationRoleResource.responseForIterableOutcome(roles, this.toBean, this.applicationRoleComparator()));
        }
        return ApplicationRoleResource.build(ApplicationRoleResource.responseForIterableOutcome(roles, this.toBean, this.applicationRoleComparator()).header(ETAG, (Object)this.appRoleHasher.getVersionHash((Collection)roles.get())));
    }

    @Path(value="{key}")
    @GET
    @ResponseType(value=ApplicationRoleBean.class)
    public Response get(@PathParam(value="key") String key) {
        return ApplicationRoleResource.build(this.withApplicationRole(key, (Function<ApplicationRole, Response.ResponseBuilder>)((Function)input -> ApplicationRoleResource.ok(this.toBean.apply(input)))));
    }

    @Path(value="{key}")
    @PUT
    @ResponseType(value=ApplicationRoleBean.class)
    public Response put(@PathParam(value="key") String key, @HeaderParam(value="If-Match") String versionHash, ApplicationRoleBean bean) {
        return ApplicationRoleResource.build(this.putRequestParser(key, bean, versionHash));
    }

    @PUT
    @ResponseType(value=List.class, genericTypes={ApplicationRoleBean.class})
    public Response putBulk(List<ApplicationRoleBean> beans, @HeaderParam(value="If-Match") String versionHash) {
        if (versionHash != null && !this.isVersionHashUpToDate(versionHash)) {
            return ApplicationRoleResource.build(ApplicationRoleResource.createVersionError(this.helper.getText("application.role.rest.version.wrong")));
        }
        ArrayList<Object> appRoles = new ArrayList<Object>();
        for (ApplicationRoleBean appRoleBean : beans) {
            Either<Response.ResponseBuilder, ApplicationRole> eitherErrorOrAppRole = this.getApplicationRole(appRoleBean.getKey());
            if (eitherErrorOrAppRole.isLeft()) {
                return ApplicationRoleResource.build((Response.ResponseBuilder)eitherErrorOrAppRole.left().get());
            }
            Either<Response.ResponseBuilder, ApplicationRole> verifiedAppRoleEither = this.verifyApplicationRole((ApplicationRole)eitherErrorOrAppRole.right().get(), appRoleBean);
            if (verifiedAppRoleEither.isLeft()) {
                return ApplicationRoleResource.build((Response.ResponseBuilder)verifiedAppRoleEither.left().get());
            }
            appRoles.add(verifiedAppRoleEither.right().get());
        }
        ServiceOutcome outcome = this.service.setRoles(appRoles);
        if (!outcome.isValid()) {
            return ApplicationRoleResource.build(ApplicationRoleResource.responseForIterableOutcome(outcome, this.toBean, this.applicationRoleComparator()));
        }
        return ApplicationRoleResource.build(ApplicationRoleResource.responseForIterableOutcome(outcome, this.toBean, this.applicationRoleComparator()).header(ETAG, (Object)this.appRoleHasher.getVersionHash((Collection)outcome.get())));
    }

    private Response.ResponseBuilder putRequestParser(String key, ApplicationRoleBean bean, @Nullable String versionHash) {
        if (versionHash != null && !this.isVersionHashUpToDate(versionHash)) {
            return ApplicationRoleResource.createVersionError(this.helper.getText("application.role.rest.version.wrong"));
        }
        return this.withApplicationRole(key, (Function<ApplicationRole, Response.ResponseBuilder>)((Function)role -> {
            Either<Response.ResponseBuilder, ApplicationRole> verifiedAppRole = this.verifyApplicationRole((ApplicationRole)role, bean);
            if (verifiedAppRole.isLeft()) {
                return (Response.ResponseBuilder)verifiedAppRole.left().get();
            }
            ApplicationRole newRole = (ApplicationRole)verifiedAppRole.right().get();
            return ApplicationRoleResource.responseFromOutcome(this.service.setRole(newRole), this.toBean);
        }));
    }

    private Either<Response.ResponseBuilder, ApplicationRole> verifyApplicationRole(ApplicationRole role, ApplicationRoleBean bean) {
        Set defaultObjects;
        Boolean isSelectedByDefault;
        Set<String> groups;
        Set<String> defaultGroups = bean.getDefaultGroups();
        if (defaultGroups == null) {
            defaultGroups = Collections.emptySet();
        }
        if ((groups = bean.getGroups()) == null) {
            groups = Collections.emptySet();
        }
        if ((isSelectedByDefault = bean.isSelectedByDefault()) == null) {
            isSelectedByDefault = false;
        }
        if (groups.contains(null)) {
            return Either.left((Object)ApplicationRoleResource.createGroupError(this.helper.getText("application.role.rest.groups.null")));
        }
        if (defaultGroups.contains(null)) {
            return Either.left((Object)ApplicationRoleResource.createDefaultGroupError(this.helper.getText("application.role.rest.groups.null")));
        }
        Either<String, Set<Group>> errorMessageOrGroup = this.toGroups(groups);
        if (errorMessageOrGroup.isLeft()) {
            return Either.left((Object)ApplicationRoleResource.createGroupError(this.helper.getText("application.role.rest.error.bad.group", (String)errorMessageOrGroup.left().get())));
        }
        Either<String, Set<Group>> errorMessageOrDefaultGroup = this.toGroups(defaultGroups);
        if (errorMessageOrDefaultGroup.isLeft()) {
            return Either.left((Object)ApplicationRoleResource.createDefaultGroupError(this.helper.getText("application.role.rest.error.bad.group", (String)errorMessageOrDefaultGroup.left().get())));
        }
        Set groupObjects = (Set)errorMessageOrGroup.right().get();
        if (!groupObjects.containsAll(defaultObjects = (Set)errorMessageOrDefaultGroup.right().get())) {
            Sets.SetView diff = Sets.difference(defaultGroups, groups);
            String msg = this.helper.getText("application.role.rest.default.groups.invalid", (Object)new Object[]{diff.size(), StringUtils.join((Iterable)diff, (String)", ")});
            return Either.left((Object)ApplicationRoleResource.createDefaultGroupError(msg));
        }
        ApplicationRole newRole = role.withGroups((Iterable)groupObjects, (Iterable)defaultObjects).withSelectedByDefault(isSelectedByDefault.booleanValue());
        return Either.right((Object)newRole);
    }

    private static Response.ResponseBuilder createGroupError(String msg) {
        SimpleErrorCollection collection = new SimpleErrorCollection();
        collection.addError("groups", msg, ErrorCollection.Reason.VALIDATION_FAILED);
        return ApplicationRoleResource.forCollection((com.atlassian.jira.util.ErrorCollection)collection);
    }

    private static Response.ResponseBuilder createDefaultGroupError(String msg) {
        SimpleErrorCollection collection = new SimpleErrorCollection();
        collection.addError("defaultGroups", msg, ErrorCollection.Reason.VALIDATION_FAILED);
        return ApplicationRoleResource.forCollection((com.atlassian.jira.util.ErrorCollection)collection);
    }

    private static Response.ResponseBuilder createVersionError(String msg) {
        SimpleErrorCollection collection = new SimpleErrorCollection();
        collection.addError("versionMismatch", msg, ErrorCollection.Reason.PRECONDITION_FAILED);
        return ApplicationRoleResource.forCollection((com.atlassian.jira.util.ErrorCollection)collection);
    }

    private Response.ResponseBuilder withApplicationRole(String key, Function<ApplicationRole, Response.ResponseBuilder> valid) {
        Either<Response.ResponseBuilder, ApplicationRole> appRoleEither = this.getApplicationRole(key);
        if (appRoleEither.isLeft()) {
            return (Response.ResponseBuilder)appRoleEither.left().get();
        }
        return (Response.ResponseBuilder)valid.apply(appRoleEither.right().get());
    }

    private Either<Response.ResponseBuilder, ApplicationRole> getApplicationRole(String key) {
        if (!ApplicationKey.isValid((String)key)) {
            return Either.left((Object)ApplicationRoleResource.forError(this.helper.getText("application.role.rest.bad.key", key)));
        }
        ServiceOutcome outcome = this.service.getRole(ApplicationKey.valueOf((String)key));
        if (!outcome.isValid()) {
            return Either.left((Object)ApplicationRoleResource.forCollection(outcome.getErrorCollection()));
        }
        return Either.right((Object)outcome.get());
    }

    private static Response.ResponseBuilder ok(Object bean) {
        return Response.ok((Object)bean);
    }

    private static <I, O> Response.ResponseBuilder responseFromOutcome(ServiceOutcome<I> outcome, Function<? super I, ? extends O> transform) {
        if (outcome.isValid()) {
            return ApplicationRoleResource.ok(transform.apply(outcome.get()));
        }
        return ApplicationRoleResource.forCollection(outcome.getErrorCollection());
    }

    private Comparator<ApplicationRole> applicationRoleComparator() {
        Locale userLocale = this.helper.getLocale();
        return new ApplicationRoleComparator(userLocale);
    }

    private static <I, O> Response.ResponseBuilder responseForIterableOutcome(ServiceOutcome<? extends Iterable<I>> outcome, Function<? super I, ? extends O> transform, Comparator<I> sorter) {
        return ApplicationRoleResource.responseFromOutcome(outcome, input -> {
            ArrayList inputList = Lists.newArrayList((Iterable)input);
            inputList.sort(sorter);
            return Lists.newArrayList((Iterable)Iterables.transform((Iterable)inputList, (Function)transform));
        });
    }

    private static Response.ResponseBuilder forError(String message) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of(message));
    }

    private static Response.ResponseBuilder forCollection(com.atlassian.jira.util.ErrorCollection collection) {
        return ApplicationRoleResource.forCollection(collection, ErrorCollection.Reason.SERVER_ERROR);
    }

    private static Response.ResponseBuilder forCollection(com.atlassian.jira.util.ErrorCollection collection, ErrorCollection.Reason defaultReason) {
        if (!collection.hasAnyErrors()) {
            throw new IllegalArgumentException("collection has no errors.");
        }
        if (defaultReason == null) {
            throw new IllegalArgumentException("defaultReason is null");
        }
        ErrorCollection.Reason worstReason = ErrorCollection.Reason.getWorstReason((Collection)collection.getReasons());
        if (worstReason == null) {
            worstReason = defaultReason;
        }
        return Response.status((int)worstReason.getHttpStatusCode()).entity((Object)ErrorCollection.of(collection));
    }

    private Either<String, Set<Group>> toGroups(Iterable<String> groupNames) {
        HashSet groups = Sets.newHashSet();
        for (String groupName : groupNames) {
            Group group = this.groupManager.getGroup(groupName);
            if (group == null) {
                return Either.left((Object)groupName);
            }
            groups.add(group);
        }
        return Either.right(Collections.unmodifiableSet(groups));
    }

    private boolean isVersionHashUpToDate(String requestVersionHash) {
        ServiceOutcome appRoles = this.service.getRoles();
        String serverVersionHash = this.appRoleHasher.getVersionHash((Collection)appRoles.get());
        return requestVersionHash.equals(serverVersionHash);
    }

    private static Response build(Response.ResponseBuilder builder) {
        return builder.cacheControl(CacheControl.never()).build();
    }
}

