/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin;

import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.v2.admin.WorkflowBean;
import com.atlassian.jira.rest.v2.admin.WorkflowTransitionResource;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.rest.annotation.ResponseTypes;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="workflow")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class WorkflowsResource {
    private final WorkflowManager workflowManager;
    private final DateTimeFormatter dateTimeFormatter;
    private final UserManager userManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;
    private final WorkflowTransitionResource.Factory transitionFactory;

    public WorkflowsResource(WorkflowManager workflowManager, DateTimeFormatter dateTimeFormatter, UserManager userManager, JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager, WorkflowTransitionResource.Factory transitionFactory) {
        this.workflowManager = workflowManager;
        this.dateTimeFormatter = dateTimeFormatter;
        this.userManager = userManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.transitionFactory = transitionFactory;
    }

    @GET
    @ResponseTypes(value={@ResponseType(status=200, value=WorkflowBean.class), @ResponseType(status=200, value=List.class, genericTypes={WorkflowBean.class})})
    public Response getAllWorkflows(@QueryParam(value="workflowName") String workflowName) {
        this.verifyUserHasAdminPermission();
        Iterable<WorkflowBean> entity = workflowName == null ? this.actuallyGetAllWorkflows() : this.jiraWorkflowToWorkflowBean(this.workflowManager.getWorkflow(workflowName));
        return Response.ok(entity).cacheControl(CacheControl.never()).build();
    }

    @Path(value="transitions")
    public WorkflowTransitionResource getWorkflowTransitions(@QueryParam(value="workflowName") String workflowName, @QueryParam(value="workflowMode") String workflowMode) {
        this.verifyUserHasAdminPermission();
        return this.transitionFactory.getResource(workflowName, WorkflowTransitionResource.WorkflowMode.getMode(workflowMode));
    }

    private void verifyUserHasAdminPermission() {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        if (!this.permissionManager.hasPermission(0, user)) {
            throw new NotAuthorisedWebException();
        }
    }

    private Iterable<WorkflowBean> actuallyGetAllWorkflows() {
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)this.workflowManager.getWorkflows(), (Function)new Function<JiraWorkflow, WorkflowBean>(){

            public WorkflowBean apply(JiraWorkflow workflow) {
                return WorkflowsResource.this.jiraWorkflowToWorkflowBean(workflow);
            }
        }));
    }

    private WorkflowBean jiraWorkflowToWorkflowBean(JiraWorkflow jiraWorkflow) {
        String name = jiraWorkflow.getName();
        String description = jiraWorkflow.getDescription();
        int steps = jiraWorkflow.getDescriptor().getSteps().size();
        boolean isDefault = jiraWorkflow.isDefault();
        String updateDate = jiraWorkflow.getUpdatedDate() != null ? this.dateTimeFormatter.forLoggedInUser().format(jiraWorkflow.getUpdatedDate()) : null;
        ApplicationUser updateAuthor = jiraWorkflow.getUpdateAuthor();
        String updateAuthorName = this.userManager.isUserExisting(updateAuthor) ? updateAuthor.getDisplayName() : null;
        return new WorkflowBean(name, description, updateDate, updateAuthorName, steps, isDefault);
    }
}

