/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.projectcategories;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.v1.model.ValueEntry;
import com.atlassian.jira.rest.v1.model.errors.ErrorCollection;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.CorsAllowed;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/browse-project")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@CorsAllowed
public class BrowseProjectsResource {
    private static final Logger log = LoggerFactory.getLogger(BrowseProjectsResource.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final VelocityRequestContextFactory contextFactory;
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private static final String ALL = "all";
    private static final String NONE = "none";
    private static final String RECENT = "recent";

    public BrowseProjectsResource(JiraAuthenticationContext jiraAuthenticationContext, VelocityRequestContextFactory contextFactory, ProjectManager projectManager, PermissionManager permissionManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.contextFactory = contextFactory;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
    }

    @GET
    @Path(value="/category/active")
    public Response getCurrent() {
        String current = (String)this.getSession().getAttribute("jira.browse.projects.current.tab");
        if (this.validateCategory(current).hasAnyErrors()) {
            current = null;
        }
        return Response.ok((Object)new ValueEntry(current, "value")).cacheControl(CacheControl.NO_CACHE).build();
    }

    @POST
    @Path(value="/category/active")
    public Response setCurrent(ActiveCategory activeCategory) {
        if (activeCategory == null) {
            ErrorCollection activeCategoryEmpty = ErrorCollection.Builder.newBuilder().addError("current", "project.category.active.blank", new String[0]).build();
            return Response.status((int)400).entity((Object)activeCategoryEmpty).type(MediaType.APPLICATION_JSON_TYPE).cacheControl(CacheControl.NO_CACHE).build();
        }
        ErrorCollection errorCollection = this.validateCategory(activeCategory.getCurrent());
        if (errorCollection.hasAnyErrors()) {
            return Response.status((int)400).entity((Object)errorCollection).type(MediaType.APPLICATION_JSON_TYPE).cacheControl(CacheControl.NO_CACHE).build();
        }
        this.getSession().setAttribute("jira.browse.projects.current.tab", (Object)activeCategory.getCurrent());
        return Response.ok().cacheControl(CacheControl.NO_CACHE).build();
    }

    @POST
    @Path(value="/project-type/active")
    public Response setSelectedProjectTypeKey(String currentProjectType) {
        this.getSession().setAttribute("jira.browse.projects.current.project.type", (Object)currentProjectType);
        return Response.ok().cacheControl(CacheControl.NO_CACHE).build();
    }

    private VelocityRequestSession getSession() {
        VelocityRequestContext requestContext = this.contextFactory.getJiraVelocityRequestContext();
        return requestContext.getSession();
    }

    private ErrorCollection validateCategory(String current) {
        ProjectCategory category;
        ErrorCollection.Builder errorBuilder = ErrorCollection.Builder.newBuilder();
        if (StringUtils.isBlank((String)current)) {
            errorBuilder.addError("current", "project.category.active.blank", new String[0]);
        }
        if (!(ALL.equals(current) || NONE.equals(current) || RECENT.equals(current) || (category = this.getProjectCategory(current)) != null && this.canSeeCategory(this.jiraAuthenticationContext.getUser(), category))) {
            errorBuilder.addError("current", "project.category.active.no.permission.or.not.exist", current);
        }
        return errorBuilder.build();
    }

    private ProjectCategory getProjectCategory(String categoryIdStr) {
        try {
            long categoryId = Long.parseLong(categoryIdStr);
            return this.projectManager.getProjectCategoryObject(Long.valueOf(categoryId));
        }
        catch (DataAccessException dae) {
            log.warn("Error thrown trying to retrieve category", (Throwable)dae);
        }
        catch (NumberFormatException nfe) {
            log.warn("Category was not a number - " + categoryIdStr, (Throwable)nfe);
        }
        return null;
    }

    private boolean canSeeCategory(ApplicationUser user, ProjectCategory category) {
        Collection projects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, user, category);
        return projects != null && !projects.isEmpty();
    }

    @XmlRootElement
    public static class ActiveCategory {
        @XmlElement
        private String current;

        private ActiveCategory() {
        }

        public ActiveCategory(String current) {
            this.current = current;
        }

        public String getCurrent() {
            return this.current;
        }
    }
}

