/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.images;

import com.atlassian.jira.image.separator.HeaderSeparatorService;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.CorsAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="header-separator")
@AnonymousAllowed
@Produces(value={"image/png"})
@CorsAllowed
public class HeaderSeparatorResouce {
    private final HeaderSeparatorService headerSeparatorService;

    public HeaderSeparatorResouce(HeaderSeparatorService headerSeparatorService) {
        this.headerSeparatorService = headerSeparatorService;
    }

    @GET
    public Response getImage(@QueryParam(value="color") String colorHex, @QueryParam(value="bgcolor") String backgroundColorHex) {
        byte[] separator = this.headerSeparatorService.getSeparator(colorHex, backgroundColorHex);
        return Response.ok((Object)separator).cacheControl(CacheControl.CACHE_FOREVER).build();
    }

    @GET
    @Path(value="/{hash}/{color}/{bgcolor}/img.png")
    public Response getImageFromPath(@PathParam(value="color") String colorHex, @PathParam(value="bgcolor") String backgroundColorHex) {
        return this.getImage(colorHex, backgroundColorHex);
    }
}

