/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.dashboards;

import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.favourites.FavouritesManager;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.rest.v1.favourites.FavouriteResource;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.CorsAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="dashboards")
@AnonymousAllowed
@Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
@Produces(value={"application/json", "application/xml"})
@CorsAllowed
public class DashboardResource {
    private final JiraAuthenticationContext authenticationContext;
    private final FavouritesService favouritesService;
    private final FavouritesManager favouritesManager;
    private final SharedEntityAccessor.Factory sharedEntityAccessorFactory;

    public DashboardResource(JiraAuthenticationContext authenticationContext, FavouritesService favouritesService, FavouritesManager favouritesManager, SharedEntityAccessor.Factory sharedEntityAccessorFactory) {
        Assertions.notNull((String)"authContext", (Object)authenticationContext);
        Assertions.notNull((String)"favService", (Object)favouritesService);
        Assertions.notNull((String)"favouritesManager", (Object)favouritesManager);
        Assertions.notNull((String)"sharedEntityAccessorFactory", (Object)sharedEntityAccessorFactory);
        this.authenticationContext = authenticationContext;
        this.favouritesService = favouritesService;
        this.favouritesManager = favouritesManager;
        this.sharedEntityAccessorFactory = sharedEntityAccessorFactory;
    }

    @Path(value="{entityId}/favourite")
    public FavouriteResource getFavouriteResource(@PathParam(value="entityId") Long entityId) {
        return new FavouriteResource(this.authenticationContext, this.favouritesService, this.favouritesManager, this.sharedEntityAccessorFactory, PortalPage.ENTITY_TYPE, entityId);
    }
}

