/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v1;

import com.atlassian.fugue.Option;
import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.rest.exception.ForbiddenWebException;
import com.atlassian.jira.rest.internal.v1.DarkFeaturePropertyBean;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="featureFlag")
@Produces(value={"application/json"})
public class FeatureFlagResource {
    private final FeatureManager featureManager;

    public FeatureFlagResource(FeatureManager featureManager) {
        this.featureManager = (FeatureManager)Assertions.notNull((String)"featureManager", (Object)featureManager);
    }

    @GET
    public Response get() {
        if (!this.featureManager.hasSiteEditPermission()) {
            throw new ForbiddenWebException();
        }
        Map<String, DarkFeaturePropertyBean> features = this.getFeatureFlags();
        return Response.ok(features).cacheControl(CacheControl.NO_CACHE).build();
    }

    @GET
    @Path(value="/{featureKey}")
    public Response get(@PathParam(value="featureKey") String featureKey) {
        if (!this.featureManager.hasSiteEditPermission()) {
            throw new ForbiddenWebException();
        }
        if (StringUtils.isNotBlank((String)featureKey)) {
            Option key = this.featureManager.getFeatureFlag(featureKey);
            if (key.isDefined()) {
                boolean enabled = this.featureManager.isEnabled((FeatureFlag)key.get());
                return Response.ok((Object)new DarkFeaturePropertyBean(enabled)).cacheControl(CacheControl.NO_CACHE).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.NO_CACHE).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.NO_CACHE).build();
    }

    @PUT
    @Path(value="/{featureKey}")
    @Consumes(value={"application/json"})
    public Response put(@PathParam(value="featureKey") String featureKey, DarkFeaturePropertyBean darkFeaturePropertyBean) {
        if (!this.featureManager.hasSiteEditPermission()) {
            throw new ForbiddenWebException();
        }
        if (StringUtils.isNotBlank((String)featureKey)) {
            Option key = this.featureManager.getFeatureFlag(featureKey);
            if (key.isDefined()) {
                this.setFeatureFlag((FeatureFlag)key.get(), darkFeaturePropertyBean.isEnabled());
                return Response.noContent().cacheControl(CacheControl.NO_CACHE).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.NO_CACHE).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(CacheControl.NO_CACHE).build();
    }

    private void setFeatureFlag(FeatureFlag featureFlag, boolean enabled) {
        if (featureFlag.isOnByDefault()) {
            this.setSiteFeature(featureFlag.disabledFeatureKey(), !enabled);
        } else {
            this.setSiteFeature(featureFlag.enabledFeatureKey(), enabled);
        }
    }

    private void setSiteFeature(String darkFeatureKey, boolean enabled) {
        if (enabled) {
            this.featureManager.enableSiteDarkFeature(darkFeatureKey);
        } else {
            this.featureManager.disableSiteDarkFeature(darkFeatureKey);
        }
    }

    private Map<String, DarkFeaturePropertyBean> getFeatureFlags() {
        Set featureFlags = this.featureManager.getRegisteredFlags();
        HashMap result = Maps.newHashMap();
        for (FeatureFlag featureFlag : featureFlags) {
            result.put(featureFlag.featureKey(), new DarkFeaturePropertyBean(this.featureManager.isEnabled(featureFlag)));
        }
        return result;
    }
}

