/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.mapper;

import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapper;
import com.atlassian.crowd.directory.ldap.mapper.ContextMapperWithRequiredAttributes;
import com.atlassian.crowd.directory.ldap.util.DirectoryAttributeRetriever;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.springframework.ldap.UncategorizedLdapException;
import org.springframework.ldap.core.DirContextAdapter;

public class ExternalIdContextMapper
implements ContextMapperWithRequiredAttributes<String> {
    private final LDAPPropertiesMapper ldapPropertiesMapper;

    public ExternalIdContextMapper(LDAPPropertiesMapper ldapPropertiesMapper) {
        this.ldapPropertiesMapper = ldapPropertiesMapper;
    }

    @Override
    public String mapFromContext(Object ctx) {
        try {
            DirContextAdapter context = (DirContextAdapter)ctx;
            return DirectoryAttributeRetriever.getValueFromExternalIdAttribute(this.ldapPropertiesMapper.getExternalIdAttribute(), context.getAttributes());
        }
        catch (UncategorizedLdapException e) {
            throw new RuntimeException("Could not retrieve externalId from object: " + ctx, e);
        }
    }

    @Override
    public Set<String> getRequiredLdapAttributes() {
        return ImmutableSet.of((Object)this.ldapPropertiesMapper.getExternalIdAttribute());
    }
}

