/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.software.monitor;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.plugins.software.monitor.ApplicationPluginsEnablerJobRunner;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.annotations.VisibleForTesting;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationPluginsEnablerJobScheduler {
    private static final int JOB_SCHEDULE_DELAY_IN_MINS = 1;
    private static final JobId APPLICATION_PLUGINS_ENABLER_JOB_ID = JobId.of((String)ApplicationPluginsEnablerJobRunner.class.getName());
    private static final long INTERVAL_IN_MILLIS = 300000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationPluginsEnablerJobScheduler.class);
    @VisibleForTesting
    static final String SOFTWARE_APPLICATION_PLUGIN_KEY = "com.atlassian.jira.jira-software-application";
    private final EventPublisher eventPublisher;
    private final SchedulerService schedulerService;

    @Autowired
    public ApplicationPluginsEnablerJobScheduler(@ComponentImport EventPublisher eventPublisher, @ComponentImport SchedulerService schedulerService) {
        this.eventPublisher = eventPublisher;
        this.schedulerService = schedulerService;
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (this.shouldScheduleApplicationPluginsEnablerJob(event.getPlugin())) {
            LOGGER.debug("Scheduling a recurring local job to ensure that all software application plugins are enabled.");
            try {
                this.schedulerService.scheduleJob(ApplicationPluginsEnablerJobScheduler.getJobId(), JobConfig.forJobRunnerKey((JobRunnerKey)ApplicationPluginsEnablerJobRunner.getJobRunnerKey()).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)300000L, (Date)DateTime.now().plusMinutes(1).toDate())));
                LOGGER.debug("Scheduled a recurring local job to ensure that all software application plugins are enabled.");
            }
            catch (SchedulerServiceException e) {
                LOGGER.error("Failed to schedule a recurring local job to ensure that all software application plugins are enabled.", (Throwable)e);
            }
        }
    }

    private boolean shouldScheduleApplicationPluginsEnablerJob(Plugin enabledPlugin) {
        return SOFTWARE_APPLICATION_PLUGIN_KEY.equals(enabledPlugin.getKey());
    }

    @PostConstruct
    public void register() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void unregister() {
        this.eventPublisher.unregister((Object)this);
    }

    @VisibleForTesting
    static JobId getJobId() {
        return APPLICATION_PLUGINS_ENABLER_JOB_ID;
    }
}

