/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.software.monitor;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationPlugin;
import com.atlassian.application.host.plugin.PluginApplicationMetaData;
import com.atlassian.application.host.plugin.PluginApplicationMetaDataManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugins.software.monitor.EnabledSoftwarePluginEvent;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationPluginsEnablerJobRunner
implements JobRunner {
    @VisibleForTesting
    static final ApplicationKey SOFTWARE_APPLICATION_KEY = ApplicationKey.valueOf((String)"jira-software");
    private static final JobRunnerKey APPLICATION_PLUGINS_ENABLER_JOB_RUNNER_KEY = JobRunnerKey.of((String)ApplicationPluginsEnablerJobRunner.class.getName());
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationPluginsEnablerJobRunner.class);
    private static final String SOFTWARE_MONITOR_PLUGIN_KEY = "com.atlassian.jira.plugins.jira-software-monitor-plugin";
    private final PluginAccessor pluginAccessor;
    private final PluginApplicationMetaDataManager pluginApplicationMetaDataManager;
    private final PluginController pluginController;
    private final SchedulerService schedulerService;
    private EventPublisher eventPublisher;

    @Autowired
    public ApplicationPluginsEnablerJobRunner(@ComponentImport PluginAccessor pluginAccessor, @ComponentImport PluginController pluginController, @ComponentImport SchedulerService schedulerService, @ComponentImport EventPublisher eventPublisher) {
        this(pluginAccessor, (PluginApplicationMetaDataManager)ComponentAccessor.getComponent(PluginApplicationMetaDataManager.class), pluginController, schedulerService, eventPublisher);
    }

    @VisibleForTesting
    ApplicationPluginsEnablerJobRunner(PluginAccessor pluginAccessor, PluginApplicationMetaDataManager pluginApplicationMetaDataManager, PluginController pluginController, SchedulerService schedulerService, EventPublisher eventPublisher) {
        this.pluginAccessor = pluginAccessor;
        this.pluginApplicationMetaDataManager = pluginApplicationMetaDataManager;
        this.pluginController = pluginController;
        this.schedulerService = schedulerService;
        this.eventPublisher = eventPublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        try {
            JobRunnerResponse response;
            PluginApplicationMetaData pluginApplicationMetaData = (PluginApplicationMetaData)this.pluginApplicationMetaDataManager.getApplication(SOFTWARE_APPLICATION_KEY).getOrNull();
            if (pluginApplicationMetaData == null) {
                LOGGER.warn("Unable to obtain PluginApplicationMetaData for JIRA Software. Not attempting to enable anything.");
                response = JobRunnerResponse.failed((String)"Unable to obtain PluginApplicationMetaData for JIRA Software. Not attempting to enable anything.");
            } else {
                Object[] disabledPluginKeys = this.findDisabledApplicationPlugins(pluginApplicationMetaData);
                if (disabledPluginKeys.length == 0) {
                    LOGGER.debug("Nothing to enable. Found no disabled application plugins for JIRA Software.");
                } else {
                    LOGGER.info("Attempting to enable the following application plugins: " + Arrays.toString(disabledPluginKeys));
                    for (Object disabledPluginKey : disabledPluginKeys) {
                        this.eventPublisher.publish((Object)new EnabledSoftwarePluginEvent((String)disabledPluginKey));
                    }
                    this.pluginController.enablePlugins((String[])disabledPluginKeys);
                }
                response = JobRunnerResponse.success();
            }
            JobRunnerResponse jobRunnerResponse = response;
            return jobRunnerResponse;
        }
        finally {
            this.schedulerService.unscheduleJob(request.getJobId());
        }
    }

    private String[] findDisabledApplicationPlugins(PluginApplicationMetaData pluginApplicationMetaData) {
        return (String[])Lists.newArrayList((Iterable)pluginApplicationMetaData.getApplicationPlugins()).stream().map(ApplicationPlugin::getPluginKey).filter(pluginKey -> !SOFTWARE_MONITOR_PLUGIN_KEY.equals(pluginKey)).filter(pluginKey -> !this.pluginAccessor.isPluginEnabled(pluginKey)).toArray(String[]::new);
    }

    public static JobRunnerKey getJobRunnerKey() {
        return APPLICATION_PLUGINS_ENABLER_JOB_RUNNER_KEY;
    }
}

