/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.pulp.wrm;

import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.upgrade.UpgradeVersionHistoryItem;
import com.atlassian.jira.upgrade.UpgradeVersionHistoryReader;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.HttpServletVariables;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.servlet.http.HttpSession;

@ParametersAreNonnullByDefault
public class UpgradeStatusWrmDataProvider
implements WebResourceDataProvider {
    @VisibleForTesting
    static final String UPDATE_KEY = "update";
    private final BuildUtilsInfo buildUtilsInfo;
    private final DateTimeFormatter dateTimeFormatter;
    private final HttpServletVariables httpServletVariables;
    private final UpgradeVersionHistoryReader upgradeVersionHistoryReader;

    @Inject
    public UpgradeStatusWrmDataProvider(@ComponentImport BuildUtilsInfo buildUtilsInfo, @ComponentImport DateTimeFormatter dateTimeFormatter, @ComponentImport HttpServletVariables httpServletVariables, @ComponentImport UpgradeVersionHistoryReader upgradeVersionHistoryReader) {
        this.buildUtilsInfo = Objects.requireNonNull(buildUtilsInfo);
        this.dateTimeFormatter = Objects.requireNonNull(dateTimeFormatter.forLoggedInUser());
        this.httpServletVariables = Objects.requireNonNull(httpServletVariables);
        this.upgradeVersionHistoryReader = Objects.requireNonNull(upgradeVersionHistoryReader);
    }

    @Nonnull
    public Jsonable get() {
        return writer -> {
            try {
                this.getUpgradeStatus().write(writer);
            }
            catch (JSONException e) {
                throw new Jsonable.JsonMappingException((Throwable)e);
            }
        };
    }

    private JSONObject getUpgradeStatus() throws JSONException {
        JSONObject upgradeStatus = new JSONObject();
        upgradeStatus.putOpt(UPDATE_KEY, this.getUpdateDateJson().orElse(null));
        upgradeStatus.put("version", (Object)this.buildUtilsInfo.getVersion());
        upgradeStatus.put("isRedirected", this.checkRedirected());
        return upgradeStatus;
    }

    private boolean checkRedirected() {
        HttpSession httpSession = this.httpServletVariables.getHttpSession();
        Object redirected = httpSession.getAttribute("redirected-to-pulp");
        httpSession.removeAttribute("redirected-to-pulp");
        return Boolean.TRUE.equals(redirected);
    }

    private Optional<JSONObject> getUpdateDateJson() {
        return this.upgradeVersionHistoryReader.getLatestUpgrade().map(UpgradeVersionHistoryItem::getTimePerformed).map(upgradeTimestamp -> new JSONObject((Map)ImmutableMap.of((Object)"day", (Object)this.getDateComponent((Date)upgradeTimestamp, DateTimeStyle.DATE), (Object)"time", (Object)this.getDateComponent((Date)upgradeTimestamp, DateTimeStyle.TIME))));
    }

    @Nonnull
    private String getDateComponent(Date completeDate, DateTimeStyle dateTimeStyle) {
        return this.dateTimeFormatter.withStyle(dateTimeStyle).format(completeDate);
    }
}

