/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.pulp.wrm;

import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.pulp.wrm.IsUserInstalledPlugin;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.predicate.PluginPredicate;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;

@ParametersAreNonnullByDefault
public class PluginStatusWrmDataProvider
implements WebResourceDataProvider {
    @VisibleForTesting
    static final String DISABLED_USER_PLUGINS = "disabledPlugins";
    @VisibleForTesting
    static final String KB_URL_JSON_KEY = "kbUrl";
    @VisibleForTesting
    static final String PLUGINS_HELP_URL_KEY = "plugins";
    private final HelpUrls helpUrls;
    private final IsUserInstalledPlugin isUserInstalledPlugin;
    private final PluginAccessor pluginAccessor;

    @Inject
    public PluginStatusWrmDataProvider(@ComponentImport HelpUrls helpUrls, @ComponentImport PluginAccessor pluginAccessor, IsUserInstalledPlugin isUserInstalledPlugin) {
        this.helpUrls = Objects.requireNonNull(helpUrls);
        this.isUserInstalledPlugin = Objects.requireNonNull(isUserInstalledPlugin);
        this.pluginAccessor = Objects.requireNonNull(pluginAccessor);
    }

    @Nonnull
    public Jsonable get() {
        return writer -> {
            try {
                this.getBodyContentJsonObject().write(writer);
            }
            catch (JSONException e) {
                throw new Jsonable.JsonMappingException((Throwable)e);
            }
        };
    }

    private JSONObject getBodyContentJsonObject() {
        Collection userInstalledPlugins = this.pluginAccessor.getPlugins((PluginPredicate)this.isUserInstalledPlugin);
        if (userInstalledPlugins.isEmpty()) {
            return new JSONObject();
        }
        return this.getPluginStatus(userInstalledPlugins);
    }

    private JSONObject getPluginStatus(Collection<Plugin> userInstalledPlugins) {
        long disabledUserPlugins = userInstalledPlugins.stream().filter(this::isNotEnabled).count();
        JSONObject pluginStatus = new JSONObject();
        try {
            pluginStatus.put(DISABLED_USER_PLUGINS, disabledUserPlugins);
            pluginStatus.put(KB_URL_JSON_KEY, (Object)this.helpUrls.getUrl(PLUGINS_HELP_URL_KEY).getUrl());
            return pluginStatus;
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean isNotEnabled(Plugin plugin) {
        return plugin.getPluginState() != PluginState.ENABLED;
    }
}

