/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.pulp.wrm;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;

@ParametersAreNonnullByDefault
public class NewsWrmDataProvider
implements WebResourceDataProvider {
    @VisibleForTesting
    static final String I18N_NEWS_HEADLINE_KEY = "pulp.rows.news.headline";
    @VisibleForTesting
    static final String I18N_NEWS_DESCRIPTION_KEY = "pulp.rows.news.description";
    @VisibleForTesting
    static final String I18N_NEWS_ITEM_KEY_PREFIX = "pulp.rows.news.item.";
    @VisibleForTesting
    static final String I18N_NEWS_ITEM_HEADLINE_SUFFIX = ".headline";
    @VisibleForTesting
    static final String I18N_NEWS_ITEM_TEXT_SUFFIX = ".text";
    @VisibleForTesting
    static final String I18N_NEWS_ITEM_TYPE_SUFFIX = ".type";
    @VisibleForTesting
    static final String I18N_NEWS_ITEM_ARTICLE_LINK_SUFFIX = ".article.link";
    @VisibleForTesting
    static final String I18N_NEWS_ITEM_ARTICLE_LABEL_SUFFIX = ".article.label";
    private static final String NEWS_TYPE_JSON_KEY = "type";
    private static final Map<ApplicationKey, String> APPLICATION_NEWS_TYPES = ImmutableMap.of((Object)ApplicationKey.valueOf((String)"jira-core"), (Object)"", (Object)ApplicationKey.valueOf((String)"jira-servicedesk"), (Object)"jsd", (Object)ApplicationKey.valueOf((String)"jira-software"), (Object)"jsw");
    private final ApplicationManager applicationManager;
    private final I18nHelper i18nHelper;

    @Inject
    public NewsWrmDataProvider(@ComponentImport ApplicationManager applicationManager, @ComponentImport I18nHelper i18nHelper) {
        this.applicationManager = Objects.requireNonNull(applicationManager);
        this.i18nHelper = Objects.requireNonNull(i18nHelper);
    }

    @Nonnull
    public Jsonable get() {
        return writer -> {
            try {
                this.getNewsJson().write(writer);
            }
            catch (JSONException e) {
                throw new Jsonable.JsonMappingException((Throwable)e);
            }
        };
    }

    private boolean hasNews() {
        return this.i18nValueExists(I18N_NEWS_HEADLINE_KEY) && this.i18nValueExists(I18N_NEWS_DESCRIPTION_KEY);
    }

    private boolean i18nValueExists(String key) {
        return this.i18nHelper.isKeyDefined(key) && StringUtils.isNotBlank((String)this.i18nHelper.getText(key));
    }

    private JSONObject getNewsJson() throws JSONException {
        Set items = this.i18nHelper.getKeysForPrefix(I18N_NEWS_ITEM_KEY_PREFIX);
        if (!this.hasNews() || items == null || items.isEmpty()) {
            return new JSONObject();
        }
        JSONObject newsDetails = new JSONObject();
        JSONArray newsItems = this.filterNewsItems(items);
        if (newsItems.length() == 0) {
            return new JSONObject();
        }
        newsDetails.putOpt("items", (Object)newsItems);
        return newsDetails;
    }

    private JSONArray filterNewsItems(Set<String> items) {
        int indexOfItemNumber = I18N_NEWS_ITEM_KEY_PREFIX.length();
        return new JSONArray((Collection)items.stream().filter(key -> key.length() > indexOfItemNumber).collect(Collectors.groupingBy(key -> Character.valueOf(key.charAt(indexOfItemNumber)), Collectors.toSet())).entrySet().stream().map(e -> this.createNewsItem(((Character)e.getKey()).charValue(), (Set)e.getValue())).filter(Optional::isPresent).map(Optional::get).filter(this::matchesInstalledApplications).collect(Collectors.toList()));
    }

    private boolean matchesInstalledApplications(JSONObject newsItem) {
        String newsType = newsItem.optString(NEWS_TYPE_JSON_KEY);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)newsType)) {
            return true;
        }
        Set validNewsTypes = StreamSupport.stream(this.applicationManager.getApplications().spliterator(), false).map(application -> APPLICATION_NEWS_TYPES.getOrDefault(application.getKey(), "")).collect(Collectors.toSet());
        return validNewsTypes.contains(newsType);
    }

    private Optional<JSONObject> createNewsItem(char newsItemNumber, Set<String> newsItemKeys) {
        if (!this.areNewsItemKeysSufficient(newsItemKeys)) {
            return Optional.empty();
        }
        try {
            JSONObject newsItem = new JSONObject();
            newsItem.put("headline", (Object)this.getI18n(newsItemNumber, I18N_NEWS_ITEM_HEADLINE_SUFFIX));
            newsItem.put("text", (Object)this.getI18n(newsItemNumber, I18N_NEWS_ITEM_TEXT_SUFFIX));
            newsItem.putOpt(NEWS_TYPE_JSON_KEY, (Object)this.getI18n(newsItemNumber, I18N_NEWS_ITEM_TYPE_SUFFIX));
            newsItem.putOpt("article", (Object)this.createArticle(newsItemNumber));
            return Optional.of(newsItem);
        }
        catch (JSONException e) {
            return Optional.empty();
        }
    }

    private JSONObject createArticle(char newsItemNumber) throws JSONException {
        JSONObject article = new JSONObject();
        article.putOpt("link", (Object)this.getI18n(newsItemNumber, I18N_NEWS_ITEM_ARTICLE_LINK_SUFFIX));
        article.putOpt("label", (Object)this.getI18n(newsItemNumber, I18N_NEWS_ITEM_ARTICLE_LABEL_SUFFIX));
        return article.length() == 2 ? article : null;
    }

    private String getI18n(char newsItemNumber, String inSuffix) {
        String key = this.getI18NKeyForNewsItem(newsItemNumber, inSuffix);
        if (this.i18nHelper.isKeyDefined(key)) {
            return this.i18nHelper.getText(key);
        }
        return null;
    }

    private boolean areNewsItemKeysSufficient(Collection<String> keys) {
        return keys.stream().anyMatch(s -> s.endsWith(I18N_NEWS_ITEM_HEADLINE_SUFFIX)) && keys.stream().anyMatch(s -> s.endsWith(I18N_NEWS_ITEM_TEXT_SUFFIX));
    }

    private String getI18NKeyForNewsItem(char newsItemNumber, String suffix) {
        return I18N_NEWS_ITEM_KEY_PREFIX + newsItemNumber + suffix;
    }
}

