/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.pulp.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.pulp.PulpRedirectDao;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;

@Named
@ParametersAreNonnullByDefault
public class PulpRedirectDaoImpl
implements PulpRedirectDao {
    private final ApplicationProperties applicationProperties;
    private final UserIdSerializer userIdSerializer;

    @Inject
    public PulpRedirectDaoImpl(@ComponentImport ApplicationProperties applicationProperties) {
        this(applicationProperties, new UserIdSerializer());
    }

    @VisibleForTesting
    PulpRedirectDaoImpl(ApplicationProperties applicationProperties, UserIdSerializer userIdSerializer) {
        this.applicationProperties = Objects.requireNonNull(applicationProperties);
        this.userIdSerializer = Objects.requireNonNull(userIdSerializer);
    }

    @Override
    public boolean addRedirect(ApplicationUser user, int jiraBuildNumber) {
        String propertyKey = PulpRedirectDaoImpl.getApplicationPropertyKey(jiraBuildNumber);
        Collection<Long> pulpViewerIds = this.userIdSerializer.parseUserIds(this.applicationProperties.getString(propertyKey));
        boolean addedUserId = pulpViewerIds.add(user.getId());
        if (addedUserId) {
            String propertyValue = this.userIdSerializer.formatUserIds(pulpViewerIds);
            this.applicationProperties.setString(propertyKey, propertyValue);
        }
        return addedUserId;
    }

    @Override
    public int getRedirectCount(int jiraBuildNumber) {
        String propertyKey = PulpRedirectDaoImpl.getApplicationPropertyKey(jiraBuildNumber);
        Collection<Long> pulpViewerIds = this.userIdSerializer.parseUserIds(this.applicationProperties.getString(propertyKey));
        return pulpViewerIds.size();
    }

    @VisibleForTesting
    static String getApplicationPropertyKey(int jiraBuildNumber) {
        return "com.atlassian.jira.pulp.viewers-" + jiraBuildNumber;
    }

    static class UserIdSerializer {
        private static final String USER_ID_DELIMITER = ";";

        UserIdSerializer() {
        }

        @Nonnull
        String formatUserIds(Collection<Long> userIds) {
            return userIds.stream().map(Object::toString).collect(Collectors.joining(USER_ID_DELIMITER));
        }

        @Nonnull
        Collection<Long> parseUserIds(@Nullable String applicationProperty) {
            return Arrays.stream(StringUtils.split((String)StringUtils.trimToEmpty((String)applicationProperty), (String)USER_ID_DELIMITER)).map(Long::parseLong).collect(Collectors.toCollection(HashSet::new));
        }
    }
}

