/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.pulp;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.dmz.api.web.landingpage.LandingPageRegistrar;
import com.atlassian.jira.dmz.api.web.redirect.PageRedirect;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.pulp.PulpFeature;
import com.atlassian.jira.pulp.PulpRedirectDao;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.upgrade.UpgradeVersionHistoryItem;
import com.atlassian.jira.upgrade.UpgradeVersionHistoryReader;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.web.HttpServletVariables;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.google.common.annotations.VisibleForTesting;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Named;

@Named
@ExportAsService(value={LifecycleAware.class})
@ParametersAreNonnullByDefault
public class PulpRedirectManager
implements LifecycleAware {
    @VisibleForTesting
    static final String PULP_URL = "/secure/PostUpgradeLandingPage.jspa";
    @VisibleForTesting
    static final int REDIRECT_PRIORITY = 5;
    @VisibleForTesting
    static final int REDIRECT_LIMIT = 10;
    @VisibleForTesting
    static final long PULP_TIME_LIMIT_IN_DAYS = 14L;
    public static final String REDIRECTION_FLAG = "redirected-to-pulp";
    private final ApplicationProperties applicationProperties;
    private final BuildUtilsInfo buildUtilsInfo;
    private final EventPublisher eventPublisher;
    private final GlobalPermissionManager globalPermissionManager;
    private final HttpServletVariables httpServletVariables;
    private final JiraProperties jiraProperties;
    private final LandingPageRegistrar landingPageRegistrar;
    private final PageRedirect pageRedirect;
    private final PulpFeature pulpFeature;
    private final PulpRedirectDao pulpRedirectDao;
    private final UpgradeVersionHistoryReader upgradeVersionHistoryReader;

    @Inject
    public PulpRedirectManager(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport BuildUtilsInfo buildUtilsInfo, @ComponentImport EventPublisher eventPublisher, @ComponentImport GlobalPermissionManager globalPermissionManager, @ComponentImport HttpServletVariables httpServletVariables, @ComponentImport JiraProperties jiraProperties, @ComponentImport LandingPageRegistrar landingPageRegistrar, PulpFeature pulpFeature, PulpRedirectDao pulpRedirectDao, UpgradeVersionHistoryReader upgradeVersionHistoryReader) {
        this.applicationProperties = Objects.requireNonNull(applicationProperties);
        this.buildUtilsInfo = Objects.requireNonNull(buildUtilsInfo);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.globalPermissionManager = Objects.requireNonNull(globalPermissionManager);
        this.httpServletVariables = Objects.requireNonNull(httpServletVariables);
        this.jiraProperties = Objects.requireNonNull(jiraProperties);
        this.landingPageRegistrar = Objects.requireNonNull(landingPageRegistrar);
        this.pageRedirect = this.getPageRedirect();
        this.pulpFeature = Objects.requireNonNull(pulpFeature);
        this.pulpRedirectDao = Objects.requireNonNull(pulpRedirectDao);
        this.upgradeVersionHistoryReader = Objects.requireNonNull(upgradeVersionHistoryReader);
    }

    @Nonnull
    @VisibleForTesting
    PageRedirect getPageRedirect() {
        return user -> Optional.ofNullable(user).filter(u -> this.isOfficialRelease()).filter(this::isAdministrator).filter(u -> !this.jiraProperties.isDevMode()).filter(u -> this.isUpgradedInstance()).filter(u -> !this.isRedirectLimitReached()).filter(u -> this.lastUpgradeIsWithinTimeLimit()).filter(this::recordAsRedirectedToPulpForThisVersionOfJira).map(u -> {
            this.sendRedirectedEvent();
            return u;
        }).map(u -> {
            this.storeRedirectionInSession();
            return u;
        }).map(u -> PULP_URL);
    }

    private boolean isUpgradedInstance() {
        return Optional.ofNullable(this.applicationProperties.getString("jira.initial.build.number")).map(Integer::parseInt).map(initialBuildNumber -> this.buildUtilsInfo.getApplicationBuildNumber() > initialBuildNumber).orElse(true);
    }

    private void storeRedirectionInSession() {
        this.httpServletVariables.getHttpSession().setAttribute(REDIRECTION_FLAG, (Object)true);
    }

    private void sendRedirectedEvent() {
        this.eventPublisher.publish((Object)new RedirectedToPulpEvent(this.getTotalRedirects()));
    }

    private boolean lastUpgradeIsWithinTimeLimit() {
        return this.upgradeVersionHistoryReader.getLatestUpgrade().map(UpgradeVersionHistoryItem::getTimePerformed).filter(this::currentTimeIsWithinPostUpgradeTimeLimit).isPresent();
    }

    private boolean currentTimeIsWithinPostUpgradeTimeLimit(Date upgradeDate) {
        long pulpExpiryTime = upgradeDate.getTime() + TimeUnit.DAYS.toMillis(14L);
        return System.currentTimeMillis() < pulpExpiryTime;
    }

    private boolean isOfficialRelease() {
        return this.buildUtilsInfo.isEap() || this.buildUtilsInfo.isFinal() || this.buildUtilsInfo.isRc();
    }

    private boolean isRedirectLimitReached() {
        return this.getTotalRedirects() >= 10;
    }

    private int getTotalRedirects() {
        int jiraBuildNumber = this.buildUtilsInfo.getApplicationBuildNumber();
        return this.pulpRedirectDao.getRedirectCount(jiraBuildNumber);
    }

    private boolean recordAsRedirectedToPulpForThisVersionOfJira(ApplicationUser user) {
        int jiraBuildNumber = this.buildUtilsInfo.getApplicationBuildNumber();
        return this.pulpRedirectDao.addRedirect(user, jiraBuildNumber);
    }

    private boolean isAdministrator(ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    public void onStart() {
        if (this.pulpFeature.isEnabled()) {
            this.landingPageRegistrar.registerRedirect(this.pageRedirect, 5);
        }
    }

    public void onStop() {
        this.landingPageRegistrar.unregisterRedirect(this.pageRedirect);
    }

    @EventName(value="post.upgrade.landing.page.redirected")
    @VisibleForTesting
    static class RedirectedToPulpEvent {
        private final int totalRedirects;

        RedirectedToPulpEvent(int totalRedirects) {
            this.totalRedirects = totalRedirects;
        }

        public int getTotalRedirects() {
            return this.totalRedirects;
        }
    }
}

