/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web.onboarding;

import com.atlassian.jira.plugins.importer.web.onboarding.ImporterBean;
import com.atlassian.jira.plugins.importer.web.onboarding.ImportersFinderHelper;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.jackson.map.ObjectMapper;

public class JIMOnboardingPage
extends JiraWebActionSupport {
    private final ImportersFinderHelper importersFinderHelper;
    private final PageBuilderService pageBuilderService;
    private final PluginAccessor pluginAccessor;

    public JIMOnboardingPage(ImportersFinderHelper importersFinderHelper, @ComponentImport PageBuilderService pageBuilderService, @ComponentImport PluginAccessor pluginAccessor) {
        this.importersFinderHelper = importersFinderHelper;
        this.pageBuilderService = pageBuilderService;
        this.pluginAccessor = pluginAccessor;
    }

    protected String doExecute() throws Exception {
        if (this.getLoggedInApplicationUser() == null) {
            return this.redirectToLogin();
        }
        if (!this.hasPermission(0)) {
            return this.getRedirect("/secure/Dashboard.jspa");
        }
        if (this.pluginAccessor.isPluginEnabled("com.atlassian.analytics.analytics-client")) {
            this.pageBuilderService.assembler().resources().requireWebResource("com.atlassian.analytics.analytics-client:js-events");
        }
        this.pageBuilderService.assembler().data().requireData("jira-importers-plugins:importers", new Jsonable(){
            private final String importersJson;
            {
                this.importersJson = JIMOnboardingPage.this.getImportersJson();
            }

            public void write(Writer writer) throws IOException {
                writer.write(this.importersJson);
            }
        });
        this.pageBuilderService.assembler().resources().requireWebResource("com.atlassian.jira.plugins.jira-importers-plugin:jim-onboarding");
        return super.doExecute();
    }

    private String redirectToLogin() {
        HttpServletRequest request = this.getHttpRequest();
        String returnURL = request.getRequestURI().substring(request.getContextPath().length());
        if (request.getQueryString() != null) {
            returnURL = returnURL + "?" + request.getQueryString();
        }
        return this.getRedirect("/login.jsp?os_destination=" + JiraUrlCodec.encode((String)returnURL), false);
    }

    @ActionViewData
    public String getPageTitle() {
        return this.getText("jira-importer-plugin.onboarding.page.title");
    }

    private Iterable<ImporterBean> getImporters() {
        return this.importersFinderHelper.getImportersToDisplay();
    }

    private String getImportersJson() {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString((Object)Lists.newArrayList(this.getImporters()));
        }
        catch (IOException e) {
            this.log.warn((Object)"Cannot serialize importers", (Throwable)e);
            return "";
        }
    }
}

