/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web.onboarding;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.plugins.importer.extensions.ExternalSystemImporterModuleDescriptor;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.web.onboarding.ImporterBean;
import com.atlassian.jira.plugins.importer.web.onboarding.ImporterKeyFormatter;
import com.atlassian.jira.plugins.importer.web.onboarding.NonExistingImporterBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportersFinderHelper {
    public static final String DARK_FEATURE_SHOW_UNAVAILABLE_IMPORTERS = "jim.feature.show.unavailable.importers";
    private static final Logger log = Logger.getLogger(ImportersFinderHelper.class);
    public static final String LOGO_MODULE_KEY = "com.atlassian.jira.plugins.jira-importers-plugin:graphics";
    public static final String JIM_ONBOARDING_DIALOG_LOCATION = "jim.onboarding.dialog";
    public static final String CSV_IMPORTER_FOR_NON_EXISTING = "CsvSetupPage!default.jspa?externalSystem=com.atlassian.jira.plugins.jira-importers-plugin:csvImporter&nonImporter=%s";
    private final PluginAccessor pluginAccessor;
    private final WebResourceManager webResourceManager;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final JiraAuthenticationContext authenticationContext;
    private final CompatibilityBridgeUtils bridgeUtils;
    private final FeatureManager featureManager;
    private final HelpUrls helpUrls;

    @Autowired
    public ImportersFinderHelper(@ComponentImport PluginAccessor pluginAccessor, @ComponentImport WebResourceManager webResourceManager, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, @ComponentImport FeatureManager featureManager, @ComponentImport HelpUrls helpUrls, CompatibilityBridgeUtils bridgeUtils) {
        this.pluginAccessor = pluginAccessor;
        this.webResourceManager = webResourceManager;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.authenticationContext = authenticationContext;
        this.bridgeUtils = bridgeUtils;
        this.featureManager = featureManager;
        this.helpUrls = helpUrls;
    }

    public Iterable<ImporterBean> getImportersToDisplay() {
        final List<ImporterBean> visibleImporters = this.getVisiblePluggedImporters();
        Iterable notAddedImporters = Iterables.filter(this.getUnavailableImporters(), (Predicate)new Predicate<ImporterBean>(){

            public boolean apply(final ImporterBean unavailableImporter) {
                return !Iterables.any((Iterable)visibleImporters, (Predicate)new Predicate<ImporterBean>(){

                    public boolean apply(ImporterBean visibleImporter) {
                        return unavailableImporter.getKey().equals(visibleImporter.getKey());
                    }
                });
            }
        });
        Iterable allDisplayableImporters = Iterables.concat(visibleImporters, (Iterable)notAddedImporters);
        return Ordering.natural().sortedCopy((Iterable)ImmutableList.copyOf((Iterable)allDisplayableImporters));
    }

    private List<ImporterBean> getVisiblePluggedImporters() {
        List importerDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(ExternalSystemImporterModuleDescriptor.class);
        final HashMap context = Maps.newHashMap();
        context.put("user", this.authenticationContext.getUser());
        Iterable visibleDescriptors = Iterables.filter((Iterable)importerDescriptors, (Predicate)new Predicate<ExternalSystemImporterModuleDescriptor>(){

            public boolean apply(ExternalSystemImporterModuleDescriptor input) {
                Condition condition = input.getCondition();
                try {
                    return !input.isNonAdmin() && (condition == null || condition.shouldDisplay((Map)context));
                }
                catch (Exception e) {
                    log.error((Object)("Cannot evaluate condition for descriptor '" + input.getKey() + "'"), (Throwable)e);
                    return false;
                }
            }
        });
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)visibleDescriptors, (Function)new Function<ExternalSystemImporterModuleDescriptor, ImporterBean>(){

            @Nullable
            public ImporterBean apply(ExternalSystemImporterModuleDescriptor input) {
                return ImportersFinderHelper.this.toImporterBean(input);
            }
        }));
    }

    private Iterable<ImporterBean> getUnavailableImporters() {
        if (!this.bridgeUtils.rolesEnabled() && !this.featureManager.getDarkFeatures().isFeatureEnabled(DARK_FEATURE_SHOW_UNAVAILABLE_IMPORTERS)) {
            return ImmutableList.of();
        }
        List<NonExistingImporterBean> nonExistingImporters = this.getNonExistingImporters();
        return Iterables.transform(nonExistingImporters, (Function)new Function<NonExistingImporterBean, ImporterBean>(){

            public ImporterBean apply(NonExistingImporterBean input) {
                String logoLink = input.logoFile != null ? ImportersFinderHelper.this.webResourceManager.getStaticPluginResource(ImportersFinderHelper.LOGO_MODULE_KEY, input.logoFile) : null;
                HelpUrl documentationUrl = ImportersFinderHelper.this.helpUrls.getUrl(input.key);
                return new ImporterBean.ImporterBeanBuilder().key(input.key).uniqueId(ImporterKeyFormatter.getImporterId(input.key)).name(input.name).importerLink(String.format(ImportersFinderHelper.CSV_IMPORTER_FOR_NON_EXISTING, input.key)).documentationLink(documentationUrl.getUrl()).logoLink(logoLink).dialogHtml(ImportersFinderHelper.this.getPanelHtmlOrNull(input.dialogPanelKey)).dialogImgLink(ImportersFinderHelper.this.getDialogImageLink()).weight(input.weight).available(false).createImporterBean();
            }
        });
    }

    private List<NonExistingImporterBean> getNonExistingImporters() {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            InputStream importersFileStream = this.getClass().getResourceAsStream("/non-existing-importers.json");
            List nonExistingImporters = (List)objectMapper.reader((TypeReference)new TypeReference<List<NonExistingImporterBean>>(){}).readValue(importersFileStream);
            return nonExistingImporters;
        }
        catch (IOException e) {
            log.warn((Object)"Cannot load non-existing-importers.json file", (Throwable)e);
            return ImmutableList.of();
        }
    }

    private ImporterBean toImporterBean(ExternalSystemImporterModuleDescriptor descriptor) {
        String logoLink = this.webResourceManager.getStaticPluginResource(descriptor.getLogoModuleKey(), descriptor.getLogoFile());
        String firstStepName = this.getFirstStepName(descriptor);
        String importerLink = String.format("%s!default.jspa?externalSystem=%s", firstStepName, descriptor.getCompleteKey());
        String html = this.getPanelHtmlOrNull(descriptor.getOnboardingPanelKey());
        return new ImporterBean.ImporterBeanBuilder().key(descriptor.getKey()).uniqueId(ImporterKeyFormatter.getImporterId(descriptor.getKey())).logoLink(logoLink).name(descriptor.getName()).importerLink(importerLink).weight(descriptor.getWeight()).dialogHtml(html).available(true).dialogImgLink(this.getDialogImageLink()).documentationLink(descriptor.getDocumentationUrl()).createImporterBean();
    }

    private String getFirstStepName(ExternalSystemImporterModuleDescriptor descriptor) {
        try {
            return ((ImporterController)descriptor.getModule()).getSteps().get(0);
        }
        catch (Exception e) {
            log.warn((Object)("cannot read module from descriptior: " + descriptor.getCompleteKey()), (Throwable)e);
            return "";
        }
    }

    private String getPanelHtmlOrNull(final String panelKey) {
        if (panelKey != null) {
            String html = this.bridgeUtils.renderWebPanelsFor(JIM_ONBOARDING_DIALOG_LOCATION, (Map<String, Object>)ImmutableMap.of(), new Predicate<ModuleDescriptor<WebPanel>>(){

                public boolean apply(ModuleDescriptor<WebPanel> input) {
                    return input.getCompleteKey().equals(panelKey);
                }
            });
            return StringUtils.trimToNull((String)html);
        }
        return null;
    }

    private String getDialogImageLink() {
        return this.webResourceUrlProvider.getStaticPluginResourceUrl(LOGO_MODULE_KEY, "onboarding-dialog-image.svg", UrlMode.RELATIVE);
    }

    public Optional<ImporterBean> getUnavailableImporterBeanByKey(final String nonImporter) {
        if (StringUtils.isBlank((CharSequence)nonImporter)) {
            return Optional.absent();
        }
        Iterable<ImporterBean> unavailableImporters = this.getUnavailableImporters();
        Iterable matchingImporter = Iterables.filter(unavailableImporters, (Predicate)new Predicate<ImporterBean>(){

            public boolean apply(ImporterBean input) {
                return input.getKey().equals(nonImporter);
            }
        });
        return Optional.fromNullable((Object)Iterables.getFirst((Iterable)matchingImporter, null));
    }
}

