/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web.csv;

import com.atlassian.fugue.Pair;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.csv.CsvDateParser;
import com.atlassian.jira.plugins.importer.imports.csv.CsvFile;
import com.atlassian.jira.plugins.importer.imports.csv.MappedCsvLineHandler;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean;
import com.atlassian.jira.plugins.importer.web.csv.CsvFieldMapping;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class GoodCsvConfigBean
extends AbstractConfigBean
implements CsvDateParser {
    private static final Logger log = Logger.getLogger(GoodCsvConfigBean.class);
    private static final String CURRENT_CONFIG_VERSION = "2.0";
    private static final String CONFIG_VERSION = "config.version";
    private static final String CONFIG_ENCODING = "config.encoding";
    private static final String CONFIG_DATE_FORMAT = "config.date.format";
    private static final String CONFIG_EMAIL_SUFFIX = "config.email.suffix";
    private static final String CONFIG_DELIMITER = "config.delimiter";
    private static final String CONFIG_PROJECT = "config.project";
    private static final String CONFIG_READING_PROJECT_FROM_CSV = "config.project.from.csv";
    private static final String CONFIG_FIELD_MAPPINGS = "config.field.mappings";
    private static final String CONFIG_VALUE_MAPPINGS = "config.value.mappings";
    private static final Set<String> RECOGNIZED_OLD_CONFIG_KEYS = ImmutableSet.of((Object)"encoding", (Object)"mapfromcsv", (Object)"user.email.suffix", (Object)"date.import.format", (Object)"project.key", (Object)"project.name", (Object[])new String[]{"project.lead", "project.description", "project.url"});
    private static final Set<String> RECOGNIZED_NEW_CONFIG_KEYS = ImmutableSet.of((Object)"config.version", (Object)"config.encoding", (Object)"config.date.format", (Object)"config.email.suffix", (Object)"config.delimiter", (Object)"config.project", (Object[])new String[]{"config.project.from.csv", "config.field.mappings", "config.value.mappings"});
    public static final Character DEFAULT_DELIMITER = Character.valueOf(',');
    public static final String DEFAULT_ENCODING = "UTF-8";
    private String encoding = "UTF-8";
    private String dateFormat;
    private String userEmailSuffix = "@";
    private Character delimiter = DEFAULT_DELIMITER;
    private boolean isReadingProjectFromCsv;
    private ExternalProject pickedProject;
    private CsvFile csvFile;
    private File csvFilePath;
    private TimeZoneInfo timeZoneInfo;
    private Map<String, CsvFieldMapping> fieldMappings = Maps.newHashMap();
    private Map<String, Map<String, String>> valueMappings = Maps.newHashMap();
    private BiMap<Pair<String, String>, Integer> valueMappingsUniqueIds = HashBiMap.create();
    private Map<String, String> unrecognizedProperties = Maps.newHashMap();

    public void setTimeZoneInfo(TimeZoneInfo timeZoneInfo) {
        this.timeZoneInfo = timeZoneInfo;
    }

    public void setCsvFilePath(File csvFilePath) {
        this.csvFilePath = csvFilePath;
    }

    public File getCsvFilePath() {
        return this.csvFilePath;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setUserEmailSuffix(String userEmailSuffix) {
        this.userEmailSuffix = userEmailSuffix;
    }

    public void setReadingProjectFromCsv(boolean isReadingProjectFromCsv) {
        this.isReadingProjectFromCsv = isReadingProjectFromCsv;
    }

    public void setDelimiter(Character delimiter) {
        this.delimiter = delimiter;
    }

    public Map<String, String> getUnrecognizedProperties() {
        return this.unrecognizedProperties;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Character getDelimiter() {
        return this.delimiter;
    }

    public String getUserEmailSuffix() {
        return this.userEmailSuffix;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    public CsvFile getCsvFile() {
        return this.csvFile;
    }

    public boolean isReadingProjectFromCsv() {
        return this.isReadingProjectFromCsv;
    }

    public ExternalProject getPickedProject() {
        return this.pickedProject;
    }

    public void initFile() {
        this.csvFile = new CsvFile(this.encoding, this.csvFilePath, this.delimiter);
    }

    @Override
    public void copyFromProperties(InputStream configFile) throws Exception {
        new ConfigurationHandler().copyFromProperties(configFile);
    }

    @Override
    public void copyToNewProperties(Map<String, Object> configFile) {
        new ConfigurationHandler().copyToNewProperties(configFile);
    }

    @Override
    @Nullable
    public String getProjectKey(String projectName) {
        return this.pickedProject != null ? this.pickedProject.getKey() : null;
    }

    @Override
    public String getProjectName(String projectName) {
        return this.pickedProject != null ? this.pickedProject.getName() : null;
    }

    @Override
    @Nullable
    public String getProjectLead(String projectName) {
        return this.pickedProject != null ? this.pickedProject.getLead() : null;
    }

    @Override
    @Nullable
    public String getProjectTypeKey(String projectName) {
        return this.pickedProject != null ? this.pickedProject.getType() : null;
    }

    public void setPickedProject(String key, String name, String lead, String typeKey) {
        if (this.pickedProject != null) {
            this.pickedProject.setKey(key);
            this.pickedProject.setName(name);
            this.pickedProject.setLead(lead);
            this.pickedProject.setType(typeKey);
        } else {
            this.pickedProject = new ExternalProject(name, key, lead, typeKey);
        }
    }

    public void putFieldMappings(ImmutableList<Pair<String, CsvFieldMapping>> mappings) {
        this.fieldMappings.clear();
        for (Pair mapping : mappings) {
            this.fieldMappings.put((String)mapping.left(), (CsvFieldMapping)mapping.right());
        }
    }

    public boolean isAnyHeaderMappedTo(final String jiraField) {
        return Iterables.any(this.fieldMappings.values(), (Predicate)new Predicate<CsvFieldMapping>(){

            public boolean apply(CsvFieldMapping input) {
                return input.isJiraField() && input.getJiraFieldName().equals(jiraField);
            }
        });
    }

    public Optional<CsvFieldMapping> getMappingFor(String header) {
        return Optional.fromNullable((Object)this.fieldMappings.get(header));
    }

    public Set<String> getHeader() {
        return this.csvFile.getHeader();
    }

    public String[] getRawHeader() {
        return this.csvFile.getRawHeader();
    }

    public ServiceOutcome<Multimap<String, String>> getUniqueValues() {
        return this.csvFile.getUniqueValues(this.getHeadersForManualMapping());
    }

    public Iterable<String> getHeadersForManualMapping() {
        return Iterables.filter(this.fieldMappings.keySet(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                CsvFieldMapping fieldMapping = (CsvFieldMapping)GoodCsvConfigBean.this.fieldMappings.get(input);
                return fieldMapping.isJiraField() && "status".equals(fieldMapping.getJiraFieldName()) || fieldMapping.isManualMapping();
            }
        });
    }

    public Map<String, CsvFieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public boolean containsHeaderMappedTo(final String jiraField) {
        return Iterables.any(this.fieldMappings.values(), (Predicate)new Predicate<CsvFieldMapping>(){

            public boolean apply(CsvFieldMapping input) {
                return input.isJiraField() && jiraField.equals(input.getJiraFieldName());
            }
        });
    }

    public boolean hasHeaderMultipleColumns(String header) {
        return this.csvFile.hasHeaderMultipleColumns(header);
    }

    public String getSampleDataFor(String header) {
        Iterable<String> sampleData = this.csvFile.getValuesFor(header);
        if (Iterables.size(sampleData) <= 0) {
            return "First row doesn't have a value";
        }
        return Joiner.on((String)", ").join(sampleData);
    }

    public String getValueMappingForHeader(String header, String csvValue) {
        Map<String, String> valueMappings = this.valueMappings.get(header);
        if (valueMappings != null) {
            String mappedValue = valueMappings.get(csvValue);
            return mappedValue != null ? mappedValue : csvValue;
        }
        return csvValue;
    }

    public Integer getMappedValueUniqueName(String header, String csvValue) {
        Pair key = new Pair((Object)header, (Object)csvValue);
        if (this.valueMappingsUniqueIds.containsKey((Object)key)) {
            return (Integer)this.valueMappingsUniqueIds.get((Object)key);
        }
        int index = this.valueMappingsUniqueIds.size();
        this.valueMappingsUniqueIds.put((Object)key, (Object)index);
        return index;
    }

    public Pair<String, String> getHeaderAndCsvValueForId(int id) {
        return (Pair)this.valueMappingsUniqueIds.inverse().get((Object)id);
    }

    public void cleanValueMappings() {
        this.valueMappings.clear();
    }

    public boolean isAnyHeaderSelectedForManualMapping() {
        return Iterables.any(this.fieldMappings.values(), (Predicate)new Predicate<CsvFieldMapping>(){

            public boolean apply(CsvFieldMapping input) {
                return input.isManualMapping();
            }
        });
    }

    public void putNewValueMapping(String header, String csvValue, String mappedValue) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mappedValue)) {
            return;
        }
        Map<String, String> headerMappings = this.valueMappings.get(header);
        if (headerMappings != null) {
            headerMappings.put(csvValue, mappedValue);
        } else {
            HashMap newMap = Maps.newHashMap();
            newMap.put(csvValue, mappedValue);
            this.valueMappings.put(header, newMap);
        }
    }

    @Override
    public Date parseDateTime(String value) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.dateFormat);
        simpleDateFormat.setTimeZone(this.timeZoneInfo.toTimeZone());
        return simpleDateFormat.parse(value);
    }

    @Override
    public Date parseDate(String value) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.dateFormat);
        return simpleDateFormat.parse(value);
    }

    public ErrorCollection readWholeFile(MappedCsvLineHandler mappedCsvLineHandler) {
        return this.csvFile.handleCsvContent(this, mappedCsvLineHandler);
    }

    public Iterable<CsvFieldMapping> getMappingsWithUsers() {
        return Iterables.filter(this.fieldMappings.values(), (Predicate)new Predicate<CsvFieldMapping>(){

            public boolean apply(CsvFieldMapping mapping) {
                String type = null;
                if (mapping.isJiraField()) {
                    return "assignee".equals(mapping.getJiraFieldName()) || "reporter".equals(mapping.getJiraFieldName()) || "project.lead".equals(mapping.getJiraFieldName());
                }
                if (mapping.isNewCustomField()) {
                    type = mapping.getCustomFieldType();
                } else if (mapping.isExistingCustomField()) {
                    CustomField cf = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(mapping.getCustomFieldId());
                    type = cf != null ? cf.getCustomFieldType().getKey() : null;
                }
                return type != null && "com.atlassian.jira.plugin.system.customfieldtypes:userpicker".equals(type) || "com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker".equals(type);
            }
        });
    }

    private class ConfigurationHandler {
        private ConfigurationHandler() {
        }

        public void copyFromProperties(InputStream configFile) throws Exception {
            ObjectMapper mapper = new ObjectMapper();
            Map config = (Map)mapper.readValue(configFile, (TypeReference)new TypeReference<Map<String, Object>>(){});
            if (!config.containsKey(GoodCsvConfigBean.CONFIG_VERSION) || !GoodCsvConfigBean.CURRENT_CONFIG_VERSION.equals(config.get(GoodCsvConfigBean.CONFIG_VERSION))) {
                this.handleOldConfiguration(config);
                return;
            }
            GoodCsvConfigBean.this.encoding = (String)config.get(GoodCsvConfigBean.CONFIG_ENCODING);
            GoodCsvConfigBean.this.dateFormat = (String)config.get(GoodCsvConfigBean.CONFIG_DATE_FORMAT);
            GoodCsvConfigBean.this.delimiter = Character.valueOf(config.get(GoodCsvConfigBean.CONFIG_DELIMITER).toString().charAt(0));
            GoodCsvConfigBean.this.userEmailSuffix = (String)config.get(GoodCsvConfigBean.CONFIG_EMAIL_SUFFIX);
            GoodCsvConfigBean.this.isReadingProjectFromCsv = Boolean.valueOf((String)config.get(GoodCsvConfigBean.CONFIG_READING_PROJECT_FROM_CSV));
            GoodCsvConfigBean.this.valueMappings = this.makeMutableMap((Map)config.get(GoodCsvConfigBean.CONFIG_VALUE_MAPPINGS));
            GoodCsvConfigBean.this.fieldMappings = Maps.newHashMap((Map)Maps.transformEntries((Map)((Map)config.get(GoodCsvConfigBean.CONFIG_FIELD_MAPPINGS)), (Maps.EntryTransformer)new Maps.EntryTransformer<String, Map<String, String>, CsvFieldMapping>(){

                public CsvFieldMapping transformEntry(String key, Map<String, String> value) {
                    CsvFieldMapping fieldMapping = CsvFieldMapping.fromConfig(value);
                    fieldMapping.setManualMapping(GoodCsvConfigBean.this.valueMappings.containsKey(key));
                    return fieldMapping;
                }
            }));
            GoodCsvConfigBean.this.pickedProject = this.readProject((Map)config.get(GoodCsvConfigBean.CONFIG_PROJECT));
            for (Map.Entry entry : config.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)key) || value == null || !(value instanceof String) || RECOGNIZED_NEW_CONFIG_KEYS.contains(key)) continue;
                GoodCsvConfigBean.this.unrecognizedProperties.put(key, (String)value);
            }
        }

        private Map<String, Map<String, String>> makeMutableMap(Map<String, Map<String, String>> map) {
            HashMap mutable = Maps.newHashMap();
            mutable.putAll(map);
            return mutable;
        }

        private void handleOldConfiguration(Map<String, Object> configuration) throws Exception {
            HashSet headersToValueMapping = Sets.newHashSet();
            for (Map.Entry<String, Object> entry : configuration.entrySet()) {
                String key = entry.getKey();
                if (!(entry.getValue() instanceof String) || key == null) continue;
                String value = (String)entry.getValue();
                if (key.startsWith("field.")) {
                    String header = key.replace("field.", "");
                    if (value.startsWith("customfield_")) {
                        CustomField customField = this.getCustomField(value);
                        if (customField != null) {
                            GoodCsvConfigBean.this.fieldMappings.put(header, CsvFieldMapping.existingCF(customField.getIdAsLong()));
                            continue;
                        }
                        String name = this.extractCustomFieldId(value);
                        String type = this.extractCustomFieldType(value);
                        GoodCsvConfigBean.this.fieldMappings.put(header, CsvFieldMapping.newCF(name, type, null));
                        continue;
                    }
                    GoodCsvConfigBean.this.fieldMappings.put(header, CsvFieldMapping.field(value));
                    continue;
                }
                if (key.startsWith("value.")) {
                    String valueMapping = key.replaceFirst("value\\.", "");
                    String header = valueMapping.substring(0, valueMapping.indexOf(46));
                    String csvValue = valueMapping.substring(header.length() + 1);
                    GoodCsvConfigBean.this.putNewValueMapping(header, csvValue, "".equals(value) ? "<<blank>>" : value);
                    headersToValueMapping.add(header);
                    continue;
                }
                if (RECOGNIZED_OLD_CONFIG_KEYS.contains(key)) continue;
                GoodCsvConfigBean.this.unrecognizedProperties.put(key, value);
            }
            GoodCsvConfigBean.this.encoding = this.either(this.either(configuration.get("encoding"), configuration.get("file.encoding")), GoodCsvConfigBean.DEFAULT_ENCODING);
            GoodCsvConfigBean.this.dateFormat = this.either(configuration.get("date.import.format"), configuration.get("file.date.format"));
            GoodCsvConfigBean.this.delimiter = Character.valueOf(this.either(this.asString(configuration.get("file.delimiter")), this.asString(GoodCsvConfigBean.this.delimiter)).charAt(0));
            GoodCsvConfigBean.this.isReadingProjectFromCsv = Boolean.valueOf((String)configuration.get("mapfromcsv"));
            GoodCsvConfigBean.this.userEmailSuffix = (String)configuration.get("user.email.suffix");
            GoodCsvConfigBean.this.pickedProject = this.readProject(configuration);
            for (String header : headersToValueMapping) {
                CsvFieldMapping fieldMapping = (CsvFieldMapping)GoodCsvConfigBean.this.fieldMappings.get(header);
                if (fieldMapping == null) continue;
                fieldMapping.setManualMapping(true);
            }
        }

        private String asString(Object o) {
            if (o == null) {
                return null;
            }
            if (o instanceof String) {
                String s = (String)o;
                return s.length() > 0 ? s.substring(0, 1) : null;
            }
            if (o instanceof Character) {
                return o.toString();
            }
            return null;
        }

        private String either(Object s1, Object s2) {
            return (String)(s1 != null ? s1 : s2);
        }

        private String extractCustomFieldId(String customfieldId) {
            String fieldId = StringUtils.contains((String)customfieldId, (String)":") ? StringUtils.substringBetween((String)customfieldId, (String)"customfield_", (String)":") : StringUtils.substringAfter((String)customfieldId, (String)"customfield_");
            return fieldId;
        }

        public String extractCustomFieldType(String customfieldId) {
            return StringUtils.substringAfter((String)customfieldId, (String)":");
        }

        private CustomField getCustomField(String customfieldId) {
            CustomField customFieldObject = null;
            try {
                customFieldObject = ((CustomFieldManager)ComponentAccessor.getComponent(CustomFieldManager.class)).getCustomFieldObject(customfieldId);
            }
            catch (NumberFormatException e) {
                log.warn((Object)"Cannot get Custom Field from configuration", (Throwable)e);
            }
            catch (Exception e) {
                log.warn((Object)"Cannot get Custom Field from configuration", (Throwable)e);
            }
            return customFieldObject;
        }

        public void copyToNewProperties(Map<String, Object> configFile) {
            configFile.put(GoodCsvConfigBean.CONFIG_VERSION, GoodCsvConfigBean.CURRENT_CONFIG_VERSION);
            configFile.put(GoodCsvConfigBean.CONFIG_ENCODING, GoodCsvConfigBean.this.encoding);
            configFile.put(GoodCsvConfigBean.CONFIG_DATE_FORMAT, GoodCsvConfigBean.this.dateFormat);
            configFile.put(GoodCsvConfigBean.CONFIG_DELIMITER, GoodCsvConfigBean.this.delimiter);
            configFile.put(GoodCsvConfigBean.CONFIG_EMAIL_SUFFIX, GoodCsvConfigBean.this.userEmailSuffix);
            configFile.put(GoodCsvConfigBean.CONFIG_READING_PROJECT_FROM_CSV, String.valueOf(GoodCsvConfigBean.this.isReadingProjectFromCsv));
            configFile.put(GoodCsvConfigBean.CONFIG_FIELD_MAPPINGS, Maps.transformEntries((Map)GoodCsvConfigBean.this.fieldMappings, (Maps.EntryTransformer)new Maps.EntryTransformer<String, CsvFieldMapping, Map<String, String>>(){

                public Map<String, String> transformEntry(String key, CsvFieldMapping value) {
                    return value.toConfig();
                }
            }));
            configFile.put(GoodCsvConfigBean.CONFIG_VALUE_MAPPINGS, GoodCsvConfigBean.this.valueMappings);
            if (GoodCsvConfigBean.this.pickedProject != null) {
                configFile.put(GoodCsvConfigBean.CONFIG_PROJECT, this.projectToConfig());
            }
        }

        private Map<String, String> projectToConfig() {
            HashMap config = Maps.newHashMap();
            config.put("project.key", GoodCsvConfigBean.this.pickedProject.getKey());
            config.put("project.name", GoodCsvConfigBean.this.pickedProject.getName());
            config.put("project.lead", GoodCsvConfigBean.this.pickedProject.getLead());
            config.put("project.description", GoodCsvConfigBean.this.pickedProject.getDescription());
            config.put("project.url", GoodCsvConfigBean.this.pickedProject.getUrl());
            config.put("project.type", GoodCsvConfigBean.this.pickedProject.getType());
            return config;
        }

        private ExternalProject readProject(Map<String, Object> config) {
            if (config == null) {
                return null;
            }
            ExternalProject externalProject = new ExternalProject();
            externalProject.setKey((String)config.get("project.key"));
            externalProject.setName((String)config.get("project.name"));
            externalProject.setLead((String)config.get("project.lead"));
            externalProject.setDescription((String)config.get("project.description"));
            externalProject.setUrl((String)config.get("project.url"));
            externalProject.setType((String)config.get("project.type"));
            return externalProject;
        }
    }
}

