/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web.components;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.plugins.importer.external.ExternalProjectUtils;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.jira.plugins.importer.web.components.ProjectModel;
import com.atlassian.jira.plugins.importer.web.components.ProjectSelectionModel;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class ProjectMappingComponent {
    private static final Logger log = Logger.getLogger(ProjectMappingComponent.class);
    private final ProjectManager projectManager;
    private final JiraAuthenticationContext authenticationContext;
    private Collection<Project> applicableProjects;
    private AbstractConfigBean2 configBean;
    private boolean canCreateNewProjects;
    private ProjectValidation projectValidation = new ProjectValidation(){

        @Override
        public void validateProject(String externalProjectName, ExternalProject mapping) {
        }
    };

    public ProjectMappingComponent(ProjectManager projectManager, JiraAuthenticationContext authenticationContext) {
        this.projectManager = projectManager;
        this.authenticationContext = authenticationContext;
    }

    public List<String> getExternalProjects() {
        return this.configBean.getExternalProjectNames();
    }

    public Collection<Project> getApplicableProjects() {
        return this.applicableProjects;
    }

    public boolean isCanCreateNewProjects() {
        return this.canCreateNewProjects;
    }

    public void setConfigBean(AbstractConfigBean2 configBean) {
        this.configBean = configBean;
    }

    public void setApplicableProjects(Collection<Project> applicableProjects) {
        this.applicableProjects = applicableProjects;
    }

    public void setCanCreateNewProjects(boolean canCreateNewProjects) {
        this.canCreateNewProjects = canCreateNewProjects;
    }

    public void setProjectValidation(ProjectValidation projectValidation) {
        this.projectValidation = projectValidation;
    }

    public String getProjectsSuggestionsModel() {
        ArrayList suggestions = Lists.newArrayList((Iterable)Iterables.transform(this.applicableProjects, (Function)new Function<Project, ProjectModel>(){

            public ProjectModel apply(Project input) {
                return new ProjectModel(input.getId(), input.getName(), input.getKey());
            }
        }));
        suggestions.addAll(Collections2.transform(this.getSuggestedNewProjects(), ProjectModel.fromExternalProject()));
        return this.toJSON(suggestions);
    }

    public String getExternalProjectsModel() {
        Iterable externalProjectModel = Iterables.transform(this.configBean.getExternalProjectNames(), (Function)new Function<String, Object>(){

            public Object apply(String name) {
                ProjectSelectionModel model = new ProjectSelectionModel();
                model.externalName = name;
                model.id = ProjectMappingComponent.getProjectFieldId(name);
                model.selected = ProjectMappingComponent.this.configBean.isProjectSelected(name);
                model.key = ProjectMappingComponent.this.configBean.getProjectKey(name);
                model.type = ProjectMappingComponent.this.configBean.getProjectTypeKey(name);
                return model;
            }
        });
        return this.toJSON(Lists.newArrayList((Iterable)externalProjectModel));
    }

    public ServiceResult processProjectSelection(String mapping) {
        HashMap projectKeyMappings = Maps.newHashMap();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ServiceResultImpl serviceResult = new ServiceResultImpl((ErrorCollection)errorCollection);
        Map<String, ProjectSelectionModel> projectMappings = this.decodeMapping(mapping);
        if (projectMappings == null) {
            return serviceResult;
        }
        List<String> projectNames = this.configBean.getExternalProjectNames();
        Collections.sort(projectNames);
        for (String projectName : projectNames) {
            String fieldId = ProjectMappingComponent.getProjectFieldId(projectName);
            ProjectSelectionModel mappingData = projectMappings.get(fieldId);
            if (mappingData.projectModel == null) continue;
            ExternalProject project = new ExternalProject(mappingData.projectModel.name, mappingData.projectModel.key);
            this.projectValidation.validateProject(projectName, project);
            Project jiraProject = ExternalProjectUtils.getProject(this.projectManager, project);
            if (jiraProject != null) {
                if (!jiraProject.getKey().equals(project.getKey()) || !jiraProject.getName().equals(project.getName())) {
                    errorCollection.addError(projectName, this.getText("jira-importer-plugin.project.key.or.name.already.used"));
                }
            } else {
                errorCollection.addError(projectName, this.getText("jira-importer-plugin.general.project.dont.exists"));
            }
            projectKeyMappings.put(projectName, project);
        }
        this.configBean.populateProjectKeyMappings(projectKeyMappings);
        return serviceResult;
    }

    @Nullable
    private Map<String, ProjectSelectionModel> decodeMapping(String mappingJSON) {
        List model;
        try {
            model = (List)new ObjectMapper().readValue(mappingJSON, (TypeReference)new TypeReference<List<ProjectSelectionModel>>(){});
        }
        catch (IOException e) {
            log.warn((Object)"Error decoding project mapping model", (Throwable)e);
            log.trace((Object)("Received model: " + mappingJSON));
            return null;
        }
        return Maps.uniqueIndex((Iterable)model, (Function)new Function<ProjectSelectionModel, String>(){

            public String apply(ProjectSelectionModel input) {
                return input.id;
            }
        });
    }

    public static String getProjectFieldId(String projectName) {
        return "P" + DigestUtils.md5Hex((String)projectName);
    }

    public Collection<ExternalProject> getSuggestedNewProjects() {
        Collection suggestedKeys = Collections2.transform(this.configBean.getExternalProjectNames(), (Function)new Function<String, ExternalProject>(){

            public ExternalProject apply(String importedProjectName) {
                String projectKey = ProjectMappingComponent.this.configBean.getProjectKey(importedProjectName);
                String projectName = ProjectMappingComponent.this.configBean.getProjectName(importedProjectName);
                String projectLead = ProjectMappingComponent.this.configBean.getProjectLead(importedProjectName);
                String projectType = ProjectMappingComponent.this.configBean.getProjectTypeKey(importedProjectName);
                return new ExternalProject(projectName, projectKey, projectLead, projectType);
            }
        });
        ImmutableSet existingProjectKeys = ImmutableSet.copyOf((Iterable)Iterables.transform(this.applicableProjects, (Function)new Function<Project, String>(){

            public String apply(Project input) {
                return input.getKey();
            }
        }));
        return Collections2.filter((Collection)suggestedKeys, (Predicate)new Predicate<ExternalProject>((Set)existingProjectKeys){
            final /* synthetic */ Set val$existingProjectKeys;
            {
                this.val$existingProjectKeys = set;
            }

            public boolean apply(ExternalProject suggestedProject) {
                String key = suggestedProject.getKey();
                return StringUtils.isNotBlank((String)key) && !this.val$existingProjectKeys.contains(key);
            }
        });
    }

    private String getText(String text) {
        return this.authenticationContext.getI18nHelper().getText(text);
    }

    private String toJSON(Object object) {
        try {
            return new ObjectMapper().writeValueAsString(object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface ProjectValidation {
        public void validateProject(String var1, ExternalProject var2);
    }
}

