/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web;

import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nullable;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class SiteConfiguration {
    private final String url;
    private final String username;
    private final String password;
    private final boolean useCredentials;

    public SiteConfiguration(String url) {
        this(url, false, null, null);
    }

    public SiteConfiguration(String url, boolean useCredentials, @Nullable String username, @Nullable String password) {
        this.useCredentials = useCredentials;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public boolean isValidUrl() {
        try {
            URL u = new URL(this.url);
            if (!"http".equals(u.getProtocol()) && !"https".equals(u.getProtocol())) {
                return false;
            }
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isUseCredentials() {
        return this.useCredentials;
    }
}

