/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web;

import com.atlassian.jira.plugins.importer.web.JdbcConfiguration;
import com.atlassian.jira.plugins.importer.web.SiteConfiguration;
import javax.annotation.Nullable;
import webwork.action.ActionContext;

public class SessionConnectionConfiguration {
    final JdbcConfiguration jdbcConfiguration;
    final SiteConfiguration siteConfiguration;
    public static final String IMPORT_SESSION_CONNECTION_CONFIGURATION = "issue.importer.jira.session.connection.configuration";

    public SessionConnectionConfiguration(@Nullable JdbcConfiguration jdbcConfiguration, @Nullable SiteConfiguration siteConfiguration) {
        this.jdbcConfiguration = jdbcConfiguration;
        this.siteConfiguration = siteConfiguration;
    }

    @Nullable
    public JdbcConfiguration getJdbcConfiguration() {
        return this.jdbcConfiguration;
    }

    @Nullable
    public SiteConfiguration getSiteConfiguration() {
        return this.siteConfiguration;
    }

    @Nullable
    public static SessionConnectionConfiguration getCurrentSession(String externalSystem) {
        try {
            return (SessionConnectionConfiguration)ActionContext.getSession().get(IMPORT_SESSION_CONNECTION_CONFIGURATION + externalSystem);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static void setCurrentSession(String externalSystem, SessionConnectionConfiguration sessionConnectionConfiguration) {
        ActionContext.getSession().put(IMPORT_SESSION_CONNECTION_CONFIGURATION + externalSystem, sessionConnectionConfiguration);
    }
}

