/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web;

import com.atlassian.jira.plugins.importer.web.RemoteSiteImporterSetupPage;
import com.atlassian.jira.plugins.importer.web.SiteConfiguration;
import org.apache.commons.lang.StringUtils;

public class RemoteSiteValidator {
    public boolean validateConnection(RemoteSiteImporterSetupPage page) {
        boolean res = true;
        SiteConfiguration siteConfiguration = new SiteConfiguration(page.getSiteUrl(), page.getSiteCredentials(), page.getSiteUsername(), page.getSitePassword());
        if (!siteConfiguration.isValidUrl()) {
            page.addError("siteUrl", page.getText("jira-importer-plugin.importer.site.url.invalid"));
            res = false;
        }
        if (siteConfiguration.isUseCredentials()) {
            if (StringUtils.isBlank((String)siteConfiguration.getUsername())) {
                page.addError("siteUsername", page.getText("jira-importer-plugin.username.missing"));
                res = false;
            }
            if (StringUtils.isBlank((String)siteConfiguration.getPassword())) {
                page.addError("sitePassword", page.getText("jira-importer-plugin.password.missing"));
                res = false;
            }
        }
        return res;
    }
}

