/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.plugins.importer.SQLRuntimeException;
import com.atlassian.jira.plugins.importer.SqlUtils;
import com.atlassian.jira.plugins.importer.imports.importer.ResultSetTransformer;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Joiner;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@NotThreadSafe
public class JdbcConnection {
    private static final Logger log = Logger.getLogger(JdbcConnection.class);
    protected String driverName;
    private final String url;
    private final String username;
    private final String password;
    private Connection connection;

    public JdbcConnection(String driverName, String url, @Nullable String username, @Nullable String password) {
        this.driverName = driverName;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public static boolean isValidDriverName(String driverName) {
        try {
            ClassLoaderUtils.loadClass((String)driverName, JdbcConnection.class);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            Driver driver = this.loadDriver(this.driverName);
            StringBuilder connDescription = new StringBuilder(this.url);
            Properties connectionProperties = new Properties();
            if (StringUtils.isNotBlank((String)this.username)) {
                connectionProperties.setProperty("user", this.username);
                connDescription.append(" with username '").append(this.username).append("'");
            }
            if (StringUtils.isNotBlank((String)this.password)) {
                connectionProperties.setProperty("password", this.password);
                connDescription.append(" and password");
            }
            log.info((Object)("Connecting to JDBC using connection string: " + connDescription));
            this.connection = driver.connect(this.url, connectionProperties);
            if (this.connection == null) {
                throw new SQLException("Connection string not supported by selected driver.");
            }
            this.connection.setReadOnly(true);
        }
        return this.connection;
    }

    private Driver loadDriver(String driverName) throws SQLException {
        try {
            Class clazz = ClassLoaderUtils.loadClass((String)driverName, JdbcConnection.class);
            return (Driver)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("JDBC driver class not found: " + driverName, e);
        }
        catch (Exception e) {
            throw new SQLException("Cannot instantiate JDBC driver class " + driverName + ": " + e.getMessage(), e);
        }
    }

    public synchronized void closeConnection() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.connection = null;
    }

    public synchronized String getDriverName() {
        return this.driverName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public <T> List<T> queryDb(ResultSetTransformer<T> transformer) {
        return this.queryDb(transformer, false);
    }

    public <T> List<T> queryDbAppendCollection(ResultSetTransformer<Collection<T>> transformer) {
        return this.queryDb(transformer, true);
    }

    private <T> List<T> queryDb(ResultSetTransformer<T> transformer, boolean addAllIfCollection) {
        ArrayList<T> objects = new ArrayList<T>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sqlQuery = transformer.getSqlQuery();
            ps = this.getConnection().prepareStatement(sqlQuery, 1003, 1007);
            rs = ps.executeQuery();
            if (log.isDebugEnabled()) {
                this.logDebugInformations(sqlQuery, rs);
            }
            while (rs.next()) {
                T o = transformer.transform(rs);
                if (o == null) continue;
                if (addAllIfCollection && o instanceof Collection) {
                    Collection collection = (Collection)o;
                    objects.addAll(collection);
                    continue;
                }
                objects.add(o);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLRuntimeException(e);
            }
            catch (Throwable throwable) {
                SqlUtils.close(ps, rs);
                throw throwable;
            }
        }
        SqlUtils.close(ps, rs);
        return objects;
    }

    private void logDebugInformations(String query, ResultSet resultSet) {
        try {
            DatabaseMetaData dbmd = this.getConnection().getMetaData();
            log.debug((Object)"=====  Database info =====");
            log.debug((Object)("DatabaseProductName: " + dbmd.getDatabaseProductName()));
            log.debug((Object)("DatabaseProductVersion: " + dbmd.getDatabaseProductVersion()));
            log.debug((Object)("DatabaseMajorVersion: " + dbmd.getDatabaseMajorVersion()));
            log.debug((Object)("DatabaseMinorVersion: " + dbmd.getDatabaseMinorVersion()));
            log.debug((Object)"=====  Driver info =====");
            log.debug((Object)("DriverName: " + dbmd.getDriverName()));
            log.debug((Object)("DriverVersion: " + dbmd.getDriverVersion()));
            log.debug((Object)("DriverMajorVersion: " + dbmd.getDriverMajorVersion()));
            log.debug((Object)("DriverMinorVersion: " + dbmd.getDriverMinorVersion()));
            log.debug((Object)("Executed query: " + query));
            ResultSetMetaData rsmd = resultSet.getMetaData();
            this.printColTypes(rsmd);
            if (resultSet.getWarnings() != null) {
                log.debug((Object)("Result wranings: " + Joiner.on((String)", ").join((Iterable)resultSet.getWarnings())));
            }
        }
        catch (SQLException e) {
            log.debug((Object)"Cannot log debug information", (Throwable)e);
        }
    }

    private void printColTypes(ResultSetMetaData rsmd) throws SQLException {
        int columns = rsmd.getColumnCount();
        for (int i = 1; i <= columns; ++i) {
            int jdbcType = rsmd.getColumnType(i);
            String name = rsmd.getColumnTypeName(i);
            log.debug((Object)("Column " + i + " is JDBC type " + jdbcType + ", which the DBMS calls " + name));
        }
    }

    public void validateConnection(ErrorCollection errors) {
        if (!JdbcConnection.isValidDriverName(this.driverName)) {
            errors.addErrorMessage(this.getI18nBean().getText("jira-importer-plugin.database.connection.bean.must.specify.valid.jdbc.driver"));
        }
        try {
            this.getConnection();
        }
        catch (Exception e) {
            String msg = this.getI18nBean().getText("jira-importer-plugin.database.connection.error", e.getMessage());
            log.warn((Object)msg, (Throwable)e);
            errors.addErrorMessage(msg);
        }
    }

    protected I18nHelper getI18nBean() {
        return ((JiraAuthenticationContext)ComponentManager.getComponent(JiraAuthenticationContext.class)).getI18nHelper();
    }
}

