/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.ImporterProcessSupport;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import javax.annotation.Nullable;
import webwork.action.ActionContext;

public class ImporterValueMappingsPage
extends ImporterProcessSupport.Database {
    private final WorkflowSchemeManager workflowSchemeManager = ComponentAccessor.getWorkflowSchemeManager();
    private final WorkflowManager workflowManager = ComponentAccessor.getWorkflowManager();

    public ImporterValueMappingsPage(UsageTrackingService usageTrackingService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor);
    }

    @Override
    @RequiresXsrfCheck
    protected void doValidation() {
        super.doValidation();
        if (this.getConfigBean() != null) {
            this.getConfigBean().getValueMappingHelper().populateValueMappings(ActionContext.getParameters());
        }
    }

    @Override
    public String getFormTitle() {
        return this.getText("jira-importer-plugin.set.up.value.mappings");
    }

    @Override
    public String doDefault() throws Exception {
        if (this.getConfigBean() != null) {
            this.getConfigBean().getValueMappingHelper().initDistinctValuesCache();
        }
        return super.doDefault();
    }

    public boolean areIncompatibleWorkflows() {
        final AbstractConfigBean2 configBean = (AbstractConfigBean2)Preconditions.checkNotNull((Object)this.getConfigBean());
        Iterable workflowSchemes = Iterables.filter((Iterable)Iterables.transform(configBean.getExternalProjectNames(), (Function)new Function<String, WorkflowScheme>(){

            public WorkflowScheme apply(@Nullable String input) {
                String projectKey = configBean.getProjectKey(input);
                if (projectKey == null) {
                    return null;
                }
                Project project = ImporterValueMappingsPage.this.getProjectManager().getProjectObjByKey(projectKey);
                return project == null ? ImporterValueMappingsPage.this.workflowSchemeManager.getDefaultWorkflowScheme() : ImporterValueMappingsPage.this.workflowSchemeManager.getWorkflowSchemeObj(project);
            }
        }), (Predicate)Predicates.notNull());
        Iterable statusesPerProject = Iterables.transform((Iterable)workflowSchemes, (Function)new Function<WorkflowScheme, Collection<Status>>(){

            public Collection<Status> apply(WorkflowScheme input) {
                return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(input.getMappings().values(), (Function)new Function<String, Collection<Status>>(){

                    public Collection<Status> apply(@Nullable String input) {
                        JiraWorkflow workflow = ImporterValueMappingsPage.this.workflowManager.getWorkflow(input);
                        return workflow.getLinkedStatusObjects();
                    }
                })));
            }
        });
        ImmutableSet statuses = ImmutableSet.copyOf((Iterable)statusesPerProject);
        if (statuses.size() > 1) {
            for (Collection projectOneStatuses : statuses) {
                for (Collection projectTwoStatuses : statuses) {
                    if (projectOneStatuses.containsAll(projectTwoStatuses) && !projectTwoStatuses.containsAll(projectOneStatuses)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

