/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web;

import com.atlassian.jira.plugins.importer.BackCompatibilityUtil;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.plugins.importer.web.ConfigFileHandler;
import com.atlassian.jira.plugins.importer.web.JdbcConfiguration;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.plugins.importer.web.RemoteSiteImporterSetupPage;
import com.atlassian.jira.plugins.importer.web.SessionConnectionConfiguration;
import com.atlassian.jira.plugins.importer.web.SiteConfiguration;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ImporterSetupPage
extends AbstractSetupPage
implements RemoteSiteImporterSetupPage {
    private final ConfigFileHandler configFileHandler;
    private final BackCompatibilityUtil backCompatibilityUtil;
    private String siteUrl;
    private String siteUsername;
    private String sitePassword;
    private boolean siteCredentials;
    private String databaseType;
    private String jdbcHostname;
    private String jdbcPort;
    private String jdbcUsername;
    private String jdbcPassword;
    private String jdbcDatabase;
    private String jdbcAdvanced;

    public ImporterSetupPage(UsageTrackingService usageTrackingService, ConfigFileHandler configFileHandler, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, BackCompatibilityUtil backCompatibilityUtil) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor);
        this.configFileHandler = configFileHandler;
        this.backCompatibilityUtil = backCompatibilityUtil;
    }

    public boolean isMySqlAvailable() {
        return JdbcConnection.isValidDriverName(this.backCompatibilityUtil.getDriverClassName("mysql"));
    }

    public Map<String, String> getDatabaseTypes() {
        HashMap selectList = Maps.newHashMap();
        selectList.put("", this.getText("setupdb.database.selectType"));
        selectList.put("postgres72", "PostgreSQL");
        selectList.put("mysql", "MySQL");
        selectList.put("mssql", "Microsoft SQL Server");
        return selectList;
    }

    public String getDatabaseTypeEnum() {
        return this.databaseType;
    }

    @Override
    protected void doValidation() {
        if (this.isPreviousClicked()) {
            return;
        }
        super.doValidation();
        if (!this.configFileHandler.verifyConfigFileParam(this)) {
            return;
        }
        if (StringUtils.isEmpty((String)this.databaseType)) {
            this.addError("databaseType", this.getText("setupdb.error.selectDatabaseType"));
        }
        if (StringUtils.isEmpty((String)this.jdbcHostname)) {
            this.addError("jdbcHostname", this.getText("setupdb.error.requireJdbcHostname"));
        }
        if (StringUtils.isEmpty((String)this.jdbcPort)) {
            this.addError("jdbcPort", this.getText("setupdb.error.requireJdbcPort"));
        }
        if (StringUtils.isEmpty((String)this.jdbcDatabase)) {
            this.addError("jdbcDatabase", this.getText("setupdb.error.requireDatabase"));
        }
        if (StringUtils.isEmpty((String)this.jdbcUsername)) {
            this.addError("jdbcUsername", this.getText("setupdb.error.requireJdbcUsername"));
        }
    }

    @Override
    protected String doExecute() throws Exception {
        ImporterController controller = this.getController();
        if (controller == null) {
            return "restartimporterneeded";
        }
        this.publishImporterWizardStartedEvent();
        if (!this.isPreviousClicked() && !controller.createImportProcessBean(this)) {
            return "input";
        }
        if (this.isNextClicked()) {
            SessionConnectionConfiguration.setCurrentSession(this.getExternalSystem(), new SessionConnectionConfiguration(new JdbcConfiguration(this.getDatabaseType(), this.getJdbcHostname(), this.getJdbcPort(), this.getJdbcDatabase(), this.getJdbcUsername(), this.getJdbcPassword(), this.getJdbcAdvanced()), new SiteConfiguration(this.getSiteUrl(), this.getSiteCredentials(), this.getSiteUsername(), this.getSitePassword())));
        }
        return super.doExecute();
    }

    @Override
    public String doDefault() throws Exception {
        String view = super.doDefault();
        if (!"input".equals(view)) {
            return view;
        }
        SessionConnectionConfiguration scc = SessionConnectionConfiguration.getCurrentSession(this.getExternalSystem());
        if (scc != null) {
            JdbcConfiguration jdbcConfiguration = scc.getJdbcConfiguration();
            SiteConfiguration urlBean = scc.getSiteConfiguration();
            if (jdbcConfiguration != null) {
                this.setDatabaseType(jdbcConfiguration.getDatabaseType());
                this.setJdbcHostname(jdbcConfiguration.getJdbcHostname());
                this.setJdbcPort(jdbcConfiguration.getJdbcPort());
                this.setJdbcDatabase(jdbcConfiguration.getJdbcDatabase());
                this.setJdbcUsername(jdbcConfiguration.getJdbcUsername());
                this.setJdbcPassword(jdbcConfiguration.getJdbcPassword());
                this.setJdbcAdvanced(jdbcConfiguration.getJdbcAdvanced());
            }
            if (urlBean != null) {
                this.setSiteUrl(urlBean.getUrl());
                this.setSiteUsername(urlBean.getUsername());
                this.setSitePassword(urlBean.getPassword());
                this.setSiteCredentials(urlBean.isUseCredentials());
            }
        }
        return "input";
    }

    @Override
    public String getSiteUrl() {
        return this.siteUrl;
    }

    @Override
    public void setSiteUrl(String siteUrl) {
        this.siteUrl = StringUtils.trim((String)siteUrl);
    }

    @Override
    public String getSiteUsername() {
        return this.siteUsername;
    }

    @Override
    public void setSiteUsername(String siteUsername) {
        this.siteUsername = StringUtils.trim((String)siteUsername);
    }

    @Override
    public String getSitePassword() {
        return this.sitePassword;
    }

    @Override
    public void setSitePassword(String sitePassword) {
        this.sitePassword = StringUtils.trim((String)sitePassword);
    }

    @Override
    public boolean getSiteCredentials() {
        return this.siteCredentials;
    }

    public void setSiteCredentials(boolean siteCredentials) {
        this.siteCredentials = siteCredentials;
    }

    public String getJdbcHostname() {
        return this.jdbcHostname;
    }

    public void setJdbcHostname(String jdbcHostname) {
        this.jdbcHostname = StringUtils.trim((String)jdbcHostname);
    }

    public String getJdbcUsername() {
        return this.jdbcUsername;
    }

    public void setJdbcUsername(String jdbcUsername) {
        this.jdbcUsername = StringUtils.trim((String)jdbcUsername);
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = StringUtils.trim((String)jdbcPassword);
    }

    public String getJdbcDatabase() {
        return this.jdbcDatabase;
    }

    public void setJdbcDatabase(String databaseName) {
        this.jdbcDatabase = StringUtils.trim((String)databaseName);
    }

    @Override
    public boolean isSiteUrlRequired() {
        return false;
    }

    @Override
    public String getLoginLabel() {
        return this.getText("jira-importer-plugin.site.login.name", this.getTitle());
    }

    @Override
    public String getPasswordLabel() {
        return this.getText("jira-importer-plugin.site.login.password", this.getTitle());
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public String getJdbcPort() {
        return this.jdbcPort;
    }

    public void setJdbcPort(String databasePort) {
        this.jdbcPort = StringUtils.trim((String)databasePort);
    }

    public String getJdbcAdvanced() {
        return this.jdbcAdvanced;
    }

    public void setJdbcAdvanced(String jdbcAdvanced) {
        this.jdbcAdvanced = StringUtils.trim((String)jdbcAdvanced);
    }
}

