/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugins.importer.external.beans.ExternalProject;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.jira.plugins.importer.managers.CreateProjectManager;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.ImporterProcessSupport;
import com.atlassian.jira.plugins.importer.web.components.ProjectMappingComponent;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class ImporterProjectMappingsPage
extends ImporterProcessSupport.Database {
    public static final ProjectAction REQUIRED_PROJECT_PERMISSION = ProjectAction.EDIT_PROJECT_CONFIG;
    protected final ProjectService projectService;
    protected final ProjectMappingComponent mappingComponent;
    private final CreateProjectManager createProjectManager;
    private final Helper helper;
    private String projectMapping;

    public ImporterProjectMappingsPage(UsageTrackingService usageTrackingService, @ComponentImport ProjectService projectService, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport ProjectManager projectManager, CreateProjectManager createProjectManager) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor);
        this.projectService = projectService;
        this.createProjectManager = createProjectManager;
        this.helper = new Helper(projectService, ComponentAccessor.getJiraAuthenticationContext().getUser());
        this.mappingComponent = new ProjectMappingComponent(projectManager, ComponentAccessor.getJiraAuthenticationContext());
    }

    @Override
    @RequiresXsrfCheck
    protected void doValidation() {
        super.doValidation();
        if (this.isPreviousClicked() || this.getConfigBean() == null) {
            return;
        }
        this.populateProjectKeyMappings();
    }

    @Override
    protected void prepareComponents() {
        AbstractConfigBean2 configBean = (AbstractConfigBean2)Preconditions.checkNotNull((Object)this.getConfigBean());
        this.mappingComponent.setConfigBean(configBean);
        this.mappingComponent.setApplicableProjects(this.helper.getExistingProjects());
        this.mappingComponent.setCanCreateNewProjects(this.createProjectManager.canCreateProjects(ComponentAccessor.getJiraAuthenticationContext().getUser()));
        this.mappingComponent.setProjectValidation(new ProjectMappingComponent.ProjectValidation(){

            @Override
            public void validateProject(String externalProjectName, ExternalProject mapping) {
                ImporterProjectMappingsPage.this.validateProject(externalProjectName, mapping);
            }
        });
    }

    public void populateProjectKeyMappings() {
        ServiceResult serviceResult = this.mappingComponent.processProjectSelection(this.projectMapping);
        this.addErrorCollection(serviceResult.getErrorCollection());
    }

    protected void validateProject(String fieldId, ExternalProject project) {
    }

    public ProjectMappingComponent getMappingComponent() {
        return this.mappingComponent;
    }

    public void setProjectMapping(String projectMapping) {
        this.projectMapping = projectMapping;
    }

    @Override
    public String getFormTitle() {
        return this.getText("jira-importer-plugin.wizard.projectmappings.title");
    }

    @Override
    public String getFormDescription() {
        return this.getText("jira-importer-plugin.wizard.projectmappings.description", this.getTitle());
    }

    @Override
    @Nonnull
    public Iterable<String> getRequiredResources() {
        return ImmutableList.of((Object)"com.atlassian.jira.plugins.jira-importers-plugin:importerProjectMappingsPage");
    }

    public static String getProjectFieldId(String projectName) {
        return ProjectMappingComponent.getProjectFieldId(projectName);
    }

    public List<String> getProjectNamesFromDb() {
        return this.mappingComponent.getExternalProjects();
    }

    public boolean isCreateProjectsEnabled() {
        return this.mappingComponent.isCanCreateNewProjects();
    }

    public String getProjectSuggestionsModel() {
        return this.mappingComponent.getProjectsSuggestionsModel();
    }

    public String getProjectMappingModel() {
        return this.mappingComponent.getExternalProjectsModel();
    }

    public static class Helper {
        private final ProjectService projectService;
        private final ApplicationUser user;

        public Helper(ProjectService projectService, ApplicationUser user) {
            this.projectService = projectService;
            this.user = user;
        }

        public Collection<Project> getExistingProjects() {
            ServiceOutcome allProjectsForAction = this.projectService.getAllProjectsForAction(this.user, REQUIRED_PROJECT_PERMISSION);
            return (Collection)allProjectsForAction.getReturnedValue();
        }

        public Set<String> getExistingProjectKeys() {
            return ImmutableSet.copyOf((Iterable)Iterables.transform(this.getExistingProjects(), (Function)new Function<Project, String>(){

                public String apply(Project project) {
                    return project.getKey();
                }
            }));
        }
    }
}

