/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugins.importer.SQLRuntimeException;
import com.atlassian.jira.plugins.importer.analytics.WizardStartedEvent;
import com.atlassian.jira.plugins.importer.extensions.ExternalSystemImporterModuleDescriptor;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.extensions.ImporterController2;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractConfigBean2;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.ImporterLogsPage;
import com.atlassian.jira.plugins.importer.web.TextsUtil;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.BrowserUtils;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.tools.generic.EscapeTool;
import org.apache.velocity.tools.generic.SortTool;
import webwork.action.ActionContext;

public abstract class ImporterProcessSupport
extends JiraWebActionSupport {
    protected static final String RESTART_NEEDED = "restartimporterneeded";
    private static final String STEP_I18N_FINAL = ImporterLogsPage.class.getSimpleName();
    private String externalSystem;
    public static final String BUTTON_NAME_NEXT = "nextBtn";
    public static final String BUTTON_NAME_PREVIOUS = "previousBtn";
    private String submitBtn;
    private String finishButton;
    private final Map<String, String> htmlHints = Maps.newHashMap();
    private final UsageTrackingService usageTrackingService;
    private final PluginAccessor pluginAccessor;

    public ImporterProcessSupport(UsageTrackingService usageTrackingService, WebInterfaceManager webInterfaceManager, PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
        this.usageTrackingService = usageTrackingService;
        usageTrackingService.includeTrackingWhenActive();
    }

    public final int getTotalSteps() {
        ImporterController controller = this.getController();
        return controller != null ? controller.getSteps().size() : 0;
    }

    public int getCurrentStep() {
        String actionName = this.getActionName();
        ImporterController controller = this.getController();
        List<Object> steps = controller == null ? Lists.newArrayList() : controller.getSteps();
        return (STEP_I18N_FINAL.equals(actionName) ? steps.size() : steps.indexOf(actionName)) + 1;
    }

    @Nonnull
    public String getCurrentStepName() {
        List<String> steps = this.getController().getStepNameKeys();
        return this.getText(steps.get(this.getCurrentStep() - 1));
    }

    public void setExternalSystem(String system) {
        if (this.pluginAccessor.getEnabledPluginModule(system) == null) {
            throw new RuntimeException("unknown importer type [" + system + "]");
        }
        this.externalSystem = system;
    }

    @Nullable
    public String getExternalSystem() {
        return this.externalSystem;
    }

    protected boolean isPreviousClicked() {
        return this.isButtonClickedByName(BUTTON_NAME_PREVIOUS);
    }

    protected boolean isNextClicked() {
        return this.isButtonClickedByName(BUTTON_NAME_NEXT);
    }

    protected boolean isFinishClicked() {
        return this.isNextClicked() && this.getCurrentStep() >= this.getTotalSteps();
    }

    protected boolean isButtonClickedByName(String name) {
        return StringUtils.isNotBlank((String)ParameterUtils.getStringParam((Map)ActionContext.getParameters(), (String)name));
    }

    public String getSubmitBtn() {
        return this.submitBtn;
    }

    public void setSubmitBtn(String submitBtn) {
        this.submitBtn = submitBtn;
    }

    public String getFinishButton() {
        return this.finishButton;
    }

    public void setFinishButton(String finishButton) {
        this.finishButton = finishButton;
    }

    public String execute() throws Exception {
        String result;
        this.prepareComponents();
        try {
            result = super.execute();
        }
        catch (SQLRuntimeException e) {
            this.log.error((Object)"Unexpected exception", (Throwable)e);
            this.addErrorMessage("Unexpected exception: " + e.getMessage());
            result = "input";
        }
        if ("input".equals(result)) {
            try {
                this.prepareModel();
            }
            catch (SQLRuntimeException e) {
                this.log.error((Object)"Unexpected exception", (Throwable)e);
                this.addErrorMessage("Unexpected exception: " + e.getMessage());
            }
        }
        return result;
    }

    protected void prepareComponents() {
    }

    protected void prepareModel() throws Exception {
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ImporterController controller = this.getController();
        if (controller == null) {
            return RESTART_NEEDED;
        }
        int currentStep = controller.getSteps().indexOf(this.getActionName());
        if (this.isPreviousClicked()) {
            --currentStep;
        } else if (!this.isFinishClicked() && this.isNextClicked()) {
            ++currentStep;
        }
        if (this.isFinishClicked()) {
            return this.getRedirect(this.getRedirectURL(this.getProgressPage()));
        }
        String redirect = currentStep >= 0 ? controller.getSteps().get(currentStep) + "!default.jspa?externalSystem=" + this.getExternalSystem() : this.getHomePage();
        this.publishEvent(currentStep);
        return this.getRedirect(this.getImporterBaseUrlWithSlash() + redirect);
    }

    private String getHomePage() {
        return this.isAdministrator() ? "ExternalImport1.jspa" : "";
    }

    private String getProgressPage() {
        return this.getController2() != null ? this.getController2().getProgressPageName() : "ImporterLogsPage!import.jspa";
    }

    @Nullable
    public ImporterController2 getController2() {
        ImporterController controller = this.getController();
        return controller instanceof ImporterController2 ? (ImporterController2)controller : null;
    }

    private void publishEvent(int currentStep) {
        EventPublisher eventPublisher = (EventPublisher)ComponentAccessor.getComponent(EventPublisher.class);
        ImporterController controller = this.getController();
        if (eventPublisher == null || controller == null) {
            return;
        }
        if (currentStep == 1) {
            eventPublisher.publish((Object)new WizardStartedEvent(controller.getId()));
        }
    }

    public final boolean isExternalUserManagementEnabled() {
        return this.getApplicationProperties().getOption("jira.option.user.externalmanagement");
    }

    public ResourceBundle getTexts(String bundleName) {
        return TextsUtil.getTexts(this, bundleName);
    }

    public BrowserUtils getBrowserUtils() {
        return new BrowserUtils();
    }

    public HelpUtil getHelpUtil() {
        return HelpUtil.getInstance();
    }

    @HtmlSafe
    public EscapeTool getEsc() {
        return new EscapeTool();
    }

    public EasyList getList() {
        return new EasyList();
    }

    public TextsUtil getJimTextUtils() {
        return new TextsUtil();
    }

    public String getTitle() {
        Optional<ExternalSystemImporterModuleDescriptor> moduleDescriptor = this.getModuleDescriptor();
        return moduleDescriptor.isPresent() ? ((ExternalSystemImporterModuleDescriptor)((Object)moduleDescriptor.get())).getName() : null;
    }

    @Nullable
    public ImporterController getController() {
        Optional<ExternalSystemImporterModuleDescriptor> moduleDescriptor = this.getModuleDescriptor();
        return moduleDescriptor.isPresent() ? (ImporterController)((ExternalSystemImporterModuleDescriptor)((Object)moduleDescriptor.get())).getModule() : null;
    }

    protected void doValidation() {
        super.doValidation();
        if (this.isNextClicked() && this.getCurrentStep() + 1 == this.getTotalSteps() && this.getController() != null && this.getController().getImportProcessBeanFromSession() != null && this.getController().getImportProcessBeanFromSession().getConfigBean() != null) {
            this.getController().getImportProcessBeanFromSession().getConfigBean().validateJustBeforeImport((ErrorCollection)this);
        }
    }

    public String doDefault() throws Exception {
        if (!this.canSeePage()) {
            return "denied";
        }
        if (this.getController() == null || this.getController().getImportProcessBeanFromSession() == null) {
            return RESTART_NEEDED;
        }
        return super.doDefault();
    }

    protected boolean canSeePage() {
        ApplicationUser user = this.getLoggedInApplicationUser();
        return user != null && (this.isNonAdminImporter() || this.isAdministrator());
    }

    public boolean isNonAdminImporter() {
        Optional<ExternalSystemImporterModuleDescriptor> moduleDescriptor = this.getModuleDescriptor();
        if (moduleDescriptor.isPresent()) {
            return ((ExternalSystemImporterModuleDescriptor)((Object)moduleDescriptor.get())).isNonAdmin();
        }
        return false;
    }

    protected Optional<ExternalSystemImporterModuleDescriptor> getModuleDescriptor() {
        try {
            return Optional.fromNullable((Object)((Object)((ExternalSystemImporterModuleDescriptor)this.pluginAccessor.getEnabledPluginModule(this.getExternalSystem()))));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public void addErrorMessage(String errorMessage, String htmlHint) {
        this.addErrorMessage(errorMessage);
        this.htmlHints.put(errorMessage, htmlHint);
    }

    public void addErrorMessages(Map<String, String> errorMessages) {
        this.htmlHints.clear();
        super.addErrorMessages(errorMessages.keySet());
        this.htmlHints.putAll(errorMessages);
    }

    public String getHtmlHint(String errorMessage) {
        return this.htmlHints.get(errorMessage);
    }

    public SortTool getSorter() {
        return new SortTool();
    }

    public boolean isAdministrator() {
        return this.hasPermission(0);
    }

    public boolean isAttachmentsEnabled() {
        return this.getApplicationProperties().getOption("jira.option.allowattachments");
    }

    public boolean isSubtasksEnabled() {
        return this.getApplicationProperties().getOption("jira.option.allowsubtasks");
    }

    public UsageTrackingService getUsageTrackingService() {
        return this.usageTrackingService;
    }

    @Nullable
    public String getWizardActiveSection() {
        ImporterController controller = this.getController();
        return controller != null ? controller.getSection() : null;
    }

    public String getWizardActiveTab() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    @Nullable
    public abstract String getFormTitle();

    @Nullable
    public String getFormDescription() {
        return null;
    }

    public boolean isRunningOnDemand() {
        return ((FeatureManager)ComponentAccessor.getComponent(FeatureManager.class)).isEnabled(CoreFeatures.ON_DEMAND);
    }

    @Nonnull
    public SoyTemplateRenderer getSoyRenderer() {
        return ((SoyTemplateRendererProvider)ComponentAccessor.getOSGiComponentInstanceOfType(SoyTemplateRendererProvider.class)).getRenderer();
    }

    @Nonnull
    public List<Map<String, Object>> getStepsProgress() {
        List<String> steps = this.getController().getStepNameKeys();
        ArrayList progress = Lists.newArrayListWithExpectedSize((int)steps.size());
        int s = steps.size();
        for (int i = 0; i < s; ++i) {
            progress.add(ImmutableMap.of((Object)"text", (Object)this.getText(steps.get(i)), (Object)"isCurrent", (Object)(i + 1 == this.getCurrentStep() ? 1 : 0)));
        }
        return progress;
    }

    @Nonnull
    public Iterable<String> getRequiredResources() {
        return Collections.emptyList();
    }

    public String getImporterBaseUrlWithSlash() {
        HttpServletRequest httpRequest = this.getHttpRequest();
        String requestUrl = httpRequest.getRequestURL().toString();
        String url = requestUrl.replace(httpRequest.getRequestURI(), httpRequest.getContextPath()) + "/secure/";
        return this.isAdministrator() ? url + "admin/" : url;
    }

    @Nonnull
    public String getRedirectURL(String path) {
        UrlBuilder builder = new UrlBuilder(this.getImporterBaseUrlWithSlash());
        builder.addPath(path);
        builder.addParameter("externalSystem", this.getExternalSystem());
        builder.addParameter("atl_token", this.getXsrfToken());
        return builder.asUrlString();
    }

    public static abstract class Database
    extends ImporterProcessSupport {
        public Database(UsageTrackingService usageTrackingService, WebInterfaceManager webInterfaceManager, PluginAccessor pluginAccessor) {
            super(usageTrackingService, webInterfaceManager, pluginAccessor);
        }

        @Nullable
        public AbstractConfigBean2 getConfigBean() {
            try {
                if (this.getController() == null || this.getController().getImportProcessBeanFromSession() == null) {
                    return null;
                }
                return (AbstractConfigBean2)this.getController().getImportProcessBeanFromSession().getConfigBean();
            }
            catch (ClassCastException e) {
                return null;
            }
        }
    }
}

