/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugins.importer.compatibility.CompatibilityBridgeUtils;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.extensions.ImporterController2;
import com.atlassian.jira.plugins.importer.imports.importer.ImportDataBean;
import com.atlassian.jira.plugins.importer.imports.importer.ImportLogger;
import com.atlassian.jira.plugins.importer.imports.importer.ImportStageStats;
import com.atlassian.jira.plugins.importer.imports.importer.ImportStats;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ImporterCallable;
import com.atlassian.jira.plugins.importer.imports.importer.impl.ImporterExecutionContext;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import com.atlassian.jira.plugins.importer.web.ImporterProcessSupport;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.sal.api.websudo.WebSudoNotRequired;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

@WebSudoNotRequired
public class ImporterLogsPage
extends ImporterProcessSupport {
    private final TaskManager taskManager;
    private final FeatureManager featureManager;
    private final CompatibilityBridgeUtils bridgeUtils;

    public ImporterLogsPage(UsageTrackingService usageTrackingService, @ComponentImport TaskManager taskManager, @ComponentImport WebInterfaceManager webInterfaceManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport FeatureManager featureManager, CompatibilityBridgeUtils bridgeUtils) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor);
        this.taskManager = taskManager;
        this.featureManager = featureManager;
        this.bridgeUtils = bridgeUtils;
    }

    public String doViewLogs() throws Exception {
        return this.doExecute();
    }

    @Override
    public String doDefault() throws Exception {
        return this.doExecute();
    }

    @Override
    protected String doExecute() throws Exception {
        if (!this.canSeePage()) {
            return "denied";
        }
        if (this.getImporter() != null && this.getImporter().getStats() != null) {
            if (this.getImporter().isRunning()) {
                return "logs";
            }
            return this.redirectToTheNextStep();
        }
        return "restartimporterneeded";
    }

    private String getFinishPage() {
        ImporterController2 controller2 = this.getController2();
        return controller2 != null ? controller2.getFinishedPageName() : "ImporterFinishedPage!default.jspa";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresXsrfCheck
    public String doImport() {
        ImportProcessBean bean;
        JiraDataImporter importer = this.getImporter();
        ImporterController controller = this.getController();
        ImportProcessBean importProcessBean = bean = controller != null ? controller.getImportProcessBeanFromSession() : null;
        if (importer == null || bean == null) {
            return "restartimporterneeded";
        }
        JiraDataImporter jiraDataImporter = importer;
        synchronized (jiraDataImporter) {
            block11: {
                if (!importer.isRunning()) {
                    ImportLogger importerLog;
                    block10: {
                        importer.initializeLog();
                        try {
                            ImportDataBean dataBean = controller.createDataBean();
                            importer.setDataBean(dataBean);
                        }
                        catch (Exception e) {
                            importerLog = importer.getLog();
                            if (importerLog == null) break block10;
                            importerLog.fail(e, "Failed to create data bean", new Object[0]);
                        }
                    }
                    if (importer.getDataBean() != null) {
                        try {
                            TaskDescriptor e = this.taskManager.submitTask((Callable)new ImporterCallable(importer, new ImporterExecutionContext(controller.getId(), this.getLoggedInApplicationUser())), "JIRA Importers Plugin Main Import Task", (TaskContext)new EmptyTaskContext());
                        }
                        catch (Exception e) {
                            importerLog = importer.getLog();
                            if (importerLog == null) break block11;
                            importerLog.fail(e, "Failed to start import", new Object[0]);
                        }
                    }
                }
            }
        }
        return this.getRedirect(this.getRedirectURL("ImporterLogsPage!viewLogs.jspa"));
    }

    private String redirectToTheNextStep() {
        if (this.rolesEnabled() && this.anyUserCreated() && this.isBtf() && !this.isNonAdminImporter()) {
            return this.getRedirect(this.getRedirectURL("ImporterUserAccessPage.jspa"));
        }
        return this.getRedirect(this.getRedirectURL(this.getFinishPage()));
    }

    private boolean rolesEnabled() {
        return this.bridgeUtils.rolesEnabled();
    }

    private boolean isBtf() {
        return !this.featureManager.isOnDemand();
    }

    private boolean anyUserCreated() {
        ImportStageStats userStage = this.getImporter().getStats().getStage(ImportStats.Stage.USERS);
        return userStage.getItemsCreated() > 0;
    }

    @Nullable
    public JiraDataImporter getImporter() {
        ImporterController controller = this.getController();
        return controller != null ? controller.getImporter() : null;
    }

    @Override
    public String getFormTitle() {
        if (this.getImporter().isAborted()) {
            return this.getText("jira-importer-plugin.ImporterLogsPage.stopping");
        }
        return this.getText("jira-importer-plugin.ImporterLogsPage.title", this.getImporter().getSelectedProjects().size());
    }

    @Override
    public String getFormDescription() {
        return this.getText("jira-importer-plugin.ImporterLogsPage.projects.imported", this.getTitle());
    }

    private static final class EmptyTaskContext
    implements TaskContext {
        private EmptyTaskContext() {
        }

        public String buildProgressURL(Long taskId) {
            return null;
        }
    }
}

