/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web;

import com.atlassian.core.util.FileSize;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugins.importer.analytics.WizardOpenedEvent;
import com.atlassian.jira.plugins.importer.extensions.ExternalSystemImporterModuleDescriptor;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.tracking.UsageTrackingService;
import com.atlassian.jira.plugins.importer.web.ImporterProcessSupport;
import com.atlassian.jira.plugins.importer.web.onboarding.ImporterKeyFormatter;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.base.Optional;
import webwork.action.ServletActionContext;
import webwork.config.Configuration;
import webwork.multipart.MultiPartRequestWrapper;

public abstract class AbstractSetupPage
extends ImporterProcessSupport {
    private final EventPublisher eventPublisher;
    private boolean useConfigFile;
    private boolean onboarding = false;

    @Deprecated
    public AbstractSetupPage(UsageTrackingService usageTrackingService, WebInterfaceManager webInterfaceManager, PluginAccessor pluginAccessor) {
        this(usageTrackingService, webInterfaceManager, pluginAccessor, (EventPublisher)ComponentAccessor.getComponent(EventPublisher.class));
    }

    public AbstractSetupPage(UsageTrackingService usageTrackingService, WebInterfaceManager webInterfaceManager, PluginAccessor pluginAccessor, EventPublisher eventPublisher) {
        super(usageTrackingService, webInterfaceManager, pluginAccessor);
        this.eventPublisher = eventPublisher;
    }

    public void setOnboarding(boolean onboarding) {
        this.onboarding = onboarding;
    }

    public boolean isOnboarding() {
        return this.onboarding;
    }

    public boolean isIssueLinkingEnabled() {
        return this.getApplicationProperties().getOption("jira.option.issuelinking");
    }

    public boolean getTimeTrackingEnabled() {
        return ComponentAccessor.getFieldManager().isTimeTrackingOn();
    }

    public MultiPartRequestWrapper getMultipart() {
        return ServletActionContext.getMultiPartRequest();
    }

    public Long getAttachmentSize() {
        return new Long(Configuration.getString((String)"webwork.multipart.maxSize"));
    }

    public String getAttachmentSizeFormatted() {
        return FileSize.format((Long)this.getAttachmentSize());
    }

    public FileSize getFileSize() {
        return new FileSize();
    }

    @Override
    public String getFormTitle() {
        return this.getTitle() + " " + this.getText("jira-importer-plugin.external.mappings.setup");
    }

    public void setUseConfigFile(boolean useConfigFile) {
        this.useConfigFile = useConfigFile;
    }

    public boolean getUseConfigFile() {
        return this.useConfigFile;
    }

    @Deprecated
    protected void publishImporterWizardStartedEvent() {
    }

    @Override
    public String doDefault() throws Exception {
        if (!this.canSeePage()) {
            return "denied";
        }
        ImporterController controller = this.getController();
        if (controller == null) {
            return "restartimporterneeded";
        }
        if (!"CSV".equals(controller.getId())) {
            this.eventPublisher.publish((Object)new WizardOpenedEvent(ImporterKeyFormatter.getImporterId(controller.getId()), null, this.isOnboarding()));
        }
        return "input";
    }

    public String getDocumentationUrl() {
        Optional<ExternalSystemImporterModuleDescriptor> moduleDescriptor = this.getModuleDescriptor();
        return moduleDescriptor.isPresent() ? ((ExternalSystemImporterModuleDescriptor)((Object)moduleDescriptor.get())).getDocumentationUrl() : null;
    }
}

