/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugins.importer.extensions.ImporterController;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpSession;
import webwork.action.ActionContext;

public abstract class AbstractImporterController
implements ImporterController {
    private final JiraDataImporter importer;
    private final String sessionAttributeName;
    private final String id;

    public AbstractImporterController(JiraDataImporter importer, String sessionAttributeName, String id) {
        this.importer = importer;
        this.sessionAttributeName = sessionAttributeName;
        this.id = id;
    }

    @Override
    public JiraDataImporter getImporter() {
        return this.importer;
    }

    @Override
    public boolean isUsingConfiguration() {
        return true;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getSection() {
        boolean isOnDemand = ((FeatureManager)ComponentAccessor.getComponent(FeatureManager.class)).isEnabled(CoreFeatures.ON_DEMAND);
        return "admin_system_menu/JIMMainSection/" + (isOnDemand ? "Studio" : this.getId());
    }

    public void storeImportProcessBeanInSession(@Nullable ImportProcessBean bean) {
        ActionContext.getSession().put(this.sessionAttributeName, bean);
    }

    @Override
    public ImportProcessBean getImportProcessBeanFromSession() {
        try {
            return (ImportProcessBean)ActionContext.getSession().get(this.sessionAttributeName);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public ImportProcessBean getImportProcessBean(HttpSession session) {
        try {
            return (ImportProcessBean)session.getAttribute(this.sessionAttributeName);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Nonnull
    public String getSessionAttributeName() {
        return this.sessionAttributeName;
    }
}

