/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.importer.web;

import com.atlassian.jira.plugins.importer.BackCompatibilityUtil;
import com.atlassian.jira.plugins.importer.imports.importer.AbstractDatabaseConfigBean;
import com.atlassian.jira.plugins.importer.imports.importer.JiraDataImporter;
import com.atlassian.jira.plugins.importer.web.AbstractImporterController;
import com.atlassian.jira.plugins.importer.web.AbstractSetupPage;
import com.atlassian.jira.plugins.importer.web.ConfigFileHandler;
import com.atlassian.jira.plugins.importer.web.ImportProcessBean;
import com.atlassian.jira.plugins.importer.web.ImporterCustomFieldsPage;
import com.atlassian.jira.plugins.importer.web.ImporterFieldMappingsPage;
import com.atlassian.jira.plugins.importer.web.ImporterLinksPage;
import com.atlassian.jira.plugins.importer.web.ImporterProjectMappingsPage;
import com.atlassian.jira.plugins.importer.web.ImporterSetupPage;
import com.atlassian.jira.plugins.importer.web.ImporterValueMappingsPage;
import com.atlassian.jira.plugins.importer.web.JdbcConnection;
import com.atlassian.jira.plugins.importer.web.SiteConfiguration;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractDatabaseImporterController
extends AbstractImporterController {
    private final ConfigFileHandler configFileHandler;
    private final BackCompatibilityUtil backCompatibilityUtil;

    protected abstract AbstractDatabaseConfigBean createConfigBean(JdbcConnection var1);

    protected abstract void validateConnection(ImporterSetupPage var1);

    protected JdbcConnection createDatabaseConnectionBean(ImporterSetupPage importerSetupPage) {
        try {
            String url = this.backCompatibilityUtil.getDatabaseUrl(importerSetupPage.getDatabaseType(), importerSetupPage.getJdbcHostname(), importerSetupPage.getJdbcPort(), importerSetupPage.getJdbcDatabase());
            String driverClassName = this.backCompatibilityUtil.getDriverClassName(importerSetupPage.getDatabaseType());
            if (StringUtils.isNotEmpty((String)importerSetupPage.getJdbcAdvanced())) {
                String sep = "net.sourceforge.jtds.jdbc.Driver".equals(driverClassName) || "com.microsoft.sqlserver.jdbc.SQLServerDriver".equals(driverClassName) ? ";" : (url.contains("?") ? "&" : "?");
                url = url + sep + importerSetupPage.getJdbcAdvanced();
            }
            return new JdbcConnection(driverClassName, url, importerSetupPage.getJdbcUsername(), importerSetupPage.getJdbcPassword());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean createImportProcessBean(AbstractSetupPage setupPage) {
        ImporterSetupPage importerSetupPage = (ImporterSetupPage)setupPage;
        JdbcConnection jdbcConnection = this.createDatabaseConnectionBean(importerSetupPage);
        jdbcConnection.validateConnection((ErrorCollection)setupPage);
        this.validateConnection(importerSetupPage);
        ImportProcessBean importBean = new ImportProcessBean();
        SiteConfiguration siteConfiguration = new SiteConfiguration(importerSetupPage.getSiteUrl(), importerSetupPage.getSiteCredentials(), importerSetupPage.getSiteUsername(), importerSetupPage.getSitePassword());
        importBean.setUrlBean(siteConfiguration);
        if (!importerSetupPage.hasAnyErrors()) {
            AbstractDatabaseConfigBean configBean = this.createConfigBean(jdbcConnection);
            if (!this.configFileHandler.populateFromConfigFile(importerSetupPage, configBean)) {
                return false;
            }
            importBean.setJdbcConnection(jdbcConnection);
            importBean.setConfigBean(configBean);
        }
        this.storeImportProcessBeanInSession(importBean);
        return !importerSetupPage.hasAnyErrors();
    }

    public AbstractDatabaseImporterController(ConfigFileHandler configFileHandler, JiraDataImporter importer, String sessionAttributeName, String id, BackCompatibilityUtil backCompatibilityUtil) {
        super(importer, sessionAttributeName, id);
        this.configFileHandler = configFileHandler;
        this.backCompatibilityUtil = backCompatibilityUtil;
    }

    @Override
    public List<String> getSteps() {
        return Lists.newArrayList((Object[])new String[]{ImporterSetupPage.class.getSimpleName(), ImporterProjectMappingsPage.class.getSimpleName(), ImporterCustomFieldsPage.class.getSimpleName(), ImporterFieldMappingsPage.class.getSimpleName(), ImporterValueMappingsPage.class.getSimpleName(), ImporterLinksPage.class.getSimpleName()});
    }

    @Override
    public List<String> getStepNameKeys() {
        return Lists.newArrayList((Object[])new String[]{"jira-importer-plugin.wizard.step.ImporterSetupPage", "jira-importer-plugin.wizard.step.ImporterProjectMappingsPage", "jira-importer-plugin.wizard.step.ImporterCustomFieldsPage", "jira-importer-plugin.wizard.step.ImporterFieldMappingsPage", "jira-importer-plugin.wizard.step.ImporterValueMappingsPage", "jira-importer-plugin.wizard.step.ImporterLinksPage"});
    }
}

